/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import org.apache.fop.area.Area;
import org.apache.fop.area.inline.InlineArea;
import org.apache.fop.area.inline.InlineParent;
import org.apache.fop.area.inline.Space;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyManager;
import org.apache.fop.layout.BackgroundProps;
import org.apache.fop.layout.BorderAndPadding;
import org.apache.fop.layoutmgr.AbstractLayoutManager;
import org.apache.fop.layoutmgr.BreakPoss;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.LayoutManager;
import org.apache.fop.layoutmgr.LayoutProcessor;
import org.apache.fop.layoutmgr.MinOptMax;
import org.apache.fop.layoutmgr.NonLeafPosition;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.PositionIterator;
import org.apache.fop.layoutmgr.SpaceSpecifier;
import org.apache.fop.layoutmgr.TraitSetter;
import org.apache.fop.traits.InlineProps;

public class InlineStackingLayoutManager
extends AbstractLayoutManager {
    private MinOptMax allocIPD = new MinOptMax(0);
    private MinOptMax extraBPD;
    private InlineProps inlineProps = null;
    private BorderAndPadding borderProps = null;
    private BackgroundProps backgroundProps;
    private Area currentArea;
    private BreakPoss prevBP;
    private LayoutContext childLC;
    private LayoutManager lastChildLM = null;
    private boolean bAreaCreated = false;
    private HashMap hmPrevIPD = new HashMap();

    public void setFObj(FObj fo) {
        this.fobj = fo;
        this.foID = this.fobj.getID();
        this.childLMiter = null;
    }

    public void setLMiter(ListIterator iter) {
        this.childLMiter = iter;
    }

    public boolean generatesInlineAreas() {
        return true;
    }

    protected void initProperties(PropertyManager propMgr) {
        this.inlineProps = propMgr.getInlineProps();
        this.borderProps = propMgr.getBorderAndPadding();
        int iPad = this.borderProps.getPadding(0, false);
        iPad += this.borderProps.getBorderWidth(0, false);
        iPad += this.borderProps.getPadding(1, false);
        this.extraBPD = new MinOptMax(iPad += this.borderProps.getBorderWidth(1, false));
        this.backgroundProps = propMgr.getBackgroundProps();
    }

    private MinOptMax getExtraIPD(boolean bNotFirst, boolean bNotLast) {
        int iBP = this.borderProps.getPadding(2, bNotFirst);
        iBP += this.borderProps.getBorderWidth(2, bNotFirst);
        iBP += this.borderProps.getPadding(3, bNotLast);
        return new MinOptMax(iBP += this.borderProps.getBorderWidth(3, bNotLast));
    }

    protected boolean hasLeadingFence(boolean bNotFirst) {
        int iBP = this.borderProps.getPadding(2, bNotFirst);
        return (iBP += this.borderProps.getBorderWidth(2, bNotFirst)) > 0;
    }

    protected boolean hasTrailingFence(boolean bNotLast) {
        int iBP = this.borderProps.getPadding(3, bNotLast);
        return (iBP += this.borderProps.getBorderWidth(3, bNotLast)) > 0;
    }

    public void resetPosition(Position prevPos) {
        if (prevPos != null) {
            if (prevPos.getLM() != this) {
                // empty if block
            }
            Position childPos = prevPos.getPosition();
            this.reset(childPos);
            if (this.prevBP != null && this.prevBP.getLayoutManager() != childPos.getLM()) {
                this.childLC = null;
            }
            this.prevBP = new BreakPoss(childPos);
        } else {
            this.prevBP = null;
            this.reset(prevPos);
            this.bAreaCreated = false;
        }
    }

    public boolean canBreakBefore(LayoutContext context) {
        if (this.inlineProps.spaceStart.getSpace().min > 0 || this.hasLeadingFence(false)) {
            return true;
        }
        LayoutProcessor lm = this.getChildLM();
        if (lm != null) {
            return lm.canBreakBefore(context);
        }
        return false;
    }

    protected MinOptMax getPrevIPD(LayoutManager lm) {
        return (MinOptMax)this.hmPrevIPD.get(lm);
    }

    protected void clearPrevIPD() {
        this.hmPrevIPD.clear();
    }

    /*
     * WARNING - void declaration
     */
    public BreakPoss getNextBreakPoss(LayoutContext lc) {
        LayoutProcessor curLM;
        BreakPoss bp = null;
        SpaceSpecifier leadingSpace = lc.getLeadingSpace();
        if (lc.startsNewArea()) {
            this.childLC = new LayoutContext(lc);
            lc.getLeadingSpace().addSpace(this.inlineProps.spaceStart);
            if (this.hasLeadingFence(!lc.isFirstArea())) {
                leadingSpace = new SpaceSpecifier(false);
            }
            this.clearPrevIPD();
        }
        while ((curLM = this.getChildLM()) != null) {
            void var3_4;
            if (!var3_4.generatesInlineAreas()) {
                this.getLogger().warn("ignoring block inside inline fo");
                var3_4.setFinished(true);
                continue;
            }
            boolean bFirstChildBP = this.prevBP == null || this.prevBP.getLayoutManager() != var3_4;
            this.initChildLC(this.childLC, this.prevBP, lc.startsNewArea(), bFirstChildBP, leadingSpace);
            if (lc.tryHyphenate()) {
                this.childLC.setHyphContext(lc.getHyphContext());
            }
            if ((bp = var3_4.getNextBreakPoss(this.childLC)) != null || lc.tryHyphenate() && !lc.getHyphContext().hasMoreHyphPoints()) break;
        }
        if (bp == null) {
            this.setFinished(true);
            return null;
        }
        boolean bIsLast = false;
        if (this.getChildLM() == null) {
            bIsLast = true;
            this.setFinished(true);
        } else if (bp.couldEndLine()) {
            bIsLast = !this.hasMoreLM(bp.getLayoutManager());
        }
        return this.makeBreakPoss(bp, lc, bIsLast);
    }

    protected void initChildLC(LayoutContext childLC, BreakPoss prevBP, boolean bStartParent, boolean bFirstChildBP, SpaceSpecifier leadingSpace) {
        childLC.setFlags(2, bFirstChildBP || bStartParent);
        if (bStartParent) {
            childLC.setFlags(32, bFirstChildBP);
            childLC.setLeadingSpace(leadingSpace);
        } else if (bFirstChildBP) {
            childLC.setFlags(32, true);
            childLC.setLeadingSpace(prevBP.getTrailingSpace());
        } else {
            childLC.setLeadingSpace(null);
        }
    }

    private BreakPoss makeBreakPoss(BreakPoss bp, LayoutContext lc, boolean bIsLast) {
        NonLeafPosition inlbp = new NonLeafPosition(this, bp.getPosition());
        BreakPoss myBP = new BreakPoss(inlbp, bp.getFlags());
        myBP.setFlag(4, lc.isFirstArea());
        myBP.setFlag(2, bIsLast);
        if (bIsLast) {
            this.lastChildLM = bp.getLayoutManager();
        }
        MinOptMax bpDim = (MinOptMax)bp.getStackingSize().clone();
        MinOptMax prevIPD = this.updatePrevIPD(bp, this.prevBP, lc.startsNewArea(), lc.isFirstArea());
        if (lc.startsNewArea()) {
            myBP.setLeadingSpace(lc.getLeadingSpace());
        }
        bpDim.add(prevIPD);
        SpaceSpecifier trailingSpace = bp.getTrailingSpace();
        if (this.hasTrailingFence(!bIsLast)) {
            bpDim.add(bp.resolveTrailingSpace(false));
            trailingSpace = new SpaceSpecifier(false);
        } else {
            trailingSpace = (SpaceSpecifier)trailingSpace.clone();
        }
        trailingSpace.addSpace(this.inlineProps.spaceEnd);
        myBP.setTrailingSpace(trailingSpace);
        bpDim.add(this.getExtraIPD(!lc.isFirstArea(), !bIsLast));
        myBP.setStackingSize(bpDim);
        myBP.setNonStackingSize(MinOptMax.add(bp.getNonStackingSize(), this.extraBPD));
        this.prevBP = bp;
        return myBP;
    }

    protected MinOptMax updatePrevIPD(BreakPoss bp, BreakPoss prevBP, boolean bStartParent, boolean bFirstArea) {
        MinOptMax prevIPD = new MinOptMax(0);
        if (bStartParent) {
            if (this.hasLeadingFence(!bFirstArea)) {
                prevIPD.add(bp.resolveLeadingSpace());
            }
            this.hmPrevIPD.put(bp.getLayoutManager(), prevIPD);
        } else {
            prevIPD = (MinOptMax)this.hmPrevIPD.get(bp.getLayoutManager());
            if (prevIPD == null) {
                prevIPD = (MinOptMax)this.hmPrevIPD.get(prevBP.getLayoutManager());
                prevIPD = MinOptMax.add(prevIPD, bp.resolveLeadingSpace());
                prevIPD.add(prevBP.getStackingSize());
                this.hmPrevIPD.put(bp.getLayoutManager(), prevIPD);
            }
        }
        return prevIPD;
    }

    public void getWordChars(StringBuffer sbChars, Position bp1, Position bp2) {
        Position endPos = ((NonLeafPosition)bp2).getPosition();
        Position prevPos = null;
        if (bp1 != null && (prevPos = ((NonLeafPosition)bp1).getPosition()).getLM() != endPos.getLM()) {
            prevPos = null;
        }
        endPos.getLM().getWordChars(sbChars, prevPos, endPos);
    }

    protected InlineParent createArea() {
        return new InlineParent();
    }

    /*
     * WARNING - void declaration
     */
    public void addAreas(PositionIterator parentIter, LayoutContext context) {
        boolean bIsLast;
        LayoutProcessor childLM;
        InlineParent parent = this.createArea();
        parent.setHeight(context.getLineHeight());
        parent.setOffset(0);
        this.setCurrentArea(parent);
        this.setChildContext(new LayoutContext(context));
        if (this.hasLeadingFence(this.bAreaCreated)) {
            this.getContext().setLeadingSpace(new SpaceSpecifier(false));
            this.getContext().setFlags(256, true);
        } else {
            this.getContext().setFlags(256, false);
        }
        context.getLeadingSpace().addSpace(this.inlineProps.spaceStart);
        StackingIter childPosIter = new StackingIter(parentIter);
        Object prevLM = null;
        while ((childLM = childPosIter.getNextChildLM()) != null) {
            void var6_6;
            var6_6.addAreas(childPosIter, this.getContext());
            this.getContext().setLeadingSpace(this.getContext().getTrailingSpace());
            this.getContext().setFlags(256, true);
            prevLM = var6_6;
        }
        boolean bl = bIsLast = this.getContext().isLastArea() && prevLM == this.lastChildLM;
        if (this.hasTrailingFence(bIsLast)) {
            this.addSpace(this.getCurrentArea(), this.getContext().getTrailingSpace().resolve(false), this.getContext().getSpaceAdjust());
            context.setTrailingSpace(new SpaceSpecifier(false));
        } else {
            context.setTrailingSpace(this.getContext().getTrailingSpace());
        }
        if (context.getTrailingSpace() != null) {
            context.getTrailingSpace().addSpace(this.inlineProps.spaceEnd);
        }
        TraitSetter.setBorderPaddingTraits(this.getCurrentArea(), this.borderProps, this.bAreaCreated, !bIsLast);
        if (this.borderProps != null) {
            TraitSetter.addBorders(this.getCurrentArea(), this.borderProps);
        }
        if (this.backgroundProps != null) {
            TraitSetter.addBackground(this.getCurrentArea(), this.backgroundProps);
        }
        this.parentLM.addChild(this.getCurrentArea());
        context.setFlags(128, bIsLast);
        this.bAreaCreated = true;
    }

    protected Area getCurrentArea() {
        return this.currentArea;
    }

    protected void setCurrentArea(Area area) {
        this.currentArea = area;
    }

    public void addChild(Area childArea) {
        if (childArea instanceof InlineArea) {
            Area parent = this.getCurrentArea();
            if (this.getContext().resolveLeadingSpace()) {
                this.addSpace(parent, this.getContext().getLeadingSpace().resolve(false), this.getContext().getSpaceAdjust());
            }
            parent.addChild(childArea);
        }
    }

    protected void setChildContext(LayoutContext lc) {
        this.childLC = lc;
    }

    protected LayoutContext getContext() {
        return this.childLC;
    }

    protected void addSpace(Area parentArea, MinOptMax spaceRange, double dSpaceAdjust) {
        if (spaceRange != null) {
            int iAdjust = spaceRange.opt;
            if (dSpaceAdjust > 0.0) {
                iAdjust += (int)((double)(spaceRange.max - spaceRange.opt) * dSpaceAdjust);
            } else if (dSpaceAdjust < 0.0) {
                iAdjust += (int)((double)(spaceRange.opt - spaceRange.min) * dSpaceAdjust);
            }
            if (iAdjust != 0) {
                Space ls = new Space();
                ls.setWidth(iAdjust);
                parentArea.addChild(ls);
            }
        }
    }

    private static class StackingIter
    extends PositionIterator {
        StackingIter(Iterator parentIter) {
            super(parentIter);
        }

        protected LayoutProcessor getLM(Object nextObj) {
            return ((Position)nextObj).getPosition().getLM();
        }

        protected Position getPos(Object nextObj) {
            return ((Position)nextObj).getPosition();
        }
    }
}

