/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.fop.layoutmgr.LayoutProcessor;
import org.apache.fop.layoutmgr.Position;

public abstract class PositionIterator
implements Iterator {
    private Iterator parentIter;
    private Object nextObj;
    private LayoutProcessor childLM;
    private boolean bHasNext;

    PositionIterator(Iterator pIter) {
        this.parentIter = pIter;
        this.lookAhead();
    }

    public LayoutProcessor getNextChildLM() {
        if (this.childLM == null && this.nextObj != null) {
            this.childLM = this.getLM(this.nextObj);
            this.bHasNext = true;
        }
        return this.childLM;
    }

    protected abstract LayoutProcessor getLM(Object var1);

    protected abstract Position getPos(Object var1);

    private void lookAhead() {
        if (this.parentIter.hasNext()) {
            this.bHasNext = true;
            this.nextObj = this.parentIter.next();
        } else {
            this.endIter();
        }
    }

    protected boolean checkNext() {
        LayoutProcessor lm = this.getLM(this.nextObj);
        if (this.childLM == null) {
            this.childLM = lm;
        } else if (this.childLM != lm) {
            this.bHasNext = false;
            this.childLM = null;
            return false;
        }
        return true;
    }

    protected void endIter() {
        this.bHasNext = false;
        this.nextObj = null;
        this.childLM = null;
    }

    public boolean hasNext() {
        return this.bHasNext && this.checkNext();
    }

    public Object next() throws NoSuchElementException {
        if (this.bHasNext) {
            Position retObj = this.getPos(this.nextObj);
            this.lookAhead();
            return retObj;
        }
        throw new NoSuchElementException("PosIter");
    }

    protected Object peekNext() {
        return this.nextObj;
    }

    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("PositionIterator doesn't support remove");
    }
}

