/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import java.util.ArrayList;
import org.apache.fop.area.Area;
import org.apache.fop.fo.flow.Marker;
import org.apache.fop.layoutmgr.AbstractLayoutManager;
import org.apache.fop.layoutmgr.BreakPoss;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.LayoutProcessor;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.PositionIterator;

public class RetrieveMarkerLayoutManager
extends AbstractLayoutManager {
    private LayoutProcessor replaceLM = null;
    private boolean loaded = false;
    private String name;
    private int position;
    private int boundary;

    public RetrieveMarkerLayoutManager(String n, int pos, int bound) {
        this.name = n;
        this.position = pos;
        this.boundary = bound;
    }

    public boolean generatesInlineAreas() {
        this.loadLM();
        if (this.replaceLM == null) {
            return true;
        }
        return this.replaceLM.generatesInlineAreas();
    }

    public BreakPoss getNextBreakPoss(LayoutContext context) {
        this.loadLM();
        if (this.replaceLM == null) {
            return null;
        }
        return this.replaceLM.getNextBreakPoss(context);
    }

    public void addAreas(PositionIterator parentIter, LayoutContext layoutContext) {
        this.loadLM();
        this.addID();
        this.replaceLM.addAreas(parentIter, layoutContext);
    }

    public boolean isFinished() {
        this.loadLM();
        if (this.replaceLM == null) {
            return true;
        }
        return this.replaceLM.isFinished();
    }

    public void setFinished(boolean fin) {
        if (this.replaceLM != null) {
            this.replaceLM.setFinished(fin);
        }
    }

    protected void loadLM() {
        if (this.loaded) {
            return;
        }
        this.loaded = true;
        if (this.replaceLM == null) {
            ArrayList list = new ArrayList();
            Marker marker = this.retrieveMarker(this.name, this.position, this.boundary);
            if (marker != null) {
                marker.addLayoutManager(list);
                if (list.size() > 0) {
                    this.replaceLM = (LayoutProcessor)list.get(0);
                    this.replaceLM.setParent(this);
                    this.replaceLM.init();
                    this.getLogger().debug("retrieved: " + this.replaceLM + ":" + list.size());
                } else {
                    this.getLogger().debug("found no marker with name: " + this.name);
                }
            }
        }
    }

    public Area getParentArea(Area childArea) {
        return this.parentLM.getParentArea(childArea);
    }

    public void addChild(Area childArea) {
        this.parentLM.addChild(childArea);
    }

    public void resetPosition(Position resetPos) {
        this.loadLM();
        if (resetPos == null) {
            this.reset(null);
        }
        if (this.replaceLM != null) {
            this.replaceLM.resetPosition(null);
        }
        this.loaded = false;
        this.replaceLM = null;
    }
}

