/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import java.util.ArrayList;
import java.util.List;
import org.apache.fop.layoutmgr.MinOptMax;
import org.apache.fop.traits.SpaceVal;

public class SpaceSpecifier
implements Cloneable {
    private boolean bStartsRefArea;
    private boolean bHasForcing = false;
    private List vecSpaceVals = new ArrayList();

    public SpaceSpecifier(boolean bStarts) {
        this.bStartsRefArea = bStarts;
    }

    public Object clone() {
        try {
            SpaceSpecifier ss = (SpaceSpecifier)super.clone();
            ss.vecSpaceVals = new ArrayList();
            ss.vecSpaceVals.addAll(this.vecSpaceVals);
            return ss;
        }
        catch (CloneNotSupportedException cnse) {
            return null;
        }
    }

    public void clear() {
        this.bHasForcing = false;
        this.vecSpaceVals.clear();
    }

    public boolean hasSpaces() {
        return this.vecSpaceVals.size() > 0;
    }

    public void addSpace(SpaceVal moreSpace) {
        if (!(this.bStartsRefArea && moreSpace.isConditional() && this.vecSpaceVals.isEmpty())) {
            if (moreSpace.isForcing()) {
                if (!this.bHasForcing) {
                    this.vecSpaceVals.clear();
                    this.bHasForcing = true;
                }
                this.vecSpaceVals.add(moreSpace);
            } else if (!(this.bHasForcing || moreSpace.getSpace().min == 0 && moreSpace.getSpace().opt == 0 && moreSpace.getSpace().max == 0)) {
                this.vecSpaceVals.add(moreSpace);
            }
        }
    }

    public MinOptMax resolve(boolean bEndsReferenceArea) {
        int lastIndex = this.vecSpaceVals.size();
        if (bEndsReferenceArea) {
            while (lastIndex > 0) {
                SpaceVal sval = (SpaceVal)this.vecSpaceVals.get(lastIndex - 1);
                if (!sval.isConditional()) break;
                --lastIndex;
            }
        }
        MinOptMax resSpace = new MinOptMax(0);
        int iMaxPrec = -1;
        int index = 0;
        while (index < lastIndex) {
            SpaceVal sval = (SpaceVal)this.vecSpaceVals.get(index);
            if (this.bHasForcing) {
                resSpace.add(sval.getSpace());
            } else if (sval.getPrecedence() > iMaxPrec) {
                iMaxPrec = sval.getPrecedence();
                resSpace = sval.getSpace();
            } else if (sval.getPrecedence() == iMaxPrec) {
                if (sval.getSpace().opt > resSpace.opt) {
                    resSpace = sval.getSpace();
                } else if (sval.getSpace().opt == resSpace.opt) {
                    if (resSpace.min < sval.getSpace().min) {
                        resSpace.min = sval.getSpace().min;
                    }
                    if (resSpace.max > sval.getSpace().max) {
                        resSpace.max = sval.getSpace().max;
                    }
                }
            }
            ++index;
        }
        return resSpace;
    }
}

