/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import org.apache.fop.area.Area;
import org.apache.fop.area.Trait;
import org.apache.fop.layout.BackgroundProps;
import org.apache.fop.layout.BorderAndPadding;
import org.apache.fop.traits.BorderProps;

public class TraitSetter {
    public static void setBorderPaddingTraits(Area area, BorderAndPadding bpProps, boolean bNotFirst, boolean bNotLast) {
        int iBP = bpProps.getPadding(2, bNotFirst);
        if (iBP > 0) {
            area.addTrait(Trait.PADDING_START, new Integer(iBP));
        }
        if ((iBP = bpProps.getPadding(3, bNotLast)) > 0) {
            area.addTrait(Trait.PADDING_END, new Integer(iBP));
        }
        if ((iBP = bpProps.getPadding(0, false)) > 0) {
            area.addTrait(Trait.PADDING_BEFORE, new Integer(iBP));
        }
        if ((iBP = bpProps.getPadding(1, false)) > 0) {
            area.addTrait(Trait.PADDING_AFTER, new Integer(iBP));
        }
        TraitSetter.addBorderTrait(area, bpProps, bNotFirst, 2, Trait.BORDER_START);
        TraitSetter.addBorderTrait(area, bpProps, bNotLast, 3, Trait.BORDER_END);
        TraitSetter.addBorderTrait(area, bpProps, false, 0, Trait.BORDER_BEFORE);
        TraitSetter.addBorderTrait(area, bpProps, false, 1, Trait.BORDER_AFTER);
    }

    private static void addBorderTrait(Area area, BorderAndPadding bpProps, boolean bDiscard, int iSide, Object oTrait) {
        int iBP = bpProps.getBorderWidth(iSide, bDiscard);
        if (iBP > 0) {
            area.addTrait(oTrait, new BorderProps(bpProps.getBorderStyle(iSide), iBP, bpProps.getBorderColor(iSide)));
        }
    }

    public static void addBorders(Area curBlock, BorderAndPadding bordProps) {
        BorderProps bps = TraitSetter.getBorderProps(bordProps, 0);
        if (bps.width != 0) {
            curBlock.addTrait(Trait.BORDER_BEFORE, bps);
        }
        bps = TraitSetter.getBorderProps(bordProps, 1);
        if (bps.width != 0) {
            curBlock.addTrait(Trait.BORDER_AFTER, bps);
        }
        bps = TraitSetter.getBorderProps(bordProps, 2);
        if (bps.width != 0) {
            curBlock.addTrait(Trait.BORDER_START, bps);
        }
        bps = TraitSetter.getBorderProps(bordProps, 3);
        if (bps.width != 0) {
            curBlock.addTrait(Trait.BORDER_END, bps);
        }
    }

    private static BorderProps getBorderProps(BorderAndPadding bordProps, int side) {
        BorderProps bps = new BorderProps(bordProps.getBorderStyle(side), bordProps.getBorderWidth(side, false), bordProps.getBorderColor(side));
        return bps;
    }

    public static void addBackground(Area curBlock, BackgroundProps backProps) {
        Trait.Background back = new Trait.Background();
        back.setColor(backProps.backColor);
        if (backProps.backImage != null) {
            back.setURL(backProps.backImage);
            back.setRepeat(backProps.backRepeat);
            if (backProps.backPosHorizontal != null) {
                back.setHoriz(backProps.backPosHorizontal.getValue());
            }
            if (backProps.backPosVertical != null) {
                back.setVertical(backProps.backPosVertical.getValue());
            }
        }
        if (back.getColor() != null || back.getURL() != null) {
            curBlock.addTrait(Trait.BACKGROUND, back);
        }
    }
}

