/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.fop.pdf.PDFFilter;

public class ASCII85Filter
extends PDFFilter {
    private static final char ASCII85_ZERO = 'z';
    private static final char ASCII85_START = '!';
    private static final String ASCII85_EOD = "~>";
    private static final long BASE85_4 = 85L;

    public String getName() {
        return "/ASCII85Decode";
    }

    public String getDecodeParms() {
        return null;
    }

    public void encode(InputStream in, OutputStream out, int length) throws IOException {
        boolean total = false;
        boolean diff = false;
        int i = 0;
        while (i + 3 < length) {
            long val = ((long)(in.read() << 24) & 0xFF000000L) + ((long)(in.read() << 16) & 0xFF0000L) + ((long)(in.read() << 8) & 0xFF00L) + ((long)in.read() & 0xFFL);
            byte[] conv = this.convertWord(val);
            out.write(conv, 0, conv.length);
            i += 4;
        }
        if (i < length) {
            int n = length - i;
            byte[] lastdata = new byte[4];
            int j = 0;
            while (j < 4) {
                lastdata[j] = j < n ? (byte)in.read() : (byte)0;
                ++j;
            }
            long val = ((long)(lastdata[0] << 24) & 0xFF000000L) + ((long)(lastdata[1] << 16) & 0xFF0000L) + ((long)(lastdata[2] << 8) & 0xFF00L) + ((long)lastdata[3] & 0xFFL);
            byte[] conv = this.convertWord(val);
            if (val == 0L) {
                conv = new byte[5];
                int j2 = 0;
                while (j2 < 5) {
                    conv[j2] = 33;
                    ++j2;
                }
            }
            out.write(conv, 0, n + 1);
        }
        out.write(ASCII85_EOD.getBytes(), 0, ASCII85_EOD.getBytes().length);
        out.close();
    }

    private byte[] convertWord(long word) {
        if ((word &= 0xFFFFFFFFFFFFFFFFL) < 0L) {
            word = -word;
        }
        if (word == 0L) {
            byte[] result = new byte[]{122};
            return result;
        }
        byte c5 = (byte)(word % 85L + 33L);
        byte c4 = (byte)((word /= 85L) % 85L + 33L);
        byte c3 = (byte)((word /= 85L) % 85L + 33L);
        byte c2 = (byte)((word /= 85L) % 85L + 33L);
        byte c1 = (byte)((word /= 85L) % 85L + 33L);
        byte[] ret = new byte[]{c1, c2, c3, c4, c5};
        int i = 0;
        while (i < ret.length) {
            if (ret[i] < 33 || ret[i] > 117) {
                System.out.println("illegal char value " + new Integer(ret[i]));
            }
            ++i;
        }
        return ret;
    }
}

