/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.fop.pdf.PDFFilter;
import org.apache.fop.pdf.StreamCache;

public class InMemoryStreamCache
extends StreamCache {
    private ByteArrayOutputStream output;

    public OutputStream getOutputStream() throws IOException {
        if (this.output == null) {
            this.output = new ByteArrayOutputStream();
        }
        return this.output;
    }

    public void applyFilter(PDFFilter filter) throws IOException {
        if (this.output == null) {
            return;
        }
        this.output.close();
        int size = this.getSize();
        ByteArrayInputStream input = new ByteArrayInputStream(this.output.toByteArray());
        this.output.reset();
        filter.encode(input, this.output, size);
        input.close();
        this.output.close();
    }

    public void outputStreamData(OutputStream stream) throws IOException {
        if (this.output == null) {
            return;
        }
        this.output.writeTo(stream);
    }

    public int getSize() throws IOException {
        if (this.output == null) {
            return 0;
        }
        return this.output.size();
    }

    public void close() throws IOException {
        if (this.output != null) {
            this.output.close();
            this.output = null;
        }
    }

    public void reset() throws IOException {
        if (this.output != null) {
            this.output.close();
            this.output = null;
        }
    }
}

