/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import org.apache.fop.pdf.PDFAction;

public class PDFGoTo
extends PDFAction {
    private String pageReference;
    private String destination = null;
    private float xPosition = 0.0f;
    private float yPosition = 0.0f;

    public PDFGoTo(int number, String pageReference) {
        super(number);
        this.pageReference = pageReference;
    }

    public void setPageReference(String pageReference) {
        this.pageReference = pageReference;
    }

    public void setYPosition(float yPosition) {
        this.yPosition = yPosition;
    }

    public void setDestination(String dest) {
        this.destination = dest;
    }

    public void setXPosition(int xPosition) {
        this.xPosition = (float)xPosition / 1000.0f;
    }

    public String getAction() {
        return this.referencePDF();
    }

    public byte[] toPDF() {
        String dest = this.destination == null ? "/D [" + this.pageReference + " /XYZ " + this.xPosition + " " + this.yPosition + " null]\n" : "/D [" + this.pageReference + " " + this.destination + "]\n";
        String p = new String(this.number + " " + this.generation + " obj\n<<\n/S /GoTo\n" + dest + ">>\nendobj\n");
        return p.getBytes();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof PDFGoTo)) {
            return false;
        }
        PDFGoTo gt = (PDFGoTo)obj;
        if (gt.pageReference == null ? this.pageReference != null : !gt.pageReference.equals(this.pageReference)) {
            return false;
        }
        return !(this.destination == null ? gt.destination != null || gt.xPosition != this.xPosition || gt.yPosition != this.yPosition : !this.destination.equals(gt.destination));
    }
}

