/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.fop.pdf.PDFColor;
import org.apache.fop.pdf.PDFColorSpace;
import org.apache.fop.pdf.PDFICCStream;
import org.apache.fop.pdf.PDFImage;
import org.apache.fop.pdf.PDFObject;
import org.apache.fop.pdf.PDFStream;

public class PDFXObject
extends PDFObject {
    private PDFImage pdfimage;
    private int xnum;

    public PDFXObject(int number, int xnumber, PDFImage img) {
        super(number);
        this.xnum = xnumber;
        this.pdfimage = img;
    }

    public int getXNumber() {
        return this.xnum;
    }

    protected int output(OutputStream stream) throws IOException {
        int length = 0;
        boolean i = false;
        if (this.pdfimage.isPS()) {
            length = this.outputEPSImage(stream);
        } else {
            String ref;
            PDFStream imgStream = this.pdfimage.getDataStream();
            String dictEntries = imgStream.applyFilters();
            String p = this.number + " " + this.generation + " obj\n";
            p = p + "<</Type /XObject\n";
            p = p + "/Subtype /Image\n";
            p = p + "/Name /Im" + this.xnum + "\n";
            p = p + "/Length " + (imgStream.getDataLength() + 1) + "\n";
            p = p + "/Width " + this.pdfimage.getWidth() + "\n";
            p = p + "/Height " + this.pdfimage.getHeight() + "\n";
            p = p + "/BitsPerComponent " + this.pdfimage.getBitsPerPixel() + "\n";
            PDFICCStream pdfICCStream = this.pdfimage.getICCStream();
            if (pdfICCStream != null) {
                p = p + "/ColorSpace [/ICCBased " + pdfICCStream.referencePDF() + "]\n";
            } else {
                PDFColorSpace cs = this.pdfimage.getColorSpace();
                p = p + "/ColorSpace /" + cs.getColorSpacePDFString() + "\n";
            }
            if (this.pdfimage.getColorSpace().getColorSpace() == 3) {
                p = p + "/Decode [ 1.0 0.0 1.0 0.0 1.0 0.0 1.1 0.0 ]\n";
            }
            if (this.pdfimage.isTransparent()) {
                PDFColor transp = this.pdfimage.getTransparentColor();
                p = p + "/Mask [" + transp.red255() + " " + transp.red255() + " " + transp.green255() + " " + transp.green255() + " " + transp.blue255() + " " + transp.blue255() + "]\n";
            }
            if ((ref = this.pdfimage.getSoftMask()) != null) {
                p = p + "/SMask " + ref + "\n";
            }
            p = p + dictEntries;
            p = p + ">>\n";
            byte[] pdfBytes = p.getBytes();
            stream.write(pdfBytes);
            length += pdfBytes.length;
            length += imgStream.outputStreamData(stream);
            pdfBytes = "endobj\n".getBytes();
            stream.write(pdfBytes);
            length += pdfBytes.length;
        }
        this.pdfimage = null;
        return length;
    }

    byte[] toPDF() {
        return null;
    }

    private int outputEPSImage(OutputStream stream) throws IOException {
        int length = 0;
        boolean i = false;
        PDFStream imgStream = this.pdfimage.getDataStream();
        String dictEntries = imgStream.applyFilters();
        String p = this.number + " " + this.generation + " obj\n";
        p = p + "<</Type /XObject\n";
        p = p + "/Subtype /PS\n";
        p = p + "/Length " + (imgStream.getDataLength() + 1);
        p = p + dictEntries;
        p = p + ">>\n";
        byte[] pdfBytes = p.getBytes();
        stream.write(pdfBytes);
        length += pdfBytes.length;
        length += imgStream.outputStreamData(stream);
        pdfBytes = "endobj\n".getBytes();
        stream.write(pdfBytes);
        return length += pdfBytes.length;
    }
}

