/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf;

import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.Version;
import org.apache.fop.area.Area;
import org.apache.fop.area.Block;
import org.apache.fop.area.BlockViewport;
import org.apache.fop.area.CTM;
import org.apache.fop.area.LineArea;
import org.apache.fop.area.Page;
import org.apache.fop.area.PageViewport;
import org.apache.fop.area.RegionViewport;
import org.apache.fop.area.Title;
import org.apache.fop.area.Trait;
import org.apache.fop.area.TreeExt;
import org.apache.fop.area.inline.Character;
import org.apache.fop.area.inline.ForeignObject;
import org.apache.fop.area.inline.Image;
import org.apache.fop.area.inline.InlineParent;
import org.apache.fop.area.inline.Leader;
import org.apache.fop.area.inline.Viewport;
import org.apache.fop.area.inline.Word;
import org.apache.fop.datatypes.ColorType;
import org.apache.fop.extensions.BookmarkData;
import org.apache.fop.fo.FOUserAgent;
import org.apache.fop.fonts.Font;
import org.apache.fop.fonts.FontMetrics;
import org.apache.fop.image.FopImage;
import org.apache.fop.image.ImageFactory;
import org.apache.fop.image.XMLImage;
import org.apache.fop.layout.FontState;
import org.apache.fop.pdf.PDFAnnotList;
import org.apache.fop.pdf.PDFColor;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFInfo;
import org.apache.fop.pdf.PDFLink;
import org.apache.fop.pdf.PDFOutline;
import org.apache.fop.pdf.PDFPage;
import org.apache.fop.pdf.PDFResourceContext;
import org.apache.fop.pdf.PDFResources;
import org.apache.fop.pdf.PDFState;
import org.apache.fop.pdf.PDFStream;
import org.apache.fop.pdf.PDFXObject;
import org.apache.fop.render.PrintRenderer;
import org.apache.fop.render.RendererContext;
import org.apache.fop.render.pdf.CTMHelper;
import org.apache.fop.render.pdf.EmbedFontInfo;
import org.apache.fop.render.pdf.FontSetup;
import org.apache.fop.render.pdf.FontTriplet;
import org.apache.fop.render.pdf.FopPDFImage;
import org.apache.fop.render.pdf.PDFXMLHandler;
import org.apache.fop.traits.BorderProps;
import org.w3c.dom.Document;

public class PDFRenderer
extends PrintRenderer {
    public static final String MIME_TYPE = "application/pdf";
    protected PDFDocument pdfDoc;
    protected Map pages = null;
    protected Map pageReferences = new HashMap();
    protected Map pvReferences = new HashMap();
    private String producer = "FOP";
    private String creator = null;
    protected OutputStream ostream;
    protected PDFResources pdfResources;
    protected PDFStream currentStream;
    protected PDFResourceContext currentContext = null;
    protected PDFPage currentPage;
    protected PDFState currentState = null;
    protected String currentFontName = "";
    protected int currentFontSize = 0;
    protected int pageHeight;
    protected Map filterMap = new HashMap();
    protected boolean textOpen = false;
    protected int prevWordY = 0;
    protected int prevWordX = 0;
    protected int prevWordWidth = 0;
    private StringBuffer wordAreaPDF = new StringBuffer();

    public void configure(Configuration conf) throws ConfigurationException {
        Configuration filters = conf.getChild("filterList");
        Configuration[] filt = filters.getChildren("value");
        ArrayList<String> filterList = new ArrayList<String>();
        int i = 0;
        while (i < filt.length) {
            String name = filt[i].getValue();
            filterList.add(name);
            ++i;
        }
        this.filterMap.put("default", filterList);
        Configuration[] font = conf.getChildren("font");
        int i2 = 0;
        while (i2 < font.length) {
            Configuration[] triple = font[i2].getChildren("font-triplet");
            ArrayList<FontTriplet> tripleList = new ArrayList<FontTriplet>();
            int j = 0;
            while (j < triple.length) {
                tripleList.add(new FontTriplet(triple[j].getAttribute("name"), triple[j].getAttribute("style"), triple[j].getAttribute("weight")));
                ++j;
            }
            EmbedFontInfo efi = new EmbedFontInfo(font[i2].getAttribute("metrics-url"), font[i2].getAttributeAsBoolean("kerning"), tripleList, font[i2].getAttribute("embed-url"));
            if (this.fontList == null) {
                this.fontList = new ArrayList();
            }
            this.fontList.add(efi);
            ++i2;
        }
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public void setProducer(String producer) {
        this.producer = producer;
    }

    public void setUserAgent(FOUserAgent agent) {
        super.setUserAgent(agent);
        PDFXMLHandler xmlHandler = new PDFXMLHandler();
        String svg = "http://www.w3.org/2000/svg";
        this.userAgent.addXMLHandler(MIME_TYPE, svg, xmlHandler);
    }

    public void startRenderer(OutputStream stream) throws IOException {
        this.ostream = stream;
        this.producer = "FOP " + Version.getVersion();
        this.pdfDoc = new PDFDocument(this.producer);
        this.pdfDoc.setCreator(this.creator);
        this.pdfDoc.setFilterMap(this.filterMap);
        this.pdfDoc.outputHeader(stream);
    }

    public void stopRenderer() throws IOException {
        FontSetup.addToResources(this.pdfDoc, this.pdfDoc.getResources(), this.fontInfo);
        this.pdfDoc.outputTrailer(this.ostream);
        this.pdfDoc = null;
        this.ostream = null;
        this.pages = null;
        this.pageReferences.clear();
        this.pvReferences.clear();
        this.pdfResources = null;
        this.currentStream = null;
        this.currentContext = null;
        this.currentPage = null;
        this.currentState = null;
        this.currentFontName = "";
        this.wordAreaPDF = new StringBuffer();
    }

    public boolean supportsOutOfOrder() {
        return true;
    }

    public void renderExtension(TreeExt ext) {
        if (ext instanceof BookmarkData) {
            this.renderRootExtensions((BookmarkData)ext);
        }
    }

    protected void renderRootExtensions(BookmarkData bookmarks) {
        int i = 0;
        while (i < bookmarks.getCount()) {
            BookmarkData ext = bookmarks.getSubData(i);
            this.renderOutline(ext, null);
            ++i;
        }
    }

    private void renderOutline(BookmarkData outline, PDFOutline parentOutline) {
        PDFOutline outlineRoot = this.pdfDoc.getOutlineRoot();
        PDFOutline pdfOutline = null;
        PageViewport pv = outline.getPage();
        if (pv != null) {
            Rectangle2D bounds = pv.getViewArea();
            double h = bounds.getHeight();
            float yoffset = (float)h / 1000.0f;
            String intDest = (String)this.pageReferences.get(pv.getKey());
            if (parentOutline == null) {
                pdfOutline = this.pdfDoc.makeOutline(outlineRoot, outline.getLabel(), intDest, yoffset);
            } else {
                PDFOutline pdfParentOutline = parentOutline;
                pdfOutline = this.pdfDoc.makeOutline(pdfParentOutline, outline.getLabel(), intDest, yoffset);
            }
        }
        int i = 0;
        while (i < outline.getCount()) {
            this.renderOutline(outline.getSubData(i), pdfOutline);
            ++i;
        }
    }

    protected void saveGraphicsState() {
        this.currentStream.add("q\n");
    }

    protected void restoreGraphicsState() {
        this.currentStream.add("Q\n");
    }

    protected void beginTextObject() {
        this.currentStream.add("BT\n");
    }

    protected void endTextObject() {
        this.currentStream.add("ET\n");
    }

    public void startPageSequence(Title seqTitle) {
        if (seqTitle != null) {
            String str = this.convertTitleToString(seqTitle);
            PDFInfo info = this.pdfDoc.getInfo();
            info.setTitle(str);
        }
    }

    public void preparePage(PageViewport page) {
        this.pdfResources = this.pdfDoc.getResources();
        Rectangle2D bounds = page.getViewArea();
        double w = bounds.getWidth();
        double h = bounds.getHeight();
        this.currentPage = this.pdfDoc.makePage(this.pdfResources, (int)Math.round(w / 1000.0), (int)Math.round(h / 1000.0));
        if (this.pages == null) {
            this.pages = new HashMap();
        }
        this.pages.put(page, this.currentPage);
        this.pageReferences.put(page.getKey(), this.currentPage.referencePDF());
        this.pvReferences.put(page.getKey(), page);
    }

    public void renderPage(PageViewport page) throws IOException, FOPException {
        Rectangle2D bounds;
        if (this.pages != null && (this.currentPage = (PDFPage)this.pages.get(page)) != null) {
            this.pages.remove(page);
            bounds = page.getViewArea();
            double h = bounds.getHeight();
            this.pageHeight = (int)h;
        } else {
            this.pdfResources = this.pdfDoc.getResources();
            bounds = page.getViewArea();
            double w = bounds.getWidth();
            double h = bounds.getHeight();
            this.pageHeight = (int)h;
            this.currentPage = this.pdfDoc.makePage(this.pdfResources, (int)Math.round(w / 1000.0), (int)Math.round(h / 1000.0));
            this.pageReferences.put(page.getKey(), this.currentPage.referencePDF());
            this.pvReferences.put(page.getKey(), page);
        }
        this.currentStream = this.pdfDoc.makeStream("content", false);
        this.currentState = new PDFState();
        this.currentState.setTransform(new AffineTransform(1.0f, 0.0f, 0.0f, -1.0f, 0.0f, Math.round(this.pageHeight / 1000)));
        this.currentStream.add("1 0 0 -1 0 " + Math.round(this.pageHeight / 1000) + " cm\n");
        this.currentFontName = "";
        Page p = page.getPage();
        this.renderPageAreas(p);
        this.pdfDoc.addStream(this.currentStream);
        this.currentPage.setContents(this.currentStream);
        PDFAnnotList annots = this.currentPage.getAnnotations();
        if (annots != null) {
            this.pdfDoc.addAnnotList(annots);
        }
        this.pdfDoc.addPage(this.currentPage);
        this.pdfDoc.output(this.ostream);
    }

    protected void startVParea(CTM ctm) {
        this.currentState.push();
        this.currentState.setTransform(new AffineTransform(CTMHelper.toPDFArray(ctm)));
        this.saveGraphicsState();
        this.currentStream.add(CTMHelper.toPDFString(ctm) + " cm\n");
        this.beginTextObject();
    }

    protected void endVParea() {
        this.endTextObject();
        this.restoreGraphicsState();
        this.currentState.pop();
    }

    protected void handleViewportTraits(RegionViewport region) {
        this.currentFontName = "";
        float startx = 0.0f;
        float starty = 0.0f;
        Rectangle2D viewArea = region.getViewArea();
        float width = (float)(viewArea.getWidth() / 1000.0);
        float height = (float)(viewArea.getHeight() / 1000.0);
        this.drawBackAndBorders(region, startx, starty, width, height);
    }

    protected void handleBlockTraits(Block block) {
        float startx = (float)this.currentIPPosition / 1000.0f;
        float starty = (float)this.currentBPPosition / 1000.0f;
        this.drawBackAndBorders(block, startx, starty, (float)block.getWidth() / 1000.0f, (float)block.getHeight() / 1000.0f);
    }

    protected void drawBackAndBorders(Area block, float startx, float starty, float width, float height) {
        float bwidth;
        BorderProps bps;
        boolean started = false;
        Trait.Background back = (Trait.Background)block.getTrait(Trait.BACKGROUND);
        if (back != null) {
            ImageFactory fact;
            FopImage fopimage;
            started = true;
            this.closeText();
            this.endTextObject();
            if (back.getColor() != null) {
                this.updateColor(back.getColor(), true, null);
                this.currentStream.add(startx + " " + starty + " " + width + " " + height + " re\n");
                this.currentStream.add("f\n");
            }
            if (back.getURL() != null && (fopimage = (fact = ImageFactory.getInstance()).getImage(back.getURL(), this.userAgent)) != null && fopimage.load(1, this.userAgent) && back.getRepeat() != 72) {
                Rectangle2D.Float pos = new Rectangle2D.Float((startx + (float)back.getHoriz()) * 1000.0f, (starty + (float)back.getVertical()) * 1000.0f, fopimage.getWidth() * 1000, fopimage.getHeight() * 1000);
                this.putImage(back.getURL(), pos);
            }
        }
        if ((bps = (BorderProps)block.getTrait(Trait.BORDER_BEFORE)) != null) {
            float endx = startx + width;
            if (!started) {
                started = true;
                this.closeText();
                this.endTextObject();
            }
            float bwidth2 = (float)bps.width / 1000.0f;
            this.updateColor(bps.color, false, null);
            this.currentStream.add(bwidth2 + " w\n");
            this.drawLine(startx, starty + bwidth2 / 2.0f, endx, starty + bwidth2 / 2.0f);
        }
        if ((bps = (BorderProps)block.getTrait(Trait.BORDER_START)) != null) {
            float endy = starty + height;
            if (!started) {
                started = true;
                this.closeText();
                this.endTextObject();
            }
            float bwidth3 = (float)bps.width / 1000.0f;
            this.updateColor(bps.color, false, null);
            this.currentStream.add(bwidth3 + " w\n");
            this.drawLine(startx + bwidth3 / 2.0f, starty, startx + bwidth3 / 2.0f, endy);
        }
        if ((bps = (BorderProps)block.getTrait(Trait.BORDER_AFTER)) != null) {
            float sy = starty + height;
            float endx = startx + width;
            if (!started) {
                started = true;
                this.closeText();
                this.endTextObject();
            }
            bwidth = (float)bps.width / 1000.0f;
            this.updateColor(bps.color, false, null);
            this.currentStream.add(bwidth + " w\n");
            this.drawLine(startx, sy - bwidth / 2.0f, endx, sy - bwidth / 2.0f);
        }
        if ((bps = (BorderProps)block.getTrait(Trait.BORDER_END)) != null) {
            float sx = startx + width;
            float endy = starty + height;
            if (!started) {
                started = true;
                this.closeText();
                this.endTextObject();
            }
            bwidth = (float)bps.width / 1000.0f;
            this.updateColor(bps.color, false, null);
            this.currentStream.add(bwidth + " w\n");
            this.drawLine(sx - bwidth / 2.0f, starty, sx - bwidth / 2.0f, endy);
        }
        if (started) {
            this.beginTextObject();
            this.currentFontName = "";
        }
    }

    private void drawLine(float startx, float starty, float endx, float endy) {
        this.currentStream.add(startx + " " + starty + " m\n");
        this.currentStream.add(endx + " " + endy + " l\n");
        this.currentStream.add("S\n");
    }

    protected void renderBlockViewport(BlockViewport bv, List children) {
        int saveIP = this.currentIPPosition;
        int saveBP = this.currentBPPosition;
        String saveFontName = this.currentFontName;
        CTM ctm = bv.getCTM();
        if (bv.getPositioning() == 2) {
            this.currentIPPosition = 0;
            this.currentBPPosition = 0;
            this.closeText();
            this.endTextObject();
            if (bv.getClip()) {
                this.saveGraphicsState();
                float x = (float)(bv.getXOffset() + this.containingIPPosition) / 1000.0f;
                float y = (float)(bv.getYOffset() + this.containingBPPosition) / 1000.0f;
                float width = (float)bv.getWidth() / 1000.0f;
                float height = (float)bv.getHeight() / 1000.0f;
                this.clip(x, y, width, height);
            }
            CTM tempctm = new CTM(this.containingIPPosition, this.containingBPPosition);
            ctm = tempctm.multiply(ctm);
            this.startVParea(ctm);
            this.handleBlockTraits(bv);
            this.renderBlocks(children);
            this.endVParea();
            if (bv.getClip()) {
                this.restoreGraphicsState();
            }
            this.beginTextObject();
            this.currentIPPosition = saveIP;
            this.currentBPPosition = saveBP;
        } else {
            if (ctm != null) {
                this.currentIPPosition = 0;
                this.currentBPPosition = 0;
                this.closeText();
                this.endTextObject();
                double[] vals = ctm.toArray();
                ctm = vals[2] == 1.0 ? ctm.translate(-saveBP - bv.getHeight(), -saveIP) : (vals[0] == -1.0 ? ctm.translate(-saveIP - bv.getWidth(), -saveBP - bv.getHeight()) : ctm.translate(saveBP, saveIP - bv.getWidth()));
            }
            if (bv.getClip()) {
                if (ctm == null) {
                    this.closeText();
                    this.endTextObject();
                }
                this.saveGraphicsState();
                float x = (float)bv.getXOffset() / 1000.0f;
                float y = (float)bv.getYOffset() / 1000.0f;
                float width = (float)bv.getWidth() / 1000.0f;
                float height = (float)bv.getHeight() / 1000.0f;
                this.clip(x, y, width, height);
            }
            if (ctm != null) {
                this.startVParea(ctm);
            }
            this.handleBlockTraits(bv);
            this.renderBlocks(children);
            if (ctm != null) {
                this.endVParea();
            }
            if (bv.getClip()) {
                this.restoreGraphicsState();
                if (ctm == null) {
                    this.beginTextObject();
                }
            }
            if (ctm != null) {
                this.beginTextObject();
            }
            this.currentIPPosition = saveIP;
            this.currentBPPosition = saveBP;
            this.currentBPPosition += bv.getHeight();
        }
        this.currentFontName = saveFontName;
    }

    protected void clip(float x, float y, float width, float height) {
        this.currentStream.add(x + " " + y + " m\n");
        this.currentStream.add(x + width + " " + y + " l\n");
        this.currentStream.add(x + width + " " + (y + height) + " l\n");
        this.currentStream.add(x + " " + (y + height) + " l\n");
        this.currentStream.add("h\n");
        this.currentStream.add("W\n");
        this.currentStream.add("n\n");
    }

    protected void renderLineArea(LineArea line) {
        super.renderLineArea(line);
        this.closeText();
    }

    public void renderInlineParent(InlineParent ip) {
        float start = (float)this.currentBlockIPPosition / 1000.0f;
        float top = (float)(ip.getOffset() + this.currentBPPosition) / 1000.0f;
        float width = (float)ip.getWidth() / 1000.0f;
        float height = (float)ip.getHeight() / 1000.0f;
        this.drawBackAndBorders(ip, start, top, width, height);
        super.renderInlineParent(ip);
        Object tr = ip.getTrait(Trait.INTERNAL_LINK);
        boolean internal = false;
        String dest = null;
        float yoffset = 0.0f;
        if (tr == null) {
            dest = (String)ip.getTrait(Trait.EXTERNAL_LINK);
        } else {
            String pvKey = (String)tr;
            dest = (String)this.pageReferences.get(pvKey);
            if (dest != null) {
                PageViewport pv = (PageViewport)this.pvReferences.get(pvKey);
                Rectangle2D bounds = pv.getViewArea();
                double h = bounds.getHeight();
                yoffset = (float)h / 1000.0f;
                internal = true;
            }
        }
        if (dest != null) {
            Rectangle2D rect = new Rectangle2D.Float(start, top, width, height);
            AffineTransform transform = this.currentState.getTransform();
            rect = transform.createTransformedShape(rect).getBounds();
            int type = internal ? 1 : 0;
            PDFLink pdflink = this.pdfDoc.makeLink(rect, dest, type, yoffset);
            this.currentPage.addAnnotation(pdflink);
        }
    }

    public void renderCharacter(Character ch) {
        super.renderCharacter(ch);
    }

    public void renderWord(Word word) {
        StringBuffer pdf = new StringBuffer();
        String name = (String)word.getTrait(Trait.FONT_NAME);
        int size = (Integer)word.getTrait(Trait.FONT_SIZE);
        Font f = (Font)this.fontInfo.getFonts().get(name);
        boolean useMultiByte = f.isMultiByte();
        String startText = useMultiByte ? "<" : "(";
        String endText = useMultiByte ? "> " : ") ";
        this.updateFont(name, size, pdf);
        ColorType ct = (ColorType)word.getTrait(Trait.COLOR);
        if (ct != null) {
            this.updateColor(ct, true, pdf);
        }
        int rx = this.currentBlockIPPosition;
        int bl = this.currentBPPosition + word.getOffset();
        if (!this.textOpen || bl != this.prevWordY) {
            this.closeText();
            pdf.append("1 0 0 -1 " + (float)rx / 1000.0f + " " + (float)bl / 1000.0f + " Tm [" + startText);
            this.prevWordY = bl;
            this.textOpen = true;
        } else {
            int space = this.prevWordX - rx + this.prevWordWidth;
            float emDiff = (float)space / (float)this.currentFontSize * 1000.0f;
            if (emDiff < -33000.0f) {
                this.closeText();
                pdf.append("1 0 0 1 " + (float)rx / 1000.0f + " " + (float)bl / 1000.0f + " Tm [" + startText);
                this.textOpen = true;
            } else {
                pdf.append(Float.toString(emDiff));
                pdf.append(" ");
                pdf.append(startText);
            }
        }
        this.prevWordWidth = word.getWidth();
        this.prevWordX = rx;
        String s = word.getWord();
        FontMetrics metrics = this.fontInfo.getMetricsFor(name);
        FontState fs = new FontState(name, metrics, size);
        this.escapeText(s, fs, useMultiByte, pdf);
        pdf.append(endText);
        this.currentStream.add(pdf.toString());
        super.renderWord(word);
    }

    public void escapeText(String s, FontState fs, boolean useMultiByte, StringBuffer pdf) {
        String startText = useMultiByte ? "<" : "(";
        String endText = useMultiByte ? "> " : ") ";
        boolean kerningAvailable = false;
        Map kerning = fs.getKerning();
        if (kerning != null && !kerning.isEmpty()) {
            kerningAvailable = true;
        }
        int l = s.length();
        int i = 0;
        while (i < l) {
            char ch = fs.mapChar(s.charAt(i));
            if (!useMultiByte) {
                if (ch > '\u007f') {
                    pdf.append("\\");
                    pdf.append(Integer.toOctalString(ch));
                } else {
                    switch (ch) {
                        case '(': 
                        case ')': 
                        case '\\': {
                            pdf.append("\\");
                        }
                    }
                    pdf.append(ch);
                }
            } else {
                pdf.append(this.getUnicodeString(ch));
            }
            if (kerningAvailable && i + 1 < l) {
                this.addKerning(pdf, new Integer(ch), new Integer(fs.mapChar(s.charAt(i + 1))), kerning, startText, endText);
            }
            ++i;
        }
    }

    private String getUnicodeString(char c) {
        StringBuffer buf = new StringBuffer(4);
        byte[] uniBytes = null;
        try {
            char[] a = new char[]{c};
            uniBytes = new String(a).getBytes("UnicodeBigUnmarked");
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        int i = 0;
        while (i < uniBytes.length) {
            int b = uniBytes[i] < 0 ? 256 + uniBytes[i] : uniBytes[i];
            String hexString = Integer.toHexString(b);
            buf = hexString.length() == 1 ? buf.append("0" + hexString) : buf.append(hexString);
            ++i;
        }
        return buf.toString();
    }

    private void addKerning(StringBuffer buf, Integer ch1, Integer ch2, Map kerning, String startText, String endText) {
        Integer width;
        Map kernPair = (Map)kerning.get(ch1);
        if (kernPair != null && (width = (Integer)kernPair.get(ch2)) != null) {
            buf.append(endText).append(-width.intValue());
            buf.append(' ').append(startText);
        }
    }

    protected void closeText() {
        if (this.textOpen) {
            this.currentStream.add("] TJ\n");
            this.textOpen = false;
            this.prevWordX = 0;
            this.prevWordY = 0;
        }
    }

    private void updateColor(ColorType col, boolean fill, StringBuffer pdf) {
        Color newCol = new Color(col.getRed(), col.getGreen(), col.getBlue());
        boolean update = false;
        update = fill ? this.currentState.setBackColor(newCol) : this.currentState.setColor(newCol);
        if (update) {
            PDFColor color = new PDFColor(col.getRed(), col.getGreen(), col.getBlue());
            this.closeText();
            if (pdf != null) {
                pdf.append(color.getColorSpaceOut(fill));
            } else {
                this.currentStream.add(color.getColorSpaceOut(fill));
            }
        }
    }

    private void updateFont(String name, int size, StringBuffer pdf) {
        if (!name.equals(this.currentFontName) || size != this.currentFontSize) {
            this.closeText();
            this.currentFontName = name;
            this.currentFontSize = size;
            pdf = pdf.append("/" + name + " " + (float)size / 1000.0f + " Tf\n");
        }
    }

    public void renderImage(Image image, Rectangle2D pos) {
        String url = image.getURL();
        this.putImage(url, pos);
    }

    protected void putImage(String url, Rectangle2D pos) {
        PDFXObject xobject = this.pdfDoc.getImage(url);
        if (xobject != null) {
            int w = (int)pos.getWidth() / 1000;
            int h = (int)pos.getHeight() / 1000;
            this.placeImage((int)pos.getX() / 1000, (int)pos.getY() / 1000, w, h, xobject.getXNumber());
            return;
        }
        ImageFactory fact = ImageFactory.getInstance();
        FopImage fopimage = fact.getImage(url, this.userAgent);
        if (fopimage == null) {
            return;
        }
        if (!fopimage.load(1, this.userAgent)) {
            return;
        }
        String mime = fopimage.getMimeType();
        if ("text/xml".equals(mime)) {
            if (!fopimage.load(2, this.userAgent)) {
                return;
            }
            Document doc = ((XMLImage)fopimage).getDocument();
            String ns = ((XMLImage)fopimage).getNameSpace();
            this.renderDocument(doc, ns, pos);
        } else if ("image/svg+xml".equals(mime)) {
            if (!fopimage.load(2, this.userAgent)) {
                return;
            }
            Document doc = ((XMLImage)fopimage).getDocument();
            String ns = ((XMLImage)fopimage).getNameSpace();
            this.renderDocument(doc, ns, pos);
        } else if ("image/eps".equals(mime)) {
            if (!fopimage.load(2, this.userAgent)) {
                return;
            }
            FopPDFImage pdfimage = new FopPDFImage(fopimage, url);
            int xobj = this.pdfDoc.addImage(this.currentContext, pdfimage).getXNumber();
            fact.releaseImage(url, this.userAgent);
        } else if ("image/jpeg".equals(mime)) {
            if (!fopimage.load(2, this.userAgent)) {
                return;
            }
            FopPDFImage pdfimage = new FopPDFImage(fopimage, url);
            int xobj = this.pdfDoc.addImage(this.currentContext, pdfimage).getXNumber();
            fact.releaseImage(url, this.userAgent);
            int w = (int)pos.getWidth() / 1000;
            int h = (int)pos.getHeight() / 1000;
            this.placeImage((int)pos.getX() / 1000, (int)pos.getY() / 1000, w, h, xobj);
        } else {
            if (!fopimage.load(4, this.userAgent)) {
                return;
            }
            FopPDFImage pdfimage = new FopPDFImage(fopimage, url);
            int xobj = this.pdfDoc.addImage(this.currentContext, pdfimage).getXNumber();
            fact.releaseImage(url, this.userAgent);
            int w = (int)pos.getWidth() / 1000;
            int h = (int)pos.getHeight() / 1000;
            this.placeImage((int)pos.getX() / 1000, (int)pos.getY() / 1000, w, h, xobj);
        }
        try {
            this.pdfDoc.output(this.ostream);
        }
        catch (IOException ioe) {}
    }

    protected void placeImage(int x, int y, int w, int h, int xobj) {
        this.saveGraphicsState();
        this.currentStream.add((float)w + " 0 0 " + (float)(-h) + " " + ((float)this.currentBlockIPPosition / 1000.0f + (float)x) + " " + ((float)(this.currentBPPosition + 1000 * h) / 1000.0f + (float)y) + " cm\n" + "/Im" + xobj + " Do\n");
        this.restoreGraphicsState();
    }

    public void renderForeignObject(ForeignObject fo, Rectangle2D pos) {
        Document doc = fo.getDocument();
        String ns = fo.getNameSpace();
        this.renderDocument(doc, ns, pos);
    }

    public void renderDocument(Document doc, String ns, Rectangle2D pos) {
        RendererContext context = new RendererContext(MIME_TYPE);
        context.setUserAgent(this.userAgent);
        context.setProperty("pdfDoc", this.pdfDoc);
        context.setProperty("outputStream", this.ostream);
        context.setProperty("pdfState", this.currentState);
        context.setProperty("pdfPage", this.currentPage);
        context.setProperty("pdfContext", this.currentContext == null ? this.currentPage : this.currentContext);
        context.setProperty("pdfContext", this.currentContext);
        context.setProperty("pdfStream", this.currentStream);
        context.setProperty("xpos", new Integer(this.currentBlockIPPosition + (int)pos.getX()));
        context.setProperty("ypos", new Integer(this.currentBPPosition + (int)pos.getY()));
        context.setProperty("fontInfo", this.fontInfo);
        context.setProperty("fontName", this.currentFontName);
        context.setProperty("fontSize", new Integer(this.currentFontSize));
        context.setProperty("width", new Integer((int)pos.getWidth()));
        context.setProperty("height", new Integer((int)pos.getHeight()));
        this.userAgent.renderXML(context, doc, ns);
    }

    public void renderViewport(Viewport viewport) {
        this.closeText();
        float x = (float)this.currentBlockIPPosition / 1000.0f;
        float y = (float)(this.currentBPPosition + viewport.getOffset()) / 1000.0f;
        float width = (float)viewport.getWidth() / 1000.0f;
        float height = (float)viewport.getHeight() / 1000.0f;
        this.drawBackAndBorders(viewport, x, y, width, height);
        this.endTextObject();
        if (viewport.getClip()) {
            this.saveGraphicsState();
            this.clip(x, y, width, height);
        }
        super.renderViewport(viewport);
        if (viewport.getClip()) {
            this.restoreGraphicsState();
        }
        this.beginTextObject();
    }

    public void renderLeader(Leader area) {
        this.closeText();
        this.endTextObject();
        this.saveGraphicsState();
        int style = area.getRuleStyle();
        boolean alt = false;
        switch (style) {
            case 85: {
                this.currentStream.add("[] 0 d\n");
                break;
            }
            case 21: {
                this.currentStream.add("[2] 0 d\n");
                break;
            }
            case 17: {
                this.currentStream.add("[6 4] 0 d\n");
                break;
            }
            case 22: 
            case 35: 
            case 77: {
                alt = true;
            }
        }
        float startx = (float)this.currentBlockIPPosition / 1000.0f;
        float starty = (float)(this.currentBPPosition + area.getOffset()) / 1000.0f;
        float endx = (float)(this.currentBlockIPPosition + area.getWidth()) / 1000.0f;
        if (!alt) {
            this.currentStream.add((float)area.getRuleThickness() / 1000.0f + " w\n");
            this.drawLine(startx, starty, endx, starty);
        } else if (style == 22) {
            float third = (float)area.getRuleThickness() / 3000.0f;
            this.currentStream.add(third + " w\n");
            this.drawLine(startx, starty, endx, starty);
            this.drawLine(startx, starty + 2.0f * third, endx, starty + 2.0f * third);
        } else {
            float half = (float)area.getRuleThickness() / 2000.0f;
            this.currentStream.add("1 g\n");
            this.currentStream.add(startx + " " + starty + " m\n");
            this.currentStream.add(endx + " " + starty + " l\n");
            this.currentStream.add(endx + " " + (starty + 2.0f * half) + " l\n");
            this.currentStream.add(startx + " " + (starty + 2.0f * half) + " l\n");
            this.currentStream.add("h\n");
            this.currentStream.add("f\n");
            if (style == 35) {
                this.currentStream.add("0 g\n");
                this.currentStream.add(startx + " " + starty + " m\n");
                this.currentStream.add(endx + " " + starty + " l\n");
                this.currentStream.add(endx + " " + (starty + half) + " l\n");
                this.currentStream.add(startx + half + " " + (starty + half) + " l\n");
                this.currentStream.add(startx + " " + (starty + 2.0f * half) + " l\n");
            } else {
                this.currentStream.add("0 g\n");
                this.currentStream.add(endx + " " + starty + " m\n");
                this.currentStream.add(endx + " " + (starty + 2.0f * half) + " l\n");
                this.currentStream.add(startx + " " + (starty + 2.0f * half) + " l\n");
                this.currentStream.add(startx + " " + (starty + half) + " l\n");
                this.currentStream.add(endx - half + " " + (starty + half) + " l\n");
            }
            this.currentStream.add("h\n");
            this.currentStream.add("f\n");
        }
        this.restoreGraphicsState();
        this.beginTextObject();
        super.renderLeader(area);
    }
}

