/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.ps;

import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.fop.apps.FOPException;
import org.apache.fop.area.BlockViewport;
import org.apache.fop.area.CTM;
import org.apache.fop.area.PageViewport;
import org.apache.fop.area.Trait;
import org.apache.fop.area.inline.ForeignObject;
import org.apache.fop.area.inline.Word;
import org.apache.fop.datatypes.ColorType;
import org.apache.fop.fo.FOUserAgent;
import org.apache.fop.fonts.Font;
import org.apache.fop.layout.FontInfo;
import org.apache.fop.render.AbstractRenderer;
import org.apache.fop.render.RendererContext;
import org.apache.fop.render.pdf.FontSetup;
import org.apache.fop.render.ps.PSGenerator;
import org.apache.fop.render.ps.PSProcSets;
import org.apache.fop.render.ps.PSXMLHandler;
import org.w3c.dom.Document;

public class PSRenderer
extends AbstractRenderer {
    public static final String MIME_TYPE = "application/postscript";
    protected String producer;
    private int currentPageNumber = 0;
    private boolean enableComments = true;
    protected PSGenerator gen;
    private boolean ioTrouble = false;
    private String currentFontName;
    private int currentFontSize;
    private int pageHeight;
    private int pageWidth;
    private float currRed;
    private float currGreen;
    private float currBlue;
    private FontInfo fontInfo;

    public void setProducer(String producer) {
        this.producer = producer;
    }

    public void setUserAgent(FOUserAgent agent) {
        super.setUserAgent(agent);
        PSXMLHandler xmlHandler = new PSXMLHandler();
        String svg = "http://www.w3.org/2000/svg";
        this.userAgent.addXMLHandler(MIME_TYPE, svg, xmlHandler);
    }

    protected void writeln(String cmd) {
        try {
            this.gen.writeln(cmd);
        }
        catch (IOException ioe) {
            this.handleIOTrouble(ioe);
        }
    }

    protected void handleIOTrouble(IOException ioe) {
        if (!this.ioTrouble) {
            this.getLogger().error("Error while writing to target file", (Throwable)ioe);
            this.ioTrouble = true;
        }
    }

    protected void comment(String comment) {
        if (this.enableComments) {
            this.writeln(comment);
        }
    }

    protected void writeFontDict(FontInfo fontInfo) {
        Font fm;
        String key;
        this.writeln("%%BeginResource: procset FOPFonts");
        this.writeln("%%Title: Font setup (shortcuts) for this file");
        this.writeln("/FOPFonts 100 dict dup begin");
        Map fonts = fontInfo.getFonts();
        Iterator iterator = fonts.keySet().iterator();
        while (iterator.hasNext()) {
            key = (String)iterator.next();
            fm = (Font)fonts.get(key);
            this.writeln("/" + key + " /" + fm.getFontName() + " def");
        }
        this.writeln("end def");
        this.writeln("%%EndResource");
        iterator = fonts.keySet().iterator();
        while (iterator.hasNext()) {
            key = (String)iterator.next();
            fm = (Font)fonts.get(key);
            this.writeln("/" + fm.getFontName() + " findfont");
            this.writeln("dup length dict begin");
            this.writeln("  {1 index /FID ne {def} {pop pop} ifelse} forall");
            this.writeln("  /Encoding ISOLatin1Encoding def");
            this.writeln("  currentdict");
            this.writeln("end");
            this.writeln("/" + fm.getFontName() + " exch definefont pop");
        }
    }

    protected void movetoCurrPosition() {
        this.moveTo(this.currentIPPosition, this.currentBPPosition);
    }

    protected void moveTo(int x, int y) {
        this.writeln(x + " " + y + " M");
    }

    public void saveGraphicsState() {
        try {
            this.gen.saveGraphicsState();
        }
        catch (IOException ioe) {
            this.handleIOTrouble(ioe);
        }
    }

    public void restoreGraphicsState() {
        try {
            this.gen.restoreGraphicsState();
        }
        catch (IOException ioe) {
            this.handleIOTrouble(ioe);
        }
    }

    protected void beginTextObject() {
        this.writeln("BT");
    }

    protected void endTextObject() {
        this.writeln("ET");
    }

    protected void concatMatrix(double a, double b, double c, double d, double e, double f) {
        try {
            this.gen.concatMatrix(a, b, c, d, e, f);
        }
        catch (IOException ioe) {
            this.handleIOTrouble(ioe);
        }
    }

    protected void concatMatrix(double[] matrix) {
        try {
            this.gen.concatMatrix(matrix);
        }
        catch (IOException ioe) {
            this.handleIOTrouble(ioe);
        }
    }

    public void setupFontInfo(FontInfo fontInfo) {
        FontSetup.setup(fontInfo, null);
        this.fontInfo = fontInfo;
    }

    protected void fillRect(int x, int y, int w, int h, ColorType col) {
        this.useColor(col);
        this.writeln(x + " " + y + " " + w + " " + h + " rectfill");
    }

    protected void drawRect(int x, int y, int w, int h) {
        this.writeln(x + " " + y + " " + w + " " + h + " rectstroke");
    }

    protected void clip(float x, float y, float width, float height) {
        this.writeln(x + " " + y + " " + width + " " + height + " rectclip");
    }

    public void useFont(String name, int size) {
        if (this.currentFontName != name || this.currentFontSize != size) {
            this.writeln(name + " " + size + " F");
            this.currentFontName = name;
            this.currentFontSize = size;
        }
    }

    private void useColor(ColorType col) {
        this.useColor(col.getRed(), col.getGreen(), col.getBlue());
    }

    private void useColor(float red, float green, float blue) {
        if (red != this.currRed || green != this.currGreen || blue != this.currBlue) {
            this.writeln(red + " " + green + " " + blue + " setrgbcolor");
            this.currRed = red;
            this.currGreen = green;
            this.currBlue = blue;
        }
    }

    public void startRenderer(OutputStream outputStream) throws IOException {
        this.getLogger().debug("rendering areas to PostScript");
        this.gen = new PSGenerator(outputStream);
        this.currentPageNumber = 0;
        this.writeln("%!PS-Adobe-3.0");
        this.gen.writeDSCComment("Creator", new String[]{"FOP " + this.producer});
        this.gen.writeDSCComment("CreationDate", new Object[]{new Date()});
        this.gen.writeDSCComment("Pages", new Object[]{PSGenerator.ATEND});
        this.gen.writeDSCComment("EndComments");
        this.gen.writeDSCComment("BeginDefaults");
        this.gen.writeDSCComment("EndDefaults");
        this.gen.writeDSCComment("BeginProlog");
        this.gen.writeDSCComment("EndProlog");
        this.gen.writeDSCComment("BeginSetup");
        PSProcSets.writeFOPStdProcSet(this.gen);
        PSProcSets.writeFOPEPSProcSet(this.gen);
        this.writeFontDict(this.fontInfo);
        this.gen.writeDSCComment("EndSetup");
    }

    public void stopRenderer() throws IOException {
        this.gen.writeDSCComment("Trailer");
        this.gen.writeDSCComment("Pages", new Integer(this.currentPageNumber));
        this.gen.writeDSCComment("EOF");
        this.gen.flush();
    }

    public void renderPage(PageViewport page) throws IOException, FOPException {
        this.getLogger().debug("renderPage(): " + page);
        ++this.currentPageNumber;
        this.gen.writeDSCComment("Page", new Object[]{page.getPageNumber(), new Integer(this.currentPageNumber)});
        Integer zero = new Integer(0);
        Long pagewidth = new Long(Math.round(page.getViewArea().getWidth() / 1000.0));
        Long pageheight = new Long(Math.round(page.getViewArea().getHeight() / 1000.0));
        this.gen.writeDSCComment("PageBoundingBox", new Object[]{zero, zero, pagewidth, pageheight});
        this.gen.writeDSCComment("BeginPageSetup");
        this.gen.writeln("FOPFonts begin");
        this.concatMatrix(1.0, 0.0, 0.0, -1.0, 0.0, pageheight.doubleValue());
        this.gen.writeln("0.001 0.001 scale");
        this.gen.writeDSCComment("EndPageSetup");
        super.renderPage(page);
        this.writeln("showpage");
        this.gen.writeDSCComment("PageTrailer");
        this.gen.writeDSCComment("EndPage");
    }

    protected void paintText(int rx, int bl, String text, Font font) {
        this.saveGraphicsState();
        this.writeln("1 0 0 -1 " + rx + " " + bl + " Tm");
        int initialSize = text.length();
        initialSize += initialSize / 2;
        StringBuffer sb = new StringBuffer(initialSize);
        sb.append("(");
        int i = 0;
        while (i < text.length()) {
            char c = text.charAt(i);
            char mapped = font.mapChar(c);
            PSGenerator.escapeChar(mapped, sb);
            ++i;
        }
        sb.append(") t");
        this.writeln(sb.toString());
        this.restoreGraphicsState();
    }

    public void renderWord(Word area) {
        String fontname = (String)area.getTrait(Trait.FONT_NAME);
        int fontsize = area.getTraitAsInteger(Trait.FONT_SIZE);
        Font f = (Font)this.fontInfo.getFonts().get(fontname);
        int rx = this.currentBlockIPPosition;
        int bl = this.currentBPPosition + area.getOffset();
        this.useFont(fontname, fontsize);
        this.paintText(rx, bl, area.getWord(), f);
        super.renderWord(area);
    }

    protected void renderBlockViewport(BlockViewport bv, List children) {
        int saveIP = this.currentIPPosition;
        int saveBP = this.currentBPPosition;
        String saveFontName = this.currentFontName;
        CTM ctm = bv.getCTM();
        if (bv.getPositioning() == 2) {
            this.currentIPPosition = 0;
            this.currentBPPosition = 0;
            this.endTextObject();
            if (bv.getClip()) {
                this.saveGraphicsState();
                int x = bv.getXOffset() + this.containingIPPosition;
                int y = bv.getYOffset() + this.containingBPPosition;
                int width = bv.getWidth();
                int height = bv.getHeight();
                this.clip(x, y, width, height);
            }
            CTM tempctm = new CTM(this.containingIPPosition, this.containingBPPosition);
            ctm = tempctm.multiply(ctm);
            this.startVParea(ctm);
            this.handleBlockTraits(bv);
            this.renderBlocks(children);
            this.endVParea();
            if (bv.getClip()) {
                this.restoreGraphicsState();
            }
            this.beginTextObject();
            this.currentIPPosition = saveIP;
            this.currentBPPosition = saveBP;
        } else {
            if (ctm != null) {
                this.currentIPPosition = 0;
                this.currentBPPosition = 0;
                this.endTextObject();
                double[] vals = ctm.toArray();
                ctm = vals[2] == 1.0 ? ctm.translate(-saveBP - bv.getHeight(), -saveIP) : (vals[0] == -1.0 ? ctm.translate(-saveIP - bv.getWidth(), -saveBP - bv.getHeight()) : ctm.translate(saveBP, saveIP - bv.getWidth()));
            }
            if (bv.getClip()) {
                if (ctm == null) {
                    this.endTextObject();
                }
                this.saveGraphicsState();
                int x = bv.getXOffset();
                int y = bv.getYOffset();
                int width = bv.getWidth();
                int height = bv.getHeight();
                this.clip(x, y, width, height);
            }
            if (ctm != null) {
                this.startVParea(ctm);
            }
            this.handleBlockTraits(bv);
            this.renderBlocks(children);
            if (ctm != null) {
                this.endVParea();
            }
            if (bv.getClip()) {
                this.restoreGraphicsState();
                if (ctm == null) {
                    this.beginTextObject();
                }
            }
            if (ctm != null) {
                this.beginTextObject();
            }
            this.currentIPPosition = saveIP;
            this.currentBPPosition = saveBP;
            this.currentBPPosition += bv.getHeight();
        }
        this.currentFontName = saveFontName;
    }

    protected void startVParea(CTM ctm) {
        this.saveGraphicsState();
        double[] matrix = ctm.toArray();
        this.concatMatrix(matrix);
        this.beginTextObject();
    }

    protected void endVParea() {
        this.endTextObject();
        this.restoreGraphicsState();
    }

    public void renderForeignObject(ForeignObject fo, Rectangle2D pos) {
        Document doc = fo.getDocument();
        String ns = fo.getNameSpace();
        this.renderDocument(doc, ns, pos);
    }

    public void renderDocument(Document doc, String ns, Rectangle2D pos) {
        RendererContext context = new RendererContext(MIME_TYPE);
        context.setUserAgent(this.userAgent);
        context.setProperty("psGenerator", this.gen);
        context.setProperty("psFontInfo", this.fontInfo);
        context.setProperty("width", new Integer((int)pos.getWidth()));
        context.setProperty("height", new Integer((int)pos.getHeight()));
        context.setProperty("xpos", new Integer(this.currentBlockIPPosition + (int)pos.getX()));
        context.setProperty("ypos", new Integer(this.currentBPPosition + (int)pos.getY()));
        this.userAgent.renderXML(context, doc, ns);
    }
}

