/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.xml;

import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.fop.apps.FOPException;
import org.apache.fop.area.BeforeFloat;
import org.apache.fop.area.Block;
import org.apache.fop.area.BodyRegion;
import org.apache.fop.area.Flow;
import org.apache.fop.area.Footnote;
import org.apache.fop.area.LineArea;
import org.apache.fop.area.MainReference;
import org.apache.fop.area.PageViewport;
import org.apache.fop.area.RegionReference;
import org.apache.fop.area.RegionViewport;
import org.apache.fop.area.Span;
import org.apache.fop.area.Title;
import org.apache.fop.area.Trait;
import org.apache.fop.area.inline.Character;
import org.apache.fop.area.inline.Container;
import org.apache.fop.area.inline.ForeignObject;
import org.apache.fop.area.inline.Image;
import org.apache.fop.area.inline.InlineArea;
import org.apache.fop.area.inline.InlineParent;
import org.apache.fop.area.inline.Leader;
import org.apache.fop.area.inline.Space;
import org.apache.fop.area.inline.Viewport;
import org.apache.fop.area.inline.Word;
import org.apache.fop.fo.FOUserAgent;
import org.apache.fop.layout.FontInfo;
import org.apache.fop.render.AbstractRenderer;
import org.apache.fop.render.RendererContext;
import org.apache.fop.render.pdf.FontSetup;
import org.apache.fop.render.xml.XMLXMLHandler;
import org.w3c.dom.Document;

public class XMLRenderer
extends AbstractRenderer {
    public static final String XML_MIME_TYPE = "text/xml";
    private boolean startedSequence = false;
    private RendererContext context = new RendererContext("text/xml");
    protected int indent = 0;
    protected String producer;
    protected PrintWriter writer;
    private boolean consistentOutput = false;

    public void setProducer(String producer) {
    }

    public void setUserAgent(FOUserAgent agent) {
        super.setUserAgent(agent);
        XMLXMLHandler handler = new XMLXMLHandler();
        this.userAgent.setDefaultXMLHandler(XML_MIME_TYPE, handler);
        String svg = "http://www.w3.org/2000/svg";
        this.userAgent.addXMLHandler(XML_MIME_TYPE, svg, handler);
    }

    protected void writeIndent() {
        StringBuffer s = new StringBuffer();
        int i = 0;
        while (i < this.indent) {
            s = s.append("  ");
            ++i;
        }
        this.writer.write(s.toString());
    }

    protected void writeElement(String element) {
        this.writeIndent();
        this.writer.write(element + "\n");
    }

    protected void writeEmptyElementTag(String tag) {
        this.writeIndent();
        this.writer.write(tag + "\n");
    }

    protected void writeEndTag(String tag) {
        --this.indent;
        this.writeIndent();
        this.writer.write(tag + "\n");
    }

    protected void writeStartTag(String tag) {
        this.writeIndent();
        this.writer.write(tag + "\n");
        ++this.indent;
    }

    public void setupFontInfo(FontInfo fontInfo) {
        FontSetup.setup(fontInfo, null);
    }

    private boolean isCoarseXml() {
        return (Boolean)this.options.get("fineDetail");
    }

    public void startRenderer(OutputStream outputStream) throws IOException {
        this.getLogger().debug("rendering areas to XML");
        this.writer = new PrintWriter(outputStream);
        this.writer.write("<?xml version=\"1.0\"?>\n<!-- produced by " + this.producer + " -->\n");
        this.writeStartTag("<areaTree>");
    }

    public void stopRenderer() throws IOException {
        this.writeEndTag("</pageSequence>");
        this.writeEndTag("</areaTree>");
        this.writer.flush();
        this.getLogger().debug("written out XML");
    }

    public void renderPage(PageViewport page) throws IOException, FOPException {
        this.writeStartTag("<pageViewport bounds=\"" + this.createString(page.getViewArea()) + "\">");
        this.writeStartTag("<page>");
        super.renderPage(page);
        this.writeEndTag("</page>");
        this.writeEndTag("</pageViewport>");
    }

    private String createString(Rectangle2D rect) {
        return "" + (int)rect.getX() + " " + (int)rect.getY() + " " + (int)rect.getWidth() + " " + (int)rect.getHeight();
    }

    public void startPageSequence(Title seqTitle) {
        if (this.startedSequence) {
            this.writeEndTag("</pageSequence>");
        }
        this.startedSequence = true;
        this.writeStartTag("<pageSequence>");
        if (seqTitle != null) {
            this.writeStartTag("<title>");
            List children = seqTitle.getInlineAreas();
            int count = 0;
            while (count < children.size()) {
                InlineArea inline = (InlineArea)children.get(count);
                inline.render(this);
                ++count;
            }
            this.writeEndTag("</title>");
        }
    }

    protected void renderRegionViewport(RegionViewport port) {
        if (port != null) {
            this.writeStartTag("<regionViewport rect=\"" + this.createString(port.getViewArea()) + "\">");
            RegionReference region = port.getRegion();
            if (region.getRegionClass() == 0) {
                this.writeStartTag("<regionBefore>");
                this.renderRegion(region);
                this.writeEndTag("</regionBefore>");
            } else if (region.getRegionClass() == 1) {
                this.writeStartTag("<regionStart>");
                this.renderRegion(region);
                this.writeEndTag("</regionStart>");
            } else if (region.getRegionClass() == 2) {
                this.writeStartTag("<regionBody>");
                this.renderBodyRegion((BodyRegion)region);
                this.writeEndTag("</regionBody>");
            } else if (region.getRegionClass() == 3) {
                this.writeStartTag("<regionEnd>");
                this.renderRegion(region);
                this.writeEndTag("</regionEnd>");
            } else if (region.getRegionClass() == 4) {
                this.writeStartTag("<regionAfter>");
                this.renderRegion(region);
                this.writeEndTag("</regionAfter>");
            }
            this.writeEndTag("</regionViewport>");
        }
    }

    protected void renderBeforeFloat(BeforeFloat bf) {
        this.writeStartTag("<beforeFloat>");
        super.renderBeforeFloat(bf);
        this.writeEndTag("</beforeFloat>");
    }

    protected void renderFootnote(Footnote footnote) {
        this.writeStartTag("<footnote>");
        super.renderFootnote(footnote);
        this.writeEndTag("</footnote>");
    }

    protected void renderMainReference(MainReference mr) {
        this.writeStartTag("<mainReference columnGap=\"" + mr.getColumnGap() + "\" width=\"" + mr.getWidth() + "\">");
        Span span = null;
        List spans = mr.getSpans();
        int count = 0;
        while (count < spans.size()) {
            span = (Span)spans.get(count);
            this.writeStartTag("<span>");
            int c = 0;
            while (c < span.getColumnCount()) {
                Flow flow = span.getFlow(c);
                this.renderFlow(flow);
                ++c;
            }
            this.writeEndTag("</span>");
            ++count;
        }
        this.writeEndTag("</mainReference>");
    }

    protected void renderFlow(Flow flow) {
        this.writeStartTag("<flow>");
        super.renderFlow(flow);
        this.writeEndTag("</flow>");
    }

    protected void renderBlock(Block block) {
        String prop = "";
        Map map = block.getTraits();
        if (map != null) {
            prop = " props=\"" + this.getPropString(map) + "\"";
        }
        this.writeStartTag("<block" + prop + ">");
        super.renderBlock(block);
        this.writeEndTag("</block>");
    }

    protected void renderLineArea(LineArea line) {
        String prop = "";
        Map map = line.getTraits();
        if (map != null) {
            prop = " props=\"" + this.getPropString(map) + "\"";
        }
        this.writeStartTag("<lineArea height=\"" + line.getHeight() + "\"" + prop + ">");
        super.renderLineArea(line);
        this.writeEndTag("</lineArea>");
    }

    public void renderViewport(Viewport viewport) {
        this.writeStartTag("<viewport>");
        super.renderViewport(viewport);
        this.writeEndTag("</viewport>");
    }

    public void renderImage(Image image) {
        this.writeElement("<image url=\"" + image.getURL() + "\"/>");
    }

    public void renderContainer(Container cont) {
        this.writeStartTag("<container>");
        super.renderContainer(cont);
        this.writeEndTag("</container>");
    }

    public void renderForeignObject(ForeignObject fo) {
        this.writeStartTag("<foreignObject>");
        Document doc = fo.getDocument();
        String ns = fo.getNameSpace();
        this.context.setProperty("writer", this.writer);
        this.userAgent.renderXML(this.context, doc, ns);
        this.writeEndTag("</foreignObject>");
    }

    public void renderCharacter(Character ch) {
        String prop = "";
        Map map = ch.getTraits();
        if (map != null) {
            prop = " props=\"" + this.getPropString(map) + "\"";
        }
        this.writeElement("<char" + prop + ">" + ch.getChar() + "</char>");
    }

    public void renderInlineSpace(Space space) {
        this.writeElement("<space width=\"" + space.getWidth() + "\"/>");
    }

    public void renderWord(Word word) {
        String prop = "";
        Map map = word.getTraits();
        if (map != null) {
            prop = " props=\"" + this.getPropString(map) + "\"";
        }
        this.writeElement("<word wsadjust=\"" + word.getWSadjust() + "\"" + prop + ">" + word.getWord() + "</word>");
        super.renderWord(word);
    }

    public void renderInlineParent(InlineParent ip) {
        String prop = "";
        Map map = ip.getTraits();
        if (map != null) {
            prop = " props=\"" + this.getPropString(map) + "\"";
        }
        this.writeStartTag("<inlineparent" + prop + ">");
        super.renderInlineParent(ip);
        this.writeEndTag("</inlineparent>");
    }

    public void renderLeader(Leader area) {
        String style = "solid";
        switch (area.getRuleStyle()) {
            case 21: {
                style = "dotted";
                break;
            }
            case 17: {
                style = "dashed";
                break;
            }
            case 85: {
                break;
            }
            case 22: {
                style = "double";
                break;
            }
            case 35: {
                style = "groove";
                break;
            }
            case 77: {
                style = "ridge";
            }
        }
        this.writeElement("<leader width=\"" + area.getWidth() + "\" ruleStyle=\"" + style + "\" ruleThickness=\"" + area.getRuleThickness() + "\"/>");
        super.renderLeader(area);
    }

    protected String getPropString(Map traitMap) {
        StringBuffer strbuf = new StringBuffer();
        Iterator iter = traitMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry traitEntry = iter.next();
            strbuf.append(Trait.getTraitName(traitEntry.getKey()));
            strbuf.append(':');
            strbuf.append(traitEntry.getValue().toString());
            strbuf.append(';');
        }
        return strbuf.toString();
    }
}

