/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.rtf.renderer;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.StructureHandler;
import org.apache.fop.fo.Title;
import org.apache.fop.fo.flow.Block;
import org.apache.fop.fo.flow.Flow;
import org.apache.fop.fo.pagination.LayoutMasterSet;
import org.apache.fop.fo.pagination.PageSequence;
import org.apache.fop.layout.FontInfo;
import org.apache.fop.render.pdf.FontSetup;
import org.jfor.jfor.rtflib.rtfdoc.RtfDocumentArea;
import org.jfor.jfor.rtflib.rtfdoc.RtfFile;
import org.jfor.jfor.rtflib.rtfdoc.RtfParagraph;
import org.jfor.jfor.rtflib.rtfdoc.RtfSection;
import org.xml.sax.SAXException;

public class RTFHandler
extends StructureHandler {
    private FontInfo fontInfo = new FontInfo();
    private RtfFile rtfFile;
    private final OutputStream os;
    private RtfSection sect;
    private RtfDocumentArea docArea;
    private RtfParagraph para;
    private boolean warned = false;
    private static final String ALPHA_WARNING = "WARNING: RTF renderer is veryveryalpha at this time, see class org.apache.fop.rtf.renderer.RTFHandler";

    public RTFHandler(OutputStream os) {
        this.os = os;
        FontSetup.setup(this.fontInfo, null);
        System.err.println(ALPHA_WARNING);
    }

    public FontInfo getFontInfo() {
        return this.fontInfo;
    }

    public void startDocument() throws SAXException {
        try {
            this.rtfFile = new RtfFile((Writer)new OutputStreamWriter(this.os));
            this.docArea = this.rtfFile.startDocumentArea();
        }
        catch (IOException ioe) {
            throw new SAXException("IOException: " + ioe);
        }
    }

    public void endDocument() throws SAXException {
        try {
            this.rtfFile.flush();
        }
        catch (IOException ioe) {
            throw new SAXException("IOException: " + ioe);
        }
    }

    public void startPageSequence(PageSequence pageSeq, Title seqTitle, LayoutMasterSet lms) {
        try {
            this.sect = this.docArea.newSection();
            if (!this.warned) {
                this.sect.newParagraph().newText(ALPHA_WARNING);
                this.warned = true;
            }
        }
        catch (IOException ioe) {
            throw new Error("IOException: " + ioe);
        }
    }

    public void endPageSequence(PageSequence pageSeq) throws FOPException {
    }

    public void startFlow(Flow fl) {
    }

    public void endFlow(Flow fl) {
    }

    public void startBlock(Block bl) {
        try {
            this.para = this.sect.newParagraph();
        }
        catch (IOException ioe) {
            throw new Error("IOException: " + ioe);
        }
    }

    public void endBlock(Block bl) {
    }

    public void characters(char[] data, int start, int length) {
        try {
            this.para.newText(new String(data, start, length));
        }
        catch (IOException ioe) {
            throw new Error("IOException: " + ioe);
        }
    }
}

