/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.servlet;

import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.TransformerFactory;
import org.apache.avalon.framework.logger.ConsoleLogger;
import org.apache.avalon.framework.logger.Logger;
import org.apache.fop.apps.Driver;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.XSLTInputHandler;
import org.apache.fop.area.PageViewport;
import org.apache.fop.render.awt.AWTRenderer;
import org.xml.sax.InputSource;

public class FopPrintServlet
extends HttpServlet {
    protected static final String FO_REQUEST_PARAM = "fo";
    protected static final String XML_REQUEST_PARAM = "xml";
    protected static final String XSLT_REQUEST_PARAM = "xslt";
    protected Logger log = null;
    protected TransformerFactory transFactory = null;

    public void init() throws ServletException {
        this.log = new ConsoleLogger(2);
        this.transFactory = TransformerFactory.newInstance();
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        if (this.log == null) {
            this.log = new ConsoleLogger(2);
        }
        try {
            String foParam = request.getParameter(FO_REQUEST_PARAM);
            String xmlParam = request.getParameter(XML_REQUEST_PARAM);
            String xsltParam = request.getParameter(XSLT_REQUEST_PARAM);
            if (foParam != null) {
                FileInputStream file = new FileInputStream(foParam);
                this.renderFO(new InputSource(file), response);
            } else if (xmlParam != null && xsltParam != null) {
                XSLTInputHandler input = new XSLTInputHandler(new File(xmlParam), new File(xsltParam));
                this.renderXML(input, response);
            } else {
                response.setContentType("text/html");
                PrintWriter out = response.getWriter();
                out.println("<html><title>Error</title>\n<body><h1>FopServlet Error</h1>\n<h3>No 'fo' or 'xml/xsl' request param given.</h3></body>\n</html>");
            }
        }
        catch (ServletException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ServletException((Throwable)ex);
        }
    }

    public void renderFO(InputSource foFile, HttpServletResponse response) throws ServletException {
        try {
            Driver driver = new Driver(foFile, null);
            PrinterJob pj = PrinterJob.getPrinterJob();
            PrintRenderer renderer = new PrintRenderer(pj);
            driver.enableLogging(this.log);
            driver.setRenderer(renderer);
            driver.run();
            this.reportOK(response);
        }
        catch (Exception ex) {
            throw new ServletException((Throwable)ex);
        }
    }

    public void renderXML(XSLTInputHandler input, HttpServletResponse response) throws ServletException {
        try {
            Driver driver = new Driver();
            PrinterJob pj = PrinterJob.getPrinterJob();
            PrintRenderer renderer = new PrintRenderer(pj);
            pj.setCopies(1);
            driver.enableLogging(this.log);
            driver.setRenderer(renderer);
            driver.render(input.getParser(), input.getInputSource());
            this.reportOK(response);
        }
        catch (Exception ex) {
            throw new ServletException((Throwable)ex);
        }
    }

    private void reportOK(HttpServletResponse response) throws ServletException {
        String sMsg = "<html><title>Success</title>\n<body><h1>FopPrintServlet: </h1><h3>The requested data was printed</h3></body></html>";
        response.setContentType("text/html");
        response.setContentLength(sMsg.length());
        try {
            PrintWriter out = response.getWriter();
            out.println(sMsg);
            out.flush();
        }
        catch (Exception ex) {
            throw new ServletException((Throwable)ex);
        }
    }

    class PrintRenderer
    extends AWTRenderer {
        private static final int EVEN_AND_ALL = 0;
        private static final int EVEN = 1;
        private static final int ODD = 2;
        private int startNumber;
        private int endNumber;
        private int mode = 0;
        private int copies = 1;
        private PrinterJob printerJob;

        PrintRenderer(PrinterJob printerJob) {
            super(null);
            this.printerJob = printerJob;
            this.startNumber = 0;
            this.endNumber = -1;
            printerJob.setPageable(this);
            this.mode = 0;
            String str = System.getProperty("even");
            if (str != null) {
                this.mode = Boolean.valueOf(str) != false ? 1 : 2;
            }
        }

        public void stopRenderer() throws IOException {
            super.stopRenderer();
            if (this.endNumber == -1) {
                this.endNumber = this.getPageCount();
            }
            List numbers = this.getInvalidPageNumbers();
            int i = numbers.size() - 1;
            while (i > -1) {
                --i;
            }
            try {
                this.printerJob.print();
            }
            catch (PrinterException e) {
                e.printStackTrace();
                throw new IOException("Unable to print: " + e.getClass().getName() + ": " + e.getMessage());
            }
        }

        public void renderPage(PageViewport page) throws IOException, FOPException {
            this.pageWidth = (int)((float)page.getViewArea().getWidth() / 1000.0f);
            this.pageHeight = (int)((float)page.getViewArea().getHeight() / 1000.0f);
            super.renderPage(page);
        }

        private List getInvalidPageNumbers() {
            ArrayList<String> list = new ArrayList<String>();
            int max = this.getPageCount();
            int i = 0;
            while (i < max) {
                boolean isValid = true;
                if (i < this.startNumber || i > this.endNumber) {
                    isValid = false;
                } else if (this.mode != 0) {
                    if (this.mode == 1 && (i + 1) % 2 != 0) {
                        isValid = false;
                    } else if (this.mode == 2 && (i + 1) % 2 != 1) {
                        isValid = false;
                    }
                }
                if (!isValid) {
                    list.add(Integer.toString(i));
                }
                ++i;
            }
            return list;
        }
    }
}

