/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.svg;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.bridge.UserAgentAdapter;
import org.apache.batik.bridge.ViewBox;
import org.apache.batik.dom.svg.SAXSVGDocumentFactory;
import org.apache.batik.dom.svg.SVGDOMImplementation;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.dom.util.DocumentFactory;
import org.apache.batik.ext.awt.g2d.GraphicContext;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.renderer.StrokingTextPainter;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.TranscodingHints;
import org.apache.batik.transcoder.XMLAbstractTranscoder;
import org.apache.batik.transcoder.image.ImageTranscoder;
import org.apache.batik.transcoder.image.resources.Messages;
import org.apache.batik.util.XMLResourceDescriptor;
import org.apache.fop.svg.PDFAElementBridge;
import org.apache.fop.svg.PDFDocumentGraphics2D;
import org.apache.fop.svg.PDFImageElementBridge;
import org.apache.fop.svg.PDFTextElementBridge;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGSVGElement;

public class PDFTranscoder
extends XMLAbstractTranscoder {
    protected UserAgent userAgent = new ImageTranscoderUserAgent();

    public PDFTranscoder() {
        this.hints.put(XMLAbstractTranscoder.KEY_DOCUMENT_ELEMENT_NAMESPACE_URI, "http://www.w3.org/2000/svg");
        this.hints.put(XMLAbstractTranscoder.KEY_DOCUMENT_ELEMENT, "svg");
        this.hints.put(XMLAbstractTranscoder.KEY_DOM_IMPLEMENTATION, SVGDOMImplementation.getDOMImplementation());
    }

    protected void transcode(Document document, String uri, TranscoderOutput output) throws TranscoderException {
        AffineTransform px;
        float height;
        float width;
        GraphicsNode gvtRoot;
        if (!(document instanceof SVGOMDocument)) {
            throw new TranscoderException(Messages.formatMessage("notsvg", null));
        }
        SVGDocument svgDoc = (SVGDocument)document;
        SVGSVGElement root = svgDoc.getRootElement();
        String parserClassname = (String)this.hints.get(XMLAbstractTranscoder.KEY_XML_PARSER_CLASSNAME);
        PDFDocumentGraphics2D graphics = new PDFDocumentGraphics2D(false);
        GVTBuilder builder = new GVTBuilder();
        BridgeContext ctx = new BridgeContext(this.userAgent);
        StrokingTextPainter textPainter = null;
        textPainter = new StrokingTextPainter();
        ctx.setTextPainter(textPainter);
        PDFTextElementBridge pdfTextElementBridge = new PDFTextElementBridge(graphics.getFontInfo());
        ctx.putBridge(pdfTextElementBridge);
        PDFAElementBridge pdfAElementBridge = new PDFAElementBridge();
        AffineTransform currentTransform = new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
        pdfAElementBridge.setCurrentTransform(currentTransform);
        ctx.putBridge(pdfAElementBridge);
        ctx.putBridge(new PDFImageElementBridge());
        try {
            gvtRoot = builder.build(ctx, svgDoc);
        }
        catch (BridgeException ex) {
            throw new TranscoderException(ex);
        }
        float docWidth = (float)ctx.getDocumentSize().getWidth();
        float docHeight = (float)ctx.getDocumentSize().getHeight();
        ctx = null;
        builder = null;
        float imgWidth = -1.0f;
        if (this.hints.containsKey(ImageTranscoder.KEY_WIDTH)) {
            imgWidth = ((Float)this.hints.get(ImageTranscoder.KEY_WIDTH)).floatValue();
        }
        float imgHeight = -1.0f;
        if (this.hints.containsKey(ImageTranscoder.KEY_HEIGHT)) {
            imgHeight = ((Float)this.hints.get(ImageTranscoder.KEY_HEIGHT)).floatValue();
        }
        if (imgWidth > 0.0f && imgHeight > 0.0f) {
            width = imgWidth;
            height = imgHeight;
        } else if (imgHeight > 0.0f) {
            width = docWidth * imgHeight / docHeight;
            height = imgHeight;
        } else if (imgWidth > 0.0f) {
            width = imgWidth;
            height = docHeight * imgWidth / docWidth;
        } else {
            width = docWidth;
            height = docHeight;
        }
        String ref = null;
        try {
            ref = new URL(uri).getRef();
        }
        catch (MalformedURLException ex) {
            // empty catch block
        }
        try {
            px = ViewBox.getViewTransform(ref, root, width, height);
        }
        catch (BridgeException ex) {
            throw new TranscoderException(ex);
        }
        if (px.isIdentity() && (width != docWidth || height != docHeight)) {
            float d = Math.max(docWidth, docHeight);
            float dd = Math.max(width, height);
            float scale = dd / d;
            px = AffineTransform.getScaleInstance(scale, scale);
        }
        if (this.hints.containsKey(ImageTranscoder.KEY_AOI)) {
            Rectangle2D aoi = (Rectangle2D)this.hints.get(ImageTranscoder.KEY_AOI);
            aoi = px.createTransformedShape(aoi).getBounds2D();
            AffineTransform mx = new AffineTransform();
            double sx = (double)width / aoi.getWidth();
            double sy = (double)height / aoi.getHeight();
            mx.scale(sx, sy);
            double tx = -aoi.getX();
            double ty = -aoi.getY();
            mx.translate(tx, ty);
            px.preConcatenate(mx);
        }
        int w = (int)width;
        int h = (int)height;
        try {
            graphics.setupDocument(output.getOutputStream(), w, h);
        }
        catch (IOException ex) {
            throw new TranscoderException(ex);
        }
        graphics.setSVGDimension(docWidth, docHeight);
        currentTransform.setTransform(1.0, 0.0, 0.0, -1.0, 0.0, height);
        if (this.hints.containsKey(ImageTranscoder.KEY_BACKGROUND_COLOR)) {
            graphics.setBackgroundColor((Color)this.hints.get(ImageTranscoder.KEY_BACKGROUND_COLOR));
        }
        graphics.setGraphicContext(new GraphicContext());
        graphics.setTransform(px);
        gvtRoot.paint(graphics);
        try {
            graphics.finish();
        }
        catch (IOException ex) {
            throw new TranscoderException(ex);
        }
    }

    protected DocumentFactory createDocumentFactory(DOMImplementation domImpl, String parserClassname) {
        return new SAXSVGDocumentFactory(parserClassname);
    }

    protected class ImageTranscoderUserAgent
    extends UserAgentAdapter {
        protected ImageTranscoderUserAgent() {
        }

        public Dimension2D getViewportSize() {
            return new Dimension(400, 400);
        }

        public void displayError(String message) {
            try {
                PDFTranscoder.this.getErrorHandler().error(new TranscoderException(message));
            }
            catch (TranscoderException ex) {
                throw new RuntimeException();
            }
        }

        public void displayError(Exception e) {
            try {
                PDFTranscoder.this.getErrorHandler().error(new TranscoderException(e));
            }
            catch (TranscoderException ex) {
                throw new RuntimeException();
            }
        }

        public void displayMessage(String message) {
            try {
                PDFTranscoder.this.getErrorHandler().warning(new TranscoderException(message));
            }
            catch (TranscoderException ex) {
                throw new RuntimeException();
            }
        }

        public float getPixelUnitToMillimeter() {
            TranscodingHints.Key key = ImageTranscoder.KEY_PIXEL_UNIT_TO_MILLIMETER;
            if (PDFTranscoder.this.getTranscodingHints().containsKey(key)) {
                return ((Float)PDFTranscoder.this.getTranscodingHints().get(key)).floatValue();
            }
            return 0.26458332f;
        }

        public String getLanguages() {
            TranscodingHints.Key key = ImageTranscoder.KEY_LANGUAGE;
            if (PDFTranscoder.this.getTranscodingHints().containsKey(key)) {
                return (String)PDFTranscoder.this.getTranscodingHints().get(key);
            }
            return "en";
        }

        public String getMedia() {
            return "print";
        }

        public String getUserStyleSheetURI() {
            return (String)PDFTranscoder.this.getTranscodingHints().get(ImageTranscoder.KEY_USER_STYLESHEET_URI);
        }

        public String getXMLParserClassName() {
            TranscodingHints.Key key = XMLAbstractTranscoder.KEY_XML_PARSER_CLASSNAME;
            if (PDFTranscoder.this.getTranscodingHints().containsKey(key)) {
                return (String)PDFTranscoder.this.getTranscodingHints().get(key);
            }
            return XMLResourceDescriptor.getXMLParserClassName();
        }

        public boolean isXMLParserValidating() {
            return false;
        }

        public AffineTransform getTransform() {
            return null;
        }
    }
}

