/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.svg;

import java.awt.Dimension;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import org.apache.avalon.framework.logger.Logger;
import org.apache.batik.bridge.UserAgentAdapter;
import org.apache.fop.apps.Driver;
import org.apache.fop.fo.FOUserAgent;

public class SVGUserAgent
extends UserAgentAdapter {
    private AffineTransform currentTransform = null;
    private Logger log;
    private FOUserAgent userAgent;

    public SVGUserAgent(FOUserAgent ua, AffineTransform at) {
        this.currentTransform = at;
        this.userAgent = ua;
        this.log = this.userAgent.getLogger();
    }

    public void displayError(String message) {
        this.log.error(message);
    }

    public void displayError(Exception ex) {
        this.log.error("SVG Error" + ex.getMessage(), (Throwable)ex);
    }

    public void displayMessage(String message) {
        this.log.info(message);
    }

    public void showAlert(String message) {
        this.log.warn(message);
    }

    public float getPixelUnitToMillimeter() {
        return this.userAgent.getPixelUnitToMillimeter();
    }

    public String getLanguages() {
        return "en";
    }

    public String getMedia() {
        return "print";
    }

    public String getUserStyleSheetURI() {
        return null;
    }

    public String getXMLParserClassName() {
        return Driver.getParserClassName();
    }

    public boolean isXMLParserValidating() {
        return false;
    }

    public AffineTransform getTransform() {
        return this.currentTransform;
    }

    public Dimension2D getViewportSize() {
        return new Dimension(100, 100);
    }
}

