/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.tools;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.ConsoleLogger;
import org.apache.avalon.framework.logger.Logger;
import org.apache.fop.apps.Driver;
import org.apache.fop.apps.FOInputHandler;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.InputHandler;
import org.apache.fop.apps.XSLTInputHandler;
import org.apache.fop.fo.FOUserAgent;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class TestConverter
extends AbstractLogEnabled {
    private boolean failOnly = false;
    private boolean outputPDF = false;
    private File destdir;
    private File compare = null;
    private String baseDir = "./";
    private Map differ = new HashMap();

    public static void main(String[] args) {
        if (args == null || args.length == 0) {
            System.out.println("test suite file name required");
        }
        TestConverter tc = new TestConverter();
        tc.enableLogging((Logger)new ConsoleLogger(3));
        String testFile = null;
        int count = 0;
        while (count < args.length) {
            if (args[count].equals("-failOnly")) {
                tc.setFailOnly(true);
            } else if (args[count].equals("-pdf")) {
                tc.setOutputPDF(true);
            } else if (args[count].equals("-b")) {
                tc.setBaseDir(args[count + 1]);
            } else {
                testFile = args[count];
            }
            ++count;
        }
        if (testFile == null) {
            System.out.println("test suite file name required");
        }
        tc.runTests(testFile, "results", null);
    }

    public void setOutputPDF(boolean pdf) {
        this.outputPDF = pdf;
    }

    public void setFailOnly(boolean fail) {
        this.failOnly = fail;
    }

    public void setBaseDir(String str) {
        this.baseDir = str;
    }

    public Map runTests(String fname, String dest, String compDir) {
        this.getLogger().debug("running tests in file:" + fname);
        try {
            if (compDir != null) {
                this.compare = new File(this.baseDir + "/" + compDir);
            }
            this.destdir = new File(this.baseDir + "/" + dest);
            this.destdir.mkdirs();
            File f = new File(this.baseDir + "/" + fname);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = factory.newDocumentBuilder();
            Document doc = db.parse(f);
            NodeList suitelist = doc.getChildNodes();
            if (suitelist.getLength() == 0) {
                return this.differ;
            }
            Element testsuite = null;
            testsuite = doc.getDocumentElement();
            if (testsuite.hasAttributes()) {
                String profile = testsuite.getAttributes().getNamedItem("profile").getNodeValue();
                this.getLogger().debug("testing test suite:" + profile);
            }
            NodeList testcases = testsuite.getChildNodes();
            int count = 0;
            while (count < testcases.getLength()) {
                Node testcase = testcases.item(count);
                if (testcase.getNodeName().equals("testcases")) {
                    this.runTestCase(testcase);
                }
                ++count;
            }
        }
        catch (Exception e) {
            this.getLogger().error("Error while running tests", (Throwable)e);
        }
        return this.differ;
    }

    protected void runTestCase(Node tcase) {
        if (tcase.hasAttributes()) {
            String profile = tcase.getAttributes().getNamedItem("profile").getNodeValue();
            this.getLogger().debug("testing profile:" + profile);
        }
        NodeList cases = tcase.getChildNodes();
        int count = 0;
        while (count < cases.getLength()) {
            Node node = cases.item(count);
            String nodename = node.getNodeName();
            if (nodename.equals("testcases")) {
                this.runTestCase(node);
            } else if (nodename.equals("test")) {
                this.runTest(tcase, node);
            } else if (nodename.equals("result")) {
                // empty if block
            }
            ++count;
        }
    }

    protected void runTest(Node testcase, Node test) {
        String id = test.getAttributes().getNamedItem("id").getNodeValue();
        Node result = this.locateResult(testcase, id);
        boolean pass = false;
        if (result != null) {
            String agreement = result.getAttributes().getNamedItem("agreement").getNodeValue();
            pass = agreement.equals("full");
        }
        if (pass && this.failOnly) {
            return;
        }
        String xml = test.getAttributes().getNamedItem("xml").getNodeValue();
        Node xslNode = test.getAttributes().getNamedItem("xsl");
        String xsl = null;
        if (xslNode != null) {
            xsl = xslNode.getNodeValue();
        }
        this.getLogger().debug("converting xml:" + xml + " and xsl:" + xsl + " to area tree");
        try {
            File f2;
            File f1;
            File xmlFile = new File(this.baseDir + "/" + xml);
            String baseURL = null;
            try {
                baseURL = xmlFile.getParentFile().toURL().toExternalForm();
            }
            catch (Exception e) {
                this.getLogger().error("Error setting base directory");
            }
            InputHandler inputHandler = null;
            inputHandler = xsl == null ? new FOInputHandler(xmlFile) : new XSLTInputHandler(xmlFile, new File(this.baseDir + "/" + xsl));
            XMLReader parser = inputHandler.getParser();
            this.setParserFeatures(parser);
            Driver driver = new Driver();
            this.setupLogger(driver, "fop");
            driver.initialize();
            FOUserAgent userAgent = new FOUserAgent();
            userAgent.setBaseURL(baseURL);
            driver.setUserAgent(userAgent);
            if (this.outputPDF) {
                driver.setRenderer(1);
            } else {
                driver.setRenderer(4);
            }
            HashMap<String, Boolean> rendererOptions = new HashMap<String, Boolean>();
            rendererOptions.put("fineDetail", new Boolean(false));
            rendererOptions.put("consistentOutput", new Boolean(true));
            driver.getRenderer().setOptions(rendererOptions);
            driver.getRenderer().setProducer("Testsuite Converter");
            String outname = xmlFile.getName();
            if (outname.endsWith(".xml")) {
                outname = outname.substring(0, outname.length() - 4);
            }
            driver.setOutputStream(new BufferedOutputStream(new FileOutputStream(new File(this.destdir, outname + (this.outputPDF ? ".pdf" : ".at.xml")))));
            this.getLogger().debug("ddir:" + this.destdir + " on:" + outname + ".pdf");
            driver.render(parser, inputHandler.getInputSource());
            if (this.compare != null && !this.compareFiles(f1 = new File(this.destdir, outname + ".at.xml"), f2 = new File(this.compare, outname + ".at.xml"))) {
                this.differ.put(outname + ".at.xml", new Boolean(pass));
            }
        }
        catch (Exception e) {
            this.getLogger().error("Error while running tests", (Throwable)e);
        }
    }

    protected boolean compareFiles(File f1, File f2) {
        if (f1.length() != f2.length()) {
            return false;
        }
        try {
            int ch2;
            int ch1;
            BufferedInputStream is1 = new BufferedInputStream(new FileInputStream(f1));
            BufferedInputStream is2 = new BufferedInputStream(new FileInputStream(f2));
            while ((ch1 = ((InputStream)is1).read()) == (ch2 = ((InputStream)is2).read())) {
                if (ch1 != -1) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            this.getLogger().error("Error while comparing files", (Throwable)e);
            return false;
        }
    }

    private void setParserFeatures(XMLReader parser) throws FOPException {
        try {
            parser.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        }
        catch (SAXException e) {
            throw new FOPException("Error in setting up parser feature namespace-prefixes\nYou need a parser which supports SAX version 2", e);
        }
    }

    private Node locateResult(Node testcase, String id) {
        NodeList cases = testcase.getChildNodes();
        int count = 0;
        while (count < cases.getLength()) {
            String resultid;
            Node node = cases.item(count);
            String nodename = node.getNodeName();
            if (nodename.equals("result") && id.equals(resultid = node.getAttributes().getNamedItem("id").getNodeValue())) {
                return node;
            }
            ++count;
        }
        return null;
    }
}

