/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.tools;

import java.awt.geom.Rectangle2D;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.fop.area.Area;
import org.apache.fop.area.AreaTree;
import org.apache.fop.area.AreaTreeModel;
import org.apache.fop.area.BeforeFloat;
import org.apache.fop.area.Block;
import org.apache.fop.area.BodyRegion;
import org.apache.fop.area.CTM;
import org.apache.fop.area.Flow;
import org.apache.fop.area.Footnote;
import org.apache.fop.area.LineArea;
import org.apache.fop.area.MainReference;
import org.apache.fop.area.Page;
import org.apache.fop.area.PageViewport;
import org.apache.fop.area.RegionReference;
import org.apache.fop.area.RegionViewport;
import org.apache.fop.area.Span;
import org.apache.fop.area.Title;
import org.apache.fop.area.Trait;
import org.apache.fop.area.inline.Character;
import org.apache.fop.area.inline.Container;
import org.apache.fop.area.inline.ForeignObject;
import org.apache.fop.area.inline.Image;
import org.apache.fop.area.inline.InlineArea;
import org.apache.fop.area.inline.Leader;
import org.apache.fop.area.inline.Space;
import org.apache.fop.area.inline.Viewport;
import org.apache.fop.area.inline.Word;
import org.apache.fop.fonts.FontMetrics;
import org.apache.fop.layout.FontInfo;
import org.apache.fop.layout.FontState;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class TreeLoader
extends AbstractLogEnabled {
    private AreaTree areaTree;
    private AreaTreeModel model;
    private FontInfo fontInfo;
    private FontState currentFontState;

    TreeLoader(FontInfo fi) {
        this.fontInfo = fi;
    }

    public void setTreeModel(AreaTreeModel mo) {
        this.model = mo;
    }

    public void buildAreaTree(InputStream is) {
        Document doc = null;
        try {
            DocumentBuilderFactory fact = DocumentBuilderFactory.newInstance();
            fact.setNamespaceAware(true);
            doc = fact.newDocumentBuilder().parse(is);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Element root = null;
        root = doc.getDocumentElement();
        this.areaTree = new AreaTree();
        this.areaTree.setTreeModel(this.model);
        this.readAreaTree(root);
    }

    public void readAreaTree(Element root) {
        NodeList childs = root.getChildNodes();
        int i = 0;
        while (i < childs.getLength()) {
            Node obj = childs.item(i);
            if (obj.getNodeName().equals("pageSequence")) {
                this.readPageSequence((Element)obj);
            }
            ++i;
        }
    }

    public void readPageSequence(Element root) {
        Title title = null;
        boolean started = false;
        NodeList childs = root.getChildNodes();
        int i = 0;
        while (i < childs.getLength()) {
            Node obj = childs.item(i);
            if (obj.getNodeName().equals("title")) {
                if (!started) {
                    title = this.readTitle((Element)obj);
                    this.model.startPageSequence(title);
                    started = true;
                }
            } else if (obj.getNodeName().equals("pageViewport")) {
                if (!started) {
                    this.model.startPageSequence(null);
                    started = true;
                }
                PageViewport viewport = this.readPageViewport((Element)obj);
                this.areaTree.addPage(viewport);
            }
            ++i;
        }
    }

    public Title readTitle(Element root) {
        Title title = new Title();
        List childs = this.getInlineAreas(root);
        int i = 0;
        while (i < childs.size()) {
            InlineArea obj = (InlineArea)childs.get(i);
            title.addInlineArea(obj);
            ++i;
        }
        return title;
    }

    public PageViewport readPageViewport(Element root) {
        Rectangle2D bounds = this.getRectangle(root, "bounds");
        PageViewport viewport = null;
        NodeList childs = root.getChildNodes();
        int i = 0;
        while (i < childs.getLength()) {
            Node obj = childs.item(i);
            if (obj.getNodeName().equals("page")) {
                Page page = this.readPage((Element)obj);
                viewport = new PageViewport(page, bounds);
            }
            ++i;
        }
        return viewport;
    }

    public Page readPage(Element root) {
        Page page = new Page();
        NodeList childs = root.getChildNodes();
        int i = 0;
        while (i < childs.getLength()) {
            Node obj = childs.item(i);
            if (obj.getNodeName().equals("regionViewport")) {
                this.readRegionViewport(page, (Element)obj);
            }
            ++i;
        }
        return page;
    }

    Rectangle2D getRectangle(Element root, String attr) {
        String tok;
        String rect = root.getAttribute(attr);
        StringTokenizer st = new StringTokenizer(rect, " ");
        int x = 0;
        int y = 0;
        int w = 0;
        int h = 0;
        if (st.hasMoreTokens()) {
            tok = st.nextToken();
            x = Integer.parseInt(tok);
        }
        if (st.hasMoreTokens()) {
            tok = st.nextToken();
            y = Integer.parseInt(tok);
        }
        if (st.hasMoreTokens()) {
            tok = st.nextToken();
            w = Integer.parseInt(tok);
        }
        if (st.hasMoreTokens()) {
            tok = st.nextToken();
            h = Integer.parseInt(tok);
        }
        Rectangle2D.Float r2d = new Rectangle2D.Float(x, y, w, h);
        return r2d;
    }

    public RegionViewport readRegionViewport(Page page, Element root) {
        RegionViewport reg = new RegionViewport(this.getRectangle(root, "rect"));
        NodeList childs = root.getChildNodes();
        int i = 0;
        while (i < childs.getLength()) {
            Node obj = childs.item(i);
            if (obj.getNodeName().equals("regionBefore")) {
                reg.setRegion(this.readRegion((Element)obj, 0));
                page.setRegion(0, reg);
            } else if (obj.getNodeName().equals("regionStart")) {
                reg.setRegion(this.readRegion((Element)obj, 1));
                page.setRegion(1, reg);
            } else if (obj.getNodeName().equals("regionBody")) {
                reg.setRegion(this.readRegion((Element)obj, 2));
                page.setRegion(2, reg);
            } else if (obj.getNodeName().equals("regionEnd")) {
                reg.setRegion(this.readRegion((Element)obj, 3));
                page.setRegion(3, reg);
            } else if (obj.getNodeName().equals("regionAfter")) {
                reg.setRegion(this.readRegion((Element)obj, 4));
                page.setRegion(4, reg);
            }
            ++i;
        }
        return reg;
    }

    public RegionReference readRegion(Element root, int type) {
        RegionReference reg;
        if (type == 2) {
            BodyRegion br = new BodyRegion();
            NodeList childs = root.getChildNodes();
            int i = 0;
            while (i < childs.getLength()) {
                Node obj = childs.item(i);
                if (obj.getNodeName().equals("beforeFloat")) {
                    BeforeFloat bf = this.readBeforeFloat((Element)obj);
                    br.setBeforeFloat(bf);
                } else if (obj.getNodeName().equals("mainReference")) {
                    MainReference mr = this.readMainReference((Element)obj);
                    br.setMainReference(mr);
                } else if (obj.getNodeName().equals("footnote")) {
                    Footnote foot = this.readFootnote((Element)obj);
                    br.setFootnote(foot);
                }
                ++i;
            }
            reg = br;
        } else {
            reg = new RegionReference(type);
            List blocks = this.getBlocks(root);
            int i = 0;
            while (i < blocks.size()) {
                Block obj = (Block)blocks.get(i);
                reg.addBlock(obj);
                ++i;
            }
        }
        reg.setCTM(new CTM());
        return reg;
    }

    public BeforeFloat readBeforeFloat(Element root) {
        BeforeFloat bf = new BeforeFloat();
        List blocks = this.getBlocks(root);
        int i = 0;
        while (i < blocks.size()) {
            Block obj = (Block)blocks.get(i);
            bf.addBlock(obj);
            ++i;
        }
        return bf;
    }

    public MainReference readMainReference(Element root) {
        MainReference mr = new MainReference();
        List spans = this.getSpans(root);
        int i = 0;
        while (i < spans.size()) {
            Span obj = (Span)spans.get(i);
            mr.addSpan(obj);
            ++i;
        }
        return mr;
    }

    List getSpans(Element root) {
        ArrayList<Span> list = new ArrayList<Span>();
        NodeList childs = root.getChildNodes();
        int i = 0;
        while (i < childs.getLength()) {
            Node obj = childs.item(i);
            if (obj.getNodeName().equals("span")) {
                List flows = this.getFlows((Element)obj);
                Span span = new Span(flows.size());
                int j = 0;
                while (j < flows.size()) {
                    Flow flow = (Flow)flows.get(j);
                    span.addFlow(flow);
                    ++j;
                }
                list.add(span);
            }
            ++i;
        }
        return list;
    }

    List getFlows(Element root) {
        ArrayList<Flow> list = new ArrayList<Flow>();
        NodeList childs = root.getChildNodes();
        int i = 0;
        while (i < childs.getLength()) {
            Node obj = childs.item(i);
            if (obj.getNodeName().equals("flow")) {
                Flow flow = new Flow();
                List blocks = this.getBlocks((Element)obj);
                int j = 0;
                while (j < blocks.size()) {
                    Block block = (Block)blocks.get(j);
                    flow.addBlock(block);
                    ++j;
                }
                list.add(flow);
            }
            ++i;
        }
        return list;
    }

    public Footnote readFootnote(Element root) {
        Footnote foot = new Footnote();
        List blocks = this.getBlocks(root);
        int i = 0;
        while (i < blocks.size()) {
            Block obj = (Block)blocks.get(i);
            foot.addBlock(obj);
            ++i;
        }
        return foot;
    }

    List getBlocks(Element root) {
        ArrayList<Block> list = new ArrayList<Block>();
        NodeList childs = root.getChildNodes();
        int i = 0;
        while (i < childs.getLength()) {
            Node obj = childs.item(i);
            if (obj.getNodeName().equals("block")) {
                Block block = new Block();
                this.addTraits((Element)obj, block);
                this.addBlockChildren(block, (Element)obj);
                list.add(block);
            }
            ++i;
        }
        return list;
    }

    protected void addBlockChildren(Block block, Element root) {
        NodeList childs = root.getChildNodes();
        int type = -1;
        int i = 0;
        while (i < childs.getLength()) {
            Node obj = childs.item(i);
            if (obj.getNodeName().equals("block")) {
                if (type == 2) {
                    // empty if block
                }
                Block b = new Block();
                this.addBlockChildren(b, (Element)obj);
                block.addBlock(b);
                type = 1;
            } else if (obj.getNodeName().equals("lineArea")) {
                if (type == 1) {
                    // empty if block
                }
                LineArea line = new LineArea();
                this.addTraits((Element)obj, line);
                String height = ((Element)obj).getAttribute("height");
                int h = Integer.parseInt(height);
                line.setHeight(h);
                List inlines = this.getInlineAreas((Element)obj);
                int j = 0;
                while (j < inlines.size()) {
                    InlineArea inline = (InlineArea)inlines.get(j);
                    line.addInlineArea(inline);
                    ++j;
                }
                block.addLineArea(line);
                type = 2;
            }
            ++i;
        }
    }

    List getInlineAreas(Element root) {
        ArrayList<InlineArea> list = new ArrayList<InlineArea>();
        NodeList childs = root.getChildNodes();
        int i = 0;
        while (i < childs.getLength()) {
            Node obj = childs.item(i);
            if (obj.getNodeName().equals("char")) {
                Character ch = new Character(this.getString((Element)obj).charAt(0));
                this.addTraits((Element)obj, ch);
                String fname = this.fontInfo.fontLookup("sans-serif", "normal", 400);
                FontMetrics metrics = this.fontInfo.getMetricsFor(fname);
                this.currentFontState = new FontState(fname, metrics, 12000);
                ch.setWidth(this.currentFontState.getWidth(ch.getChar()));
                ch.setOffset(this.currentFontState.getCapHeight());
                list.add(ch);
            } else if (obj.getNodeName().equals("space")) {
                Space space = new Space();
                String width = ((Element)obj).getAttribute("width");
                int w = Integer.parseInt(width);
                space.setWidth(w);
                list.add(space);
            } else if (obj.getNodeName().equals("viewport")) {
                Viewport viewport = this.getViewport((Element)obj);
                if (viewport != null) {
                    list.add(viewport);
                }
            } else if (obj.getNodeName().equals("leader")) {
                Leader leader = this.getLeader((Element)obj);
                if (leader != null) {
                    list.add(leader);
                }
            } else if (obj.getNodeName().equals("word")) {
                String fname = this.fontInfo.fontLookup("sans-serif", "normal", 400);
                FontMetrics metrics = this.fontInfo.getMetricsFor(fname);
                this.currentFontState = new FontState(fname, metrics, 12000);
                Word word = this.getWord((Element)obj);
                word.addTrait(Trait.FONT_NAME, fname);
                word.addTrait(Trait.FONT_SIZE, new Integer(12000));
                if (word != null) {
                    list.add(word);
                }
            }
            ++i;
        }
        return list;
    }

    Viewport getViewport(Element root) {
        Area child = null;
        NodeList childs = root.getChildNodes();
        int i = 0;
        while (i < childs.getLength()) {
            Node obj = childs.item(i);
            if (obj.getNodeName().equals("container")) {
                child = this.getContainer((Element)obj);
            } else if (obj.getNodeName().equals("foreignObject")) {
                child = this.getForeignObject((Element)obj);
            } else if (obj.getNodeName().equals("image")) {
                child = this.getImage((Element)obj);
            }
            ++i;
        }
        if (child == null) {
            return null;
        }
        Viewport viewport = new Viewport(child);
        String str = root.getAttribute("width");
        if (str != null && !"".equals(str)) {
            int width = Integer.parseInt(str);
            viewport.setWidth(width);
        }
        return viewport;
    }

    Container getContainer(Element root) {
        Container cont = new Container();
        List blocks = this.getBlocks(root);
        int i = 0;
        while (i < blocks.size()) {
            Block obj = (Block)blocks.get(i);
            cont.addBlock(obj);
            ++i;
        }
        return cont;
    }

    ForeignObject getForeignObject(Element root) {
        String svgNS = "http://www.w3.org/2000/svg";
        NodeList childs = root.getChildNodes();
        int i = 0;
        while (i < childs.getLength()) {
            Node obj = childs.item(i);
            if (obj instanceof Element) {
                DocumentBuilderFactory fact;
                Element rootEle = (Element)obj;
                String space = rootEle.getAttribute("xmlns");
                if (svgNS.equals(space)) {
                    try {
                        fact = DocumentBuilderFactory.newInstance();
                        fact.setNamespaceAware(true);
                        Document doc = fact.newDocumentBuilder().newDocument();
                        Node node = doc.importNode(obj, true);
                        doc.appendChild(node);
                        ForeignObject fo = new ForeignObject(doc, svgNS);
                        return fo;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    try {
                        fact = DocumentBuilderFactory.newInstance();
                        fact.setNamespaceAware(true);
                        Document doc = fact.newDocumentBuilder().newDocument();
                        Node node = doc.importNode(obj, true);
                        doc.appendChild(node);
                        ForeignObject fo = new ForeignObject(doc, space);
                        return fo;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            ++i;
        }
        return null;
    }

    Image getImage(Element root) {
        String url = root.getAttribute("url");
        Image image = new Image(url);
        return image;
    }

    Leader getLeader(Element root) {
        Leader leader = new Leader();
        String rs = root.getAttribute("ruleStyle");
        if ("solid".equals(rs)) {
            leader.setRuleStyle(85);
        } else if ("dotted".equals(rs)) {
            leader.setRuleStyle(21);
        } else if ("dashed".equals(rs)) {
            leader.setRuleStyle(17);
        } else if ("double".equals(rs)) {
            leader.setRuleStyle(22);
        } else if ("groove".equals(rs)) {
            leader.setRuleStyle(35);
        } else if ("ridge".equals(rs)) {
            leader.setRuleStyle(77);
        }
        String rt = root.getAttribute("ruleThickness");
        int thick = Integer.parseInt(rt);
        leader.setRuleThickness(thick);
        rt = root.getAttribute("width");
        if (rt != null && !"".equals(rt)) {
            thick = Integer.parseInt(rt);
            leader.setWidth(thick);
        }
        leader.setOffset(this.currentFontState.getCapHeight());
        this.addTraits(root, leader);
        return leader;
    }

    Word getWord(Element root) {
        String str = this.getString(root);
        Word word = new Word();
        word.setWord(str);
        this.addTraits(root, word);
        int width = 0;
        int count = 0;
        while (count < str.length()) {
            width += this.currentFontState.getWidth(str.charAt(count));
            ++count;
        }
        word.setWidth(width);
        word.setOffset(this.currentFontState.getCapHeight());
        return word;
    }

    public void addTraits(Element ele, Area area) {
        String str = ele.getAttribute("props");
        StringTokenizer st = new StringTokenizer(str, ";");
        while (st.hasMoreTokens()) {
            int index;
            String tok = st.nextToken();
            String id = tok.substring(0, index = tok.indexOf(":"));
            Object traitCode = Trait.getTraitCode(id);
            if (traitCode != null) {
                area.addTrait(traitCode, Trait.makeTraitValue(traitCode, tok.substring(index + 1)));
                continue;
            }
            this.getLogger().error("Unknown trait: " + id);
        }
    }

    public List getRanges(Element ele) {
        ArrayList list = new ArrayList();
        String str = ele.getAttribute("ranges");
        StringTokenizer st = new StringTokenizer(str, ";");
        while (st.hasMoreTokens()) {
            st.nextToken();
        }
        return list;
    }

    public String getString(Element ele) {
        String str = "";
        NodeList childs = ele.getChildNodes();
        if (childs.getLength() == 0) {
            return null;
        }
        int i = 0;
        while (i < childs.getLength()) {
            Node obj = childs.item(i);
            str = str + obj.getNodeValue();
            ++i;
        }
        return str;
    }
}

