/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.common.socket;

import com.n2bb.LogModule.N2BB_LogClient;
import java.net.SocketAddress;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

class ConnectionMap {
    private static final String myclass = "ConnectionMap";
    protected Map connectionMap = null;
    protected Map channelMap = null;

    public ConnectionMap() {
        this.connectionMap = new HashMap(1000);
        this.channelMap = new HashMap(1000);
    }

    public ConnectionMap(int initSize) {
        this.connectionMap = new HashMap(initSize);
        this.channelMap = new HashMap(initSize);
    }

    public void put(SocketAddress address, SocketChannel channel) {
        String mymethod = "put";
        ConnectionMapBucket bucket = null;
        this.channelMap.put(channel, address);
        bucket = this.getBucket(address);
        if (bucket == null) {
            bucket = new ConnectionMapBucket();
            this.connectionMap.put(address, bucket);
        }
        bucket.addChannel(channel);
    }

    public ConnectionMapBucket getBucket(SocketAddress address) {
        String mymethod = "getBucket";
        ConnectionMapBucket retval = (ConnectionMapBucket)this.connectionMap.get(address);
        return retval;
    }

    public SocketAddress get(SocketChannel channel) {
        return (SocketAddress)this.channelMap.get(channel);
    }

    public List get(SocketAddress address) {
        ConnectionMapBucket bucket = null;
        bucket = this.getBucket(address);
        if (bucket == null) {
            return null;
        }
        return bucket.getChannels();
    }

    public void remove(SocketAddress address) {
        String mymethod = "remove";
        ConnectionMapBucket bucket = null;
        bucket = (ConnectionMapBucket)this.connectionMap.remove(address);
        if (bucket == null) {
            N2BB_LogClient.instance().error(myclass, "remove", "ConnectionMapBucket is null for " + address);
            return;
        }
        List connectionList = bucket.getChannels();
        if (connectionList != null) {
            for (int i = 0; i < connectionList.size(); ++i) {
                SocketChannel channel = (SocketChannel)connectionList.get(i);
                this.channelMap.remove(channel);
            }
        }
    }

    public void remove(SocketChannel channel) {
        String mymethod = "remove";
        SocketAddress address = null;
        ConnectionMapBucket bucket = null;
        address = (SocketAddress)this.channelMap.remove(channel);
        if (address != null) {
            bucket = (ConnectionMapBucket)this.connectionMap.get(address);
        }
        if (bucket != null) {
            bucket.removeChannel(channel);
            if (bucket.getChannels().size() == 0) {
                N2BB_LogClient.instance().critical(myclass, "remove", "Last connection to " + address + " removed, removing list from connectionMap");
                this.connectionMap.remove(address);
            }
        }
    }

    public Set keySet() {
        return this.connectionMap.keySet();
    }

    public void lock(SocketAddress address) {
        ConnectionMapBucket bucket = null;
        bucket = (ConnectionMapBucket)this.connectionMap.get(address);
        if (bucket != null) {
            bucket.lock();
        }
    }

    public ConnectionMapBucket createAndLock(SocketAddress address) {
        ConnectionMapBucket bucket = (ConnectionMapBucket)this.connectionMap.get(address);
        if (bucket == null) {
            bucket = new ConnectionMapBucket();
            this.connectionMap.put(address, bucket);
        }
        bucket.lock();
        return bucket;
    }

    public void unlock(SocketAddress address) {
        ConnectionMapBucket bucket = (ConnectionMapBucket)this.connectionMap.get(address);
        if (bucket != null) {
            bucket.unlock();
        }
    }

    public void unlockAndRemove(SocketAddress address) {
        ConnectionMapBucket bucket = (ConnectionMapBucket)this.connectionMap.remove(address);
        if (bucket != null) {
            bucket.unlock();
        }
    }

    class ConnectionMapBucket {
        boolean inUse = false;
        List channels = null;

        ConnectionMapBucket() {
        }

        public synchronized void lock() {
            this.inUse = true;
        }

        public synchronized void unlock() {
            this.inUse = false;
            this.notifyAll();
        }

        public synchronized void addChannel(SocketChannel channel) {
            if (this.channels == null) {
                this.channels = new LinkedList();
            }
            this.channels.add(channel);
        }

        public synchronized List getChannels() {
            String mymethod = "getChannels";
            try {
                while (this.inUse) {
                    this.wait();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return this.channels;
        }

        public synchronized void removeChannel(SocketChannel channel) {
            try {
                while (this.inUse) {
                    this.wait();
                }
            }
            catch (Exception ignore) {
                // empty catch block
            }
            if (this.channels != null) {
                ListIterator li = this.channels.listIterator();
                while (li.hasNext()) {
                    SocketChannel curr = (SocketChannel)li.next();
                    if (!curr.equals(channel)) continue;
                    li.remove();
                    break;
                }
            }
        }
    }
}

