/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.corba.orb;

import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextExtHelper;
import org.omg.CosNaming.NamingContextHelper;
import org.omg.CosNaming.NamingContextPackage.AlreadyBound;
import org.omg.CosNaming.NamingContextPackage.CannotProceed;
import org.omg.CosNaming.NamingContextPackage.InvalidName;
import org.omg.CosNaming.NamingContextPackage.NotFound;
import org.omg.PortableServer.IdAssignmentPolicyValue;
import org.omg.PortableServer.IdUniquenessPolicyValue;
import org.omg.PortableServer.ImplicitActivationPolicyValue;
import org.omg.PortableServer.LifespanPolicyValue;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.POAManagerPackage.AdapterInactive;
import org.omg.PortableServer.POAPackage.AdapterAlreadyExists;
import org.omg.PortableServer.POAPackage.InvalidPolicy;
import org.omg.PortableServer.POAPackage.WrongPolicy;
import org.omg.PortableServer.RequestProcessingPolicyValue;
import org.omg.PortableServer.ServantLocator;
import org.omg.PortableServer.ServantLocatorPOA;
import org.omg.PortableServer.ServantManager;
import org.omg.PortableServer.ServantRetentionPolicyValue;

public class OrbManager {
    private ORB m_orb = null;
    private POA rootPOA = null;
    private NamingContextExt m_nameCtxExt = null;
    protected static OrbManager m_orbMgr = null;
    protected static final String DEFAULTNAMESERVICE = "corbaloc::NameServer:5000/NameService";

    protected OrbManager(ORB orb) throws org.omg.CORBA.ORBPackage.InvalidName {
        this.m_orb = orb;
        try {
            this.rootPOA = POAHelper.narrow((Object)orb.resolve_initial_references("RootPOA"));
            this.rootPOA.the_POAManager().activate();
        }
        catch (Exception exc) {
            // empty catch block
        }
        if (this.m_orb != null) {
            try {
                Object ns = this.m_orb.resolve_initial_references("NameService");
                this.m_nameCtxExt = NamingContextExtHelper.narrow((Object)ns);
            }
            catch (org.omg.CORBA.ORBPackage.InvalidName in) {
                try {
                    Object ns = this.m_orb.string_to_object(DEFAULTNAMESERVICE);
                    this.m_nameCtxExt = NamingContextExtHelper.narrow((Object)ns);
                }
                catch (Exception exc) {
                    throw in;
                }
            }
        }
    }

    public static OrbManager init(ORB orb) throws org.omg.CORBA.ORBPackage.InvalidName {
        if (m_orbMgr != null) {
            m_orbMgr.destroyORB();
        }
        m_orbMgr = new OrbManager(orb);
        return OrbManager.getInstance();
    }

    public static OrbManager getInstance() {
        return m_orbMgr;
    }

    public static void destroy() {
        if (m_orbMgr != null) {
            m_orbMgr.destroyORB();
        }
    }

    protected void destroyORB() {
        if (this.m_orb != null) {
            this.m_orb.destroy();
        }
    }

    public ORB getORB() {
        return this.m_orb;
    }

    public POA getRootPOA() {
        return this.rootPOA;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public POA createPOA(POA parentPOA, String poaName, ServantLocatorPOA servantLocator) throws AdapterAlreadyExists, WrongPolicy, AdapterInactive, InvalidPolicy, AdapterInactive {
        POA poa = null;
        Policy[] policies = null;
        try {
            if (servantLocator != null) {
                policies = new Policy[]{parentPOA.create_id_assignment_policy(IdAssignmentPolicyValue.USER_ID), parentPOA.create_implicit_activation_policy(ImplicitActivationPolicyValue.NO_IMPLICIT_ACTIVATION), parentPOA.create_lifespan_policy(LifespanPolicyValue.PERSISTENT), parentPOA.create_servant_retention_policy(ServantRetentionPolicyValue.NON_RETAIN), parentPOA.create_request_processing_policy(RequestProcessingPolicyValue.USE_SERVANT_MANAGER), parentPOA.create_id_uniqueness_policy(IdUniquenessPolicyValue.UNIQUE_ID)};
                poa = parentPOA.create_POA(poaName, parentPOA.the_POAManager(), policies);
                ServantLocator locator = servantLocator._this();
                poa.set_servant_manager((ServantManager)locator);
                poa.the_POAManager().activate();
            } else {
                policies = new Policy[]{parentPOA.create_id_assignment_policy(IdAssignmentPolicyValue.USER_ID), parentPOA.create_implicit_activation_policy(ImplicitActivationPolicyValue.NO_IMPLICIT_ACTIVATION), parentPOA.create_lifespan_policy(LifespanPolicyValue.PERSISTENT)};
                poa = parentPOA.create_POA(poaName, parentPOA.the_POAManager(), policies);
                poa.the_POAManager().activate();
            }
        }
        finally {
            for (int i = 0; i < policies.length; ++i) {
                policies[i].destroy();
            }
        }
        return poa;
    }

    public NamingContextExt getRootNamingContextExt() {
        return this.m_nameCtxExt;
    }

    public synchronized void bindObject(NameComponent[] nc, Object object) throws CannotProceed, InvalidName {
        NameComponent[] currentName = new NameComponent[1];
        NamingContextExt currentContext = this.m_nameCtxExt;
        for (int i = 0; i < nc.length - 1; ++i) {
            currentName[0] = nc[i];
            try {
                Object nextContext = currentContext.resolve(currentName);
                currentContext = NamingContextHelper.narrow((Object)nextContext);
                continue;
            }
            catch (NotFound nf) {
                try {
                    currentContext = currentContext.bind_new_context(currentName);
                    continue;
                }
                catch (NotFound nf2) {
                    continue;
                }
                catch (AlreadyBound ab) {
                    // empty catch block
                }
            }
        }
        currentName[0] = nc[nc.length - 1];
        try {
            currentContext.rebind(currentName, object);
        }
        catch (NotFound nf) {
            // empty catch block
        }
    }

    public Object resolveObject(NameComponent[] nc) throws NotFound, CannotProceed, InvalidName {
        Object obj = this.m_nameCtxExt.resolve(nc);
        return obj;
    }

    public void deleteObjectBinding(NameComponent[] nc) throws NotFound, CannotProceed, InvalidName {
        this.m_nameCtxExt.unbind(nc);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public NamingContextExt getNamingContext() {
        Object namingObj = null;
        NamingContextExt ctx = null;
        try {
            namingObj = this.m_orb.resolve_initial_references("NameService");
        }
        catch (Exception e) {
            // empty catch block
        }
        if (namingObj == null) {
            // empty if block
        }
        try {
            ctx = NamingContextExtHelper.narrow((Object)namingObj);
            if (ctx != null) return ctx;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ctx;
    }

    public NamingContextExt createNamingContext(String[] fullPath) {
        return this.createNamingContext(fullPath, fullPath.length - 1);
    }

    private NamingContextExt createNamingContext(String[] fullPath, int len) {
        NamingContextExt ctx = this.getNamingContext();
        Object namingCtx = null;
        try {
            NameComponent[] nameComponents = new NameComponent[len];
            for (int i = 0; i < len; ++i) {
                nameComponents[i] = new NameComponent(fullPath[i], "Context");
            }
            try {
                namingCtx = ctx.resolve(nameComponents);
            }
            catch (NotFound ex) {
                try {
                    ctx.bind_new_context(nameComponents);
                    namingCtx = ctx.resolve(nameComponents);
                }
                catch (AlreadyBound already) {
                    namingCtx = ctx.resolve(nameComponents);
                }
                catch (Exception exp) {}
            }
            catch (Exception ex) {
                // empty catch block
            }
            return NamingContextExtHelper.narrow((Object)namingCtx);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public Object getFactoryObject(String[] fullPath) throws Exception {
        NamingContextExt ctx = this.createNamingContext(fullPath);
        try {
            NameComponent[] nameComponents = OrbManager.getFactoryNameComponents(fullPath);
            return ctx.resolve(nameComponents);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static NameComponent[] getFactoryNameComponents(String[] fullPath) {
        return new NameComponent[]{new NameComponent(fullPath[fullPath.length - 1], "Factory")};
    }

    public void bindFactoryObject(String[] fullPath, Object obj) {
        NamingContextExt ctx = this.createNamingContext(fullPath);
        try {
            NameComponent[] nameComponents = OrbManager.getFactoryNameComponents(fullPath);
            ctx.rebind(nameComponents, obj);
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    public void unbindFactoryObject(String[] fullPath) {
        NamingContextExt ctx = this.createNamingContext(fullPath);
        try {
            NameComponent[] nameComponents = OrbManager.getFactoryNameComponents(fullPath);
            ctx.unbind(nameComponents);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

