/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.apache.avalon.framework.logger.Logger;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.portable.Delegate;
import org.omg.CORBA.portable.ObjectImpl;
import org.openorb.util.ORBUtils;
import org.openorb.util.ReflectionUtils;

public abstract class NamingUtils {
    public static final String IR_ROOT_POA = "RootPOA";
    public static final String IR_POA_CURRENT = "POACurrent";
    public static final String IR_INTERFACE_REPOSITORY = "InterfaceRepository";
    public static final String IR_NAME_SERVICE = "NameService";
    public static final String IR_TRADING_SERVICE = "TradingService";
    public static final String IR_SECURITY_CURRENT = "SecurityCurrent";
    public static final String IR_TRANSACTION_CURRENT = "TransactionCurrent";
    public static final String IR_DYN_ANY_FACTORY = "DynAnyFactory";
    public static final String IR_ORB_POLICY_MANAGER = "ORBPolicyManager";
    public static final String IR_POLICY_CURRENT = "PolicyCurrent";
    public static final String IR_NOTIFICATION_SERVICE = "NotificationService";
    public static final String IR_TYPED_NOTIFICATION_SERVICE = "TypedNotificationService";
    public static final String IR_CODEC_FACTORY = "CodecFactory";
    public static final String IR_PI_CURRENT = "PICurrent";
    public static final String IR_COMPONENT_HOME_FINDER = "ComponentHomeFinder";
    public static final String IR_PSS = "PSS";
    public static final String IR_CCS = "ConcurrencyControlService";
    public static final String IR_OTS = "TransactionService";
    public static final String IR_EVENT_SERVICE = "EventService";
    public static final String IR_PROPERTY_SERVICE = "PropertyService";
    public static final String IR_SERVICE_TYPE_REPOSITORY = "ServiceTypeRepository";
    public static final String IR_TIME_SERVICE = "TimeService";
    private static final String NS_IOR_DIRNAME = "NS_IOR";
    public static final String ROOT_COS_CONTEXT = "COS";
    public static final String NS_NAME = "ns";
    public static final String NS_NAME_LONG = "NameService";
    public static final String NAMING_CONTEXT_NAME = "NamingContextExt";
    public static final String NAMING_CONTEXT_NAME_NS = "COS/NameService/NamingContextExt";
    public static final String CALLBACK_MANAGER_NAME = "CallbackManager";
    public static final String CALLBACK_MANAGER_NAME_NS = "COS/NameService/CallbackManager";
    public static final String CCS_NAME = "ccs";
    public static final String CCS_NAME_LONG = "ConcurrencyControlService";
    public static final String LOCK_SET_FACTORY_NAME = "LockSetFactory";
    public static final String LOCK_SET_FACTORY_NAME_NS = "COS/ConcurrencyControlService/LockSetFactory";
    public static final String EVENT_SERVICE_NAME = "event";
    public static final String EVENT_SERVICE_NAME_LONG = "EventService";
    public static final String EVENT_CHANNEL_FACTORY_NAME = "EventChannelFactory";
    public static final String EVENT_CHANNEL_FACTORY_NAME_NS = "COS/EventService/EventChannelFactory";
    public static final String DEFAULT_EVENT_CHANNEL_NAME = "DefaultEventChannel";
    public static final String DEFAULT_EVENT_CHANNEL_NAME_NS = "COS/EventService/DefaultEventChannel";
    public static final String NOTIFICATION_SERVICE_NAME = "notify";
    public static final String NOTIFICATION_SERVICE_NAME_LONG = "NotificationService";
    public static final String NOTIFICATION_CHANNEL_FACTORY_NAME = "EventChannelFactory";
    public static final String NOTIFICATION_CHANNEL_FACTORY_NAME_NS = "COS/NotificationService/EventChannelFactory";
    public static final String PSS_SERVICE_NAME = "pss";
    public static final String PSS_SERVICE_NAME_LONG = "PersistentStateService";
    public static final String PSS_CONNECTOR_FACTORY_NAME = "ConnectorFactory";
    public static final String PSS_CONNECTOR_FACTORY_NAME_NS = "COS/PersistentStateService/ConnectorFactory";
    public static final String PROPERTY_SERVICE_NAME = "property";
    public static final String PROPERTY_SERVICE_NAME_LONG = "PropertyService";
    public static final String PROPERTY_SET_FACTORY_NAME = "PropertySetFactory";
    public static final String PROPERTY_SET_FACTORY_NAME_NS = "COS/PropertyService/PropertySetFactory";
    public static final String PROPERTY_SET_DEF_FACTORY_NAME = "PropertySetDefaultFactory";
    public static final String PROPERTY_SET_DEF_FACTORY_NAME_NS = "COS/PropertyService/PropertySetDefaultFactory";
    public static final String TIME_SERVICE_NAME = "time";
    public static final String TIME_SERVICE_NAME_LONG = "TimeService";
    public static final String TIME_SERVICE_NAME_NS = "COS/TimeService/TimeService";
    public static final String TIMER_EVENT_SERVICE_NAME = "TimerEventService";
    public static final String TIMER_EVENT_SERVICE_NAME_NS = "COS/TimeService/TimerEventService";
    public static final String TRADING_SERVICE_NAME = "trader";
    public static final String TRADING_SERVICE_NAME_LONG = "TradingService";
    public static final String TRADING_KERNEL_NAME = "Kernel";
    public static final String TRADING_KERNEL_NAME_NS = "COS/TradingService/Kernel";
    public static final String TRADING_SVC_TYPE_REPO_NAME = "ServiceTypeRepository";
    public static final String TRADING_SVC_TYPE_REPO_NAME_NS = "COS/TradingService/ServiceTypeRepository";
    public static final String OTS_NAME = "ots";
    public static final String OTS_NAME_LONG = "TransactionService";
    public static final String TRANSACTION_FACTORY_NAME = "TransactionFactory";
    public static final String TRANSACTION_FACTORY_NAME_NS = "COS/TransactionService/TransactionFactory";
    public static final String IR_NAME = "ir";
    public static final String IR_NAME_LONG = "InterfaceRepository";
    public static final String REPOSITORY_NAME = "Repository";
    public static final String REPOSITORY_NAME_NS = "COS/InterfaceRepository/Repository";
    private static final java.lang.Object SYNC_MAP = new java.lang.Object();
    private static final HashMap RIR_MAP = new HashMap();
    static /* synthetic */ Class class$org$omg$CORBA$Object;
    static /* synthetic */ Class class$java$lang$String;

    private NamingUtils() {
    }

    public static String rirMapping(String rirName) {
        java.lang.Object object = SYNC_MAP;
        synchronized (object) {
            if (RIR_MAP.isEmpty()) {
                RIR_MAP.put("NameService", NAMING_CONTEXT_NAME_NS);
                RIR_MAP.put("InterfaceRepository", REPOSITORY_NAME_NS);
                RIR_MAP.put("NotificationService", NOTIFICATION_CHANNEL_FACTORY_NAME_NS);
                RIR_MAP.put("TradingService", TRADING_KERNEL_NAME_NS);
                RIR_MAP.put(IR_PSS, PSS_CONNECTOR_FACTORY_NAME_NS);
                RIR_MAP.put("ConcurrencyControlService", LOCK_SET_FACTORY_NAME_NS);
                RIR_MAP.put("EventService", EVENT_CHANNEL_FACTORY_NAME_NS);
                RIR_MAP.put("TransactionService", TRANSACTION_FACTORY_NAME_NS);
                RIR_MAP.put("PropertyService", PROPERTY_SET_FACTORY_NAME_NS);
                RIR_MAP.put("ServiceTypeRepository", TRADING_SVC_TYPE_REPO_NAME_NS);
                RIR_MAP.put("TimeService", TIME_SERVICE_NAME_NS);
            }
        }
        return (String)RIR_MAP.get(rirName);
    }

    public static String encodeRFC2396(String str) throws UnsupportedEncodingException {
        StringBuffer sb = new StringBuffer();
        int start = 0;
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9')) {
                switch (c) {
                    case '!': 
                    case '$': 
                    case '&': 
                    case '\'': 
                    case '(': 
                    case ')': 
                    case '*': 
                    case '+': 
                    case ',': 
                    case '-': 
                    case '.': 
                    case '/': 
                    case ':': 
                    case ';': 
                    case '=': 
                    case '?': 
                    case '@': 
                    case '_': 
                    case '~': {
                        break;
                    }
                    default: {
                        sb.append(str.substring(start, i));
                        byte[] tmp = str.substring(i, i + 1).getBytes("UTF-8");
                        int j = 0;
                        while (j < tmp.length) {
                            sb.append('%');
                            if ((tmp[j] & 0xF0) < 160) {
                                sb.append((tmp[j] & 0xF0) >> 4);
                            } else {
                                sb.append((char)(65 + ((tmp[j] & 0x50) >> 4)));
                            }
                            if ((tmp[j] & 0xF) < 10) {
                                sb.append(tmp[j] & 0xF);
                            } else {
                                sb.append((char)(65 + (tmp[j] & 5)));
                            }
                            ++j;
                        }
                        start = i + 1;
                    }
                }
            }
            ++i;
        }
        sb.append(str.substring(start));
        return sb.toString();
    }

    public static String decodeRFC2396(String enc) throws UnsupportedEncodingException {
        StringBuffer sb = new StringBuffer();
        int start = 0;
        int i = 0;
        while (i < enc.length()) {
            if (sb.charAt(i) == '%') {
                sb.append(enc.substring(start, i));
                int count = 1;
                while (sb.charAt(i + 2 * count) == '%') {
                    ++count;
                }
                byte[] buf = new byte[count];
                int j = 0;
                while (j < count) {
                    buf[i] = Byte.parseByte(enc.substring(i + 2 * j + 1, i + 2 * j + 2), 16);
                    ++j;
                }
                sb.append(new String(buf, "UTF-16"));
                i += count * 3 - 1;
            }
            ++i;
        }
        sb.append(enc.substring(start));
        return sb.toString();
    }

    public static boolean checkAddress(String addr) {
        int start;
        int end = addr.length();
        do {
            String strHost;
            int host;
            int proto;
            if ((start = addr.lastIndexOf(",", end)) < 0) {
                start = 0;
            }
            if ((proto = addr.indexOf(":", start)) < 0 || proto > end) {
                return false;
            }
            String strProtocol = addr.substring(start + 1, proto);
            if (strProtocol != null && strProtocol.length() > 0 && !strProtocol.equals("iiop")) {
                return false;
            }
            int vers = addr.indexOf("@", proto);
            if (vers > 0 && vers < end) {
                int min;
                int maj;
                int major = addr.indexOf(".", proto);
                if (major < 0 || major > vers) {
                    return false;
                }
                try {
                    maj = Integer.parseInt(addr.substring(proto + 1, major));
                    min = Integer.parseInt(addr.substring(major + 1, vers));
                }
                catch (NumberFormatException ex) {
                    return false;
                }
                if (maj != 1) {
                    return false;
                }
                if (min < 0 || min > 2) {
                    return false;
                }
            } else {
                vers = proto;
            }
            if ((host = addr.indexOf(":", vers + 1)) > 0 && host < end) {
                int iPort;
                try {
                    iPort = Integer.parseInt(addr.substring(host + 1, end));
                }
                catch (NumberFormatException ex) {
                    return false;
                }
                if (iPort < 0 || iPort > 65535) {
                    return false;
                }
            } else {
                host = end;
            }
            if ((strHost = addr.substring(vers + 1, host)) == null || strHost.length() == 0) {
                return false;
            }
            end = start;
        } while (start > 0);
        return true;
    }

    public static java.lang.Object dynamicStringToName(String name) throws Exception {
        StringTokenizer st = new StringTokenizer(name, "/");
        Class<?> ncomp_clz = Thread.currentThread().getContextClassLoader().loadClass("org.omg.CosNaming.NameComponent");
        Field ncomp_id_fld = ncomp_clz.getDeclaredField("id");
        Field ncomp_kind_fld = ncomp_clz.getDeclaredField("kind");
        java.lang.Object ncomp_arr = Array.newInstance(ncomp_clz, st.countTokens());
        int i = 0;
        while (st.hasMoreTokens()) {
            java.lang.Object ncomp_obj = ncomp_clz.newInstance();
            String id = "";
            String kind = "";
            String token = st.nextToken();
            int idx = token.indexOf(46);
            if (idx > 0) {
                id = token.substring(0, idx);
                kind = token.substring(idx + 1);
            } else {
                id = token;
            }
            ncomp_id_fld.set(ncomp_obj, id);
            ncomp_kind_fld.set(ncomp_obj, kind);
            Array.set(ncomp_arr, i++, ncomp_obj);
        }
        return ncomp_arr;
    }

    public static boolean dynamicRebind(ORB orb, String name, Object obj) {
        boolean result;
        block8: {
            result = false;
            try {
                Object namingobj = orb.resolve_initial_references("NameService");
                Class<?> nc_clz = Thread.currentThread().getContextClassLoader().loadClass("org.omg.CosNaming.NamingContext");
                Class<?> ncstub_clz = Thread.currentThread().getContextClassLoader().loadClass("org.omg.CosNaming._NamingContextStub");
                if (namingobj == null || !namingobj.getClass().isAssignableFrom(nc_clz) && !namingobj._is_a("IDL:omg.org/CosNaming/NamingContext:1.0")) break block8;
                java.lang.Object ncstub_obj = ReflectionUtils.getStubInstance(ncstub_clz, namingobj);
                java.lang.Object ncomp_arr = NamingUtils.dynamicStringToName(name);
                StringTokenizer st = new StringTokenizer(name, "/");
                String par_ctx = null;
                boolean bExOccured = false;
                while (st.hasMoreTokens()) {
                    String tok = st.nextToken();
                    par_ctx = par_ctx == null ? tok : par_ctx + "/" + tok;
                    if (!st.hasMoreTokens()) continue;
                    java.lang.Object par_nam = NamingUtils.dynamicStringToName(par_ctx);
                    Method bind_new_context = ncstub_obj.getClass().getMethod("bind_new_context", par_nam.getClass());
                    try {
                        bind_new_context.invoke(ncstub_obj, par_nam);
                    }
                    catch (Exception ex) {
                        Class already_bound_clz = null;
                        try {
                            Thread.currentThread().getContextClassLoader().loadClass("org.omg.CosNaming.NamingContextPackage.AlreadyBound");
                        }
                        catch (Exception notfound) {
                            // empty catch block
                        }
                        if (already_bound_clz == null || already_bound_clz.isAssignableFrom(ex.getClass())) continue;
                        bExOccured = true;
                    }
                }
                if (!bExOccured) {
                    Class[] paramTypes = new Class[]{ncomp_arr.getClass(), class$org$omg$CORBA$Object == null ? (class$org$omg$CORBA$Object = NamingUtils.class$("org.omg.CORBA.Object")) : class$org$omg$CORBA$Object};
                    java.lang.Object[] paramObjects = new java.lang.Object[]{ncomp_arr, obj};
                    Method rebind = ncstub_obj.getClass().getDeclaredMethod("rebind", paramTypes);
                    rebind.invoke(ncstub_obj, paramObjects);
                    result = true;
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return result;
    }

    public static Object dynamicResolve(ORB orb, String name) {
        Object result = null;
        try {
            Object namingobj = orb.resolve_initial_references("NameService");
            Class<?> nc_clz = Thread.currentThread().getContextClassLoader().loadClass("org.omg.CosNaming.NamingContext");
            Class<?> ncstub_clz = Thread.currentThread().getContextClassLoader().loadClass("org.omg.CosNaming._NamingContextStub");
            if (namingobj != null && (namingobj.getClass().isAssignableFrom(nc_clz) || namingobj._is_a("IDL:omg.org/CosNaming/NamingContext:1.0"))) {
                java.lang.Object ncstub_obj = ReflectionUtils.getStubInstance(ncstub_clz, namingobj);
                java.lang.Object ncomp_arr = NamingUtils.dynamicStringToName(name);
                Class[] paramTypes = new Class[]{ncomp_arr.getClass()};
                java.lang.Object[] paramObjects = new java.lang.Object[]{ncomp_arr};
                Method resolve = ncstub_obj.getClass().getDeclaredMethod("resolve", paramTypes);
                result = (Object)resolve.invoke(ncstub_obj, paramObjects);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static boolean dynamicUnbind(ORB orb, String name) {
        boolean result = false;
        try {
            Object namingobj = orb.resolve_initial_references("NameService");
            Class<?> nc_clz = Thread.currentThread().getContextClassLoader().loadClass("org.omg.CosNaming.NamingContext");
            Class<?> ncstub_clz = Thread.currentThread().getContextClassLoader().loadClass("org.omg.CosNaming._NamingContextStub");
            if (namingobj != null && (namingobj.getClass().isAssignableFrom(nc_clz) || namingobj._is_a("IDL:omg.org/CosNaming/NamingContext:1.0"))) {
                java.lang.Object ncstub_obj = ReflectionUtils.getStubInstance(ncstub_clz, namingobj);
                java.lang.Object ncomp_arr = NamingUtils.dynamicStringToName(name);
                Class[] paramTypes = new Class[]{ncomp_arr.getClass()};
                java.lang.Object[] paramObjects = new java.lang.Object[]{ncomp_arr};
                Method resolve = ncstub_obj.getClass().getDeclaredMethod("unbind", paramTypes);
                resolve.invoke(ncstub_obj, paramObjects);
                result = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static String bindObjectToCorbalocService(ORB orb, String name, Object obj) {
        String result;
        block8: {
            result = null;
            try {
                Object clsobj = orb.resolve_initial_references("CorbalocService");
                Class<?> cls_clz = Thread.currentThread().getContextClassLoader().loadClass("org.openorb.orb.corbaloc.CorbalocService");
                Class<?> clsstub_clz = Thread.currentThread().getContextClassLoader().loadClass("org.openorb.orb.corbaloc._CorbalocServiceStub");
                if (clsobj == null || !clsobj.getClass().isAssignableFrom(cls_clz) && !clsobj._is_a("IDL:orb.openorb.org/corbaloc/CorbalocService:1.1")) break block8;
                java.lang.Object clsstub_obj = ReflectionUtils.getStubInstance(clsstub_clz, clsobj);
                Method put = clsstub_obj.getClass().getMethod("put", class$java$lang$String == null ? (class$java$lang$String = NamingUtils.class$("java.lang.String")) : class$java$lang$String, class$org$omg$CORBA$Object == null ? (class$org$omg$CORBA$Object = NamingUtils.class$("org.omg.CORBA.Object")) : class$org$omg$CORBA$Object);
                Delegate deleg = ((ObjectImpl)clsobj)._get_delegate();
                try {
                    put.invoke(clsstub_obj, name, obj);
                    Class<?> orgOpenorbOrbNetAddressClz = Thread.currentThread().getContextClassLoader().loadClass("org.openorb.orb.net.Address");
                    Class<?> orgOpenorbOrbCoreDelegateClz = Thread.currentThread().getContextClassLoader().loadClass("org.openorb.orb.core.Delegate");
                    Method getAddresses = orgOpenorbOrbCoreDelegateClz.getMethod("getAddresses", class$org$omg$CORBA$Object == null ? (class$org$omg$CORBA$Object = NamingUtils.class$("org.omg.CORBA.Object")) : class$org$omg$CORBA$Object);
                    Method getProtocol = orgOpenorbOrbNetAddressClz.getMethod("getProtocol", new Class[0]);
                    Method getEndpointString = orgOpenorbOrbNetAddressClz.getMethod("getEndpointString", new Class[0]);
                    java.lang.Object addrs = getAddresses.invoke((java.lang.Object)deleg, obj);
                    String endpoint = null;
                    if (addrs != null) {
                        int len = Array.getLength(addrs);
                        int i = 0;
                        while (i < len) {
                            java.lang.Object addr = Array.get(addrs, i);
                            String prot = (String)getProtocol.invoke(addr, new java.lang.Object[0]);
                            if (prot.equals("iiop")) {
                                endpoint = (String)getEndpointString.invoke(addr, new java.lang.Object[0]);
                            }
                            ++i;
                        }
                        if (endpoint == null) {
                            endpoint = (String)getEndpointString.invoke(Array.get(addrs, 0), new java.lang.Object[0]);
                        }
                        result = "corbaloc:" + endpoint + "/" + name;
                    }
                }
                catch (Exception ex) {}
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return result;
    }

    public static boolean bindObjectToNamingService(ORB orb, String name, Object obj, Logger logger) {
        return NamingUtils.bindObjectToNamingService(orb, name, obj, false, logger);
    }

    public static boolean bindObjectToNamingService(ORB orb, String name, Object obj, boolean bNoNS, Logger logger) {
        boolean bSuccess = false;
        if (!bNoNS) {
            if (logger != null && logger.isDebugEnabled()) {
                logger.debug("Trying to bind: '" + name + "' to NamingService");
            }
            if (!(bSuccess = NamingUtils.dynamicRebind(orb, name, obj))) {
                logger.warn("Failed to bind '" + name + "' to the NamingService." + " Check whether your NamingService is running!");
            }
        }
        if (!bSuccess) {
            if (logger != null && logger.isDebugEnabled()) {
                logger.debug("Using fallback strategy for binding: '" + name + "'");
            }
            if (!(bSuccess = NamingUtils.bindObjectToFileSystem(orb, name, obj)) && logger != null) {
                logger.warn("Failed to bind '" + name + "' IOR to the File System.");
            }
        }
        return bSuccess;
    }

    public static boolean bindObjectToFileSystem(ORB orb, String name, Object obj) {
        boolean bSuccess = false;
        try {
            File fNSDir = NamingUtils.getNSRootDir();
            String strIOR = orb.object_to_string(obj);
            File fIOR = new File(fNSDir, name + ".ior");
            File fIORPath = new File(fIOR.getParent());
            bSuccess = fIORPath.mkdirs();
            bSuccess = fIOR.createNewFile();
            FileWriter fwIOR = new FileWriter(fIOR);
            fwIOR.write(strIOR);
            fwIOR.close();
            bSuccess = true;
        }
        catch (IOException ex) {
            // empty catch block
        }
        return bSuccess;
    }

    public static Object resolveObjectFromNamingService(ORB orb, String name) {
        return NamingUtils.resolveObjectFromNamingService(orb, name, false);
    }

    public static Object resolveObjectFromNamingService(ORB orb, String name, boolean bNoNS) {
        return NamingUtils.resolveObjectFromNamingService(orb, name, bNoNS, null);
    }

    public static Object resolveObjectFromNamingService(ORB orb, String name, boolean bNoNS, Logger logger) {
        Object result;
        block5: {
            result = null;
            if (!bNoNS) {
                result = NamingUtils.dynamicResolve(orb, name);
            }
            if (result == null) {
                try {
                    File fNSDir = NamingUtils.getNSRootDir();
                    File fIOR = new File(fNSDir, name + ".ior");
                    if (logger != null && logger.isDebugEnabled()) {
                        logger.debug("Reference file is " + fNSDir + "/" + name + ".ior");
                    }
                    FileReader frIOR = new FileReader(fIOR);
                    BufferedReader brIOR = new BufferedReader(frIOR);
                    String strIOR = brIOR.readLine();
                    brIOR.close();
                    frIOR.close();
                    result = orb.string_to_object(strIOR);
                }
                catch (IOException ex) {
                    if (logger == null || !logger.isDebugEnabled()) break block5;
                    logger.debug("Reference file not found " + name);
                }
            }
        }
        return result;
    }

    public static boolean unbindObjectFromNamingService(ORB orb, String name) {
        return NamingUtils.unbindObjectFromNamingService(orb, name, false);
    }

    public static boolean unbindObjectFromNamingService(ORB orb, String name, boolean bNoNS) {
        boolean bSuccess = false;
        if (!bNoNS) {
            bSuccess = NamingUtils.dynamicUnbind(orb, name);
        }
        if (!bSuccess) {
            try {
                File fNSDir = NamingUtils.getNSRootDir();
                File fIOR = new File(fNSDir, name + ".ior");
                bSuccess = fIOR.delete();
            }
            catch (IOException ex) {
                bSuccess = false;
            }
        }
        return bSuccess;
    }

    private static File getNSRootDir() throws IOException {
        return ORBUtils.getTemporaryDir(null, NS_IOR_DIRNAME);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

