/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;

public class URLLoader
extends ClassLoader {
    private URL[] m_urls;

    public URLLoader(URL[] urls) {
        this.m_urls = urls;
    }

    public URL[] getURLs() {
        return this.m_urls;
    }

    protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c = null;
        c = this.findLoadedClass(name);
        if (c == null) {
            try {
                c = this.findSystemClass(name);
            }
            catch (ClassNotFoundException ex) {
                // empty catch block
            }
        }
        if (c == null) {
            c = this.findClass(name);
        }
        if (c == null) {
            c = Thread.currentThread().getContextClassLoader().loadClass(name);
        }
        if (resolve && c != null) {
            this.resolveClass(c);
        }
        if (c == null) {
            throw new ClassNotFoundException();
        }
        return c;
    }

    protected Class findClass(String name) {
        byte[] b = null;
        int i = 0;
        while (i < this.m_urls.length) {
            try {
                b = this.extractClassFromURL(new URL(this.m_urls[i], name));
                if (b != null) {
                    break;
                }
            }
            catch (MalformedURLException ex) {
                // empty catch block
            }
            ++i;
        }
        if (b == null) {
            return null;
        }
        return this.defineClass(name, b, 0, b.length);
    }

    private byte[] extractClassFromURL(URL url) {
        try {
            URLConnection conn = url.openConnection();
            byte[] buf = new byte[conn.getContentLength()];
            BufferedInputStream is = new BufferedInputStream(url.openStream());
            int i = 0;
            while (i < buf.length) {
                i += is.read(buf, i, buf.length - 1);
            }
            is.close();
            return buf;
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

