/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.util.logger;

import org.apache.avalon.framework.logger.Logger;
import org.openorb.util.logger.LoggerTeam;
import org.openorb.util.logger.NullLoggerTeam;
import org.openorb.util.logger.PrefixingLogger;

public abstract class AbstractLoggerTeam
implements LoggerTeam,
LoggerTeam.StandardTags {
    protected static final LoggerTeam NULL_LOGGER = NullLoggerTeam.getInstance();
    private final Logger m_mainLogger;

    protected AbstractLoggerTeam(Logger mainLogger) {
        this.m_mainLogger = null == mainLogger ? NULL_LOGGER : mainLogger;
    }

    protected boolean isNullLogger() {
        return this.m_mainLogger.equals(NULL_LOGGER);
    }

    protected final Logger createPrefixingLogger(Logger logger) {
        return NULL_LOGGER.equals(logger) ? NULL_LOGGER : new PrefixingLogger(logger);
    }

    public Logger getMember(Object tag) {
        return LoggerTeam.StandardTags.MAIN_LOGGER_TAG.equals(tag) ? this.m_mainLogger : NULL_LOGGER;
    }

    public final Logger getChildLogger(String name) {
        return this.createChildLoggerTeam(name);
    }

    public final void debug(String message) {
        this.m_mainLogger.debug(message);
    }

    public final void debug(String message, Throwable throwable) {
        this.m_mainLogger.debug(message, throwable);
    }

    public final boolean isDebugEnabled() {
        return this.m_mainLogger.isDebugEnabled();
    }

    public final void info(String message) {
        this.m_mainLogger.info(message);
    }

    public final void info(String message, Throwable throwable) {
        this.m_mainLogger.info(message, throwable);
    }

    public final boolean isInfoEnabled() {
        return this.m_mainLogger.isInfoEnabled();
    }

    public final void warn(String message) {
        this.m_mainLogger.warn(message);
    }

    public final void warn(String message, Throwable throwable) {
        this.m_mainLogger.warn(message, throwable);
    }

    public final boolean isWarnEnabled() {
        return this.m_mainLogger.isWarnEnabled();
    }

    public final void error(String message) {
        this.m_mainLogger.error(message);
    }

    public final void error(String message, Throwable throwable) {
        this.m_mainLogger.error(message, throwable);
    }

    public final boolean isErrorEnabled() {
        return this.m_mainLogger.isErrorEnabled();
    }

    public final void fatalError(String message) {
        this.m_mainLogger.fatalError(message);
    }

    public final void fatalError(String message, Throwable throwable) {
        this.m_mainLogger.fatalError(message, throwable);
    }

    public final boolean isFatalErrorEnabled() {
        return this.m_mainLogger.isFatalErrorEnabled();
    }

    public abstract LoggerTeam createPrefixingLoggerTeam();

    public abstract LoggerTeam createChildLoggerTeam(String var1);
}

