/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.util.logger;

import org.apache.avalon.framework.logger.Logger;

public final class ControllableLogger
implements Logger {
    private final Logger m_logger;
    private final Control m_control;

    public ControllableLogger(Logger logger, Control control) {
        this.m_logger = logger;
        this.m_control = control;
    }

    public Logger getChildLogger(String name) {
        return new ControllableLogger(this.m_logger.getChildLogger(name), this.m_control);
    }

    public void debug(String message) {
        if (this.isDebugEnabled()) {
            this.m_logger.debug(message);
        }
    }

    public void debug(String message, Throwable throwable) {
        if (this.isDebugEnabled()) {
            this.m_logger.debug(message, throwable);
        }
    }

    public boolean isDebugEnabled() {
        return this.m_control.isDebugEnabled();
    }

    public void info(String message) {
        if (this.isInfoEnabled()) {
            this.m_logger.info(message);
        }
    }

    public void info(String message, Throwable throwable) {
        if (this.isInfoEnabled()) {
            this.m_logger.info(message, throwable);
        }
    }

    public boolean isInfoEnabled() {
        return this.m_control.isInfoEnabled();
    }

    public void warn(String message) {
        if (this.isWarnEnabled()) {
            this.m_logger.warn(message);
        }
    }

    public void warn(String message, Throwable throwable) {
        if (this.isWarnEnabled()) {
            this.m_logger.warn(message, throwable);
        }
    }

    public boolean isWarnEnabled() {
        return this.m_control.isWarnEnabled();
    }

    public void error(String message) {
        if (this.isErrorEnabled()) {
            this.m_logger.error(message);
        }
    }

    public void error(String message, Throwable throwable) {
        if (this.isErrorEnabled()) {
            this.m_logger.error(message, throwable);
        }
    }

    public boolean isErrorEnabled() {
        return this.m_control.isErrorEnabled();
    }

    public void fatalError(String message) {
        if (this.isFatalErrorEnabled()) {
            this.m_logger.fatalError(message);
        }
    }

    public void fatalError(String message, Throwable throwable) {
        if (this.isFatalErrorEnabled()) {
            this.m_logger.fatalError(message, throwable);
        }
    }

    public boolean isFatalErrorEnabled() {
        return this.m_control.isFatalErrorEnabled();
    }

    public static interface Control {
        public boolean isDebugEnabled();

        public boolean isInfoEnabled();

        public boolean isWarnEnabled();

        public boolean isErrorEnabled();

        public boolean isFatalErrorEnabled();
    }
}

