/*
 * Decompiled with CFR 0.152.
 */
package org.nanocontainer.remoting.jmx;

import java.util.HashSet;
import java.util.Set;
import javax.management.DynamicMBean;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.nanocontainer.remoting.jmx.DynamicMBeanComponentProvider;
import org.nanocontainer.remoting.jmx.DynamicMBeanProvider;
import org.nanocontainer.remoting.jmx.JMXRegistrationException;
import org.nanocontainer.remoting.jmx.JMXRegistrationInfo;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.PicoContainer;
import org.picocontainer.defaults.TraversalCheckingVisitor;

public class JMXVisitor
extends TraversalCheckingVisitor {
    private final DynamicMBeanProvider[] mBeanProviders;
    private final MBeanServer mBeanServer;
    private final Set visited;
    private final Set registeredInfo;
    private PicoContainer picoContainer;

    public JMXVisitor(MBeanServer mBeanServer) {
        this(mBeanServer, new DynamicMBeanProvider[]{new DynamicMBeanComponentProvider()});
    }

    public JMXVisitor(MBeanServer mBeanServer, DynamicMBeanProvider[] dynamicMBeanProviderArray) {
        if (mBeanServer == null) {
            throw new NullPointerException("MBeanServer may not be null");
        }
        if (dynamicMBeanProviderArray == null) {
            throw new NullPointerException("DynamicMBeanProvider[] may not be null");
        }
        if (dynamicMBeanProviderArray.length == 0) {
            throw new IllegalArgumentException("DynamicMBeanProvider[] may not be empty");
        }
        this.mBeanServer = mBeanServer;
        this.mBeanProviders = dynamicMBeanProviderArray;
        this.visited = new HashSet();
        this.registeredInfo = new HashSet();
    }

    public Object traverse(Object object) {
        super.traverse(object);
        this.picoContainer = null;
        HashSet hashSet = new HashSet(this.registeredInfo);
        this.registeredInfo.clear();
        return hashSet;
    }

    public void visitContainer(PicoContainer picoContainer) {
        super.visitContainer(picoContainer);
        this.picoContainer = picoContainer;
        this.visited.clear();
    }

    public void visitComponentAdapter(ComponentAdapter componentAdapter) {
        super.visitComponentAdapter(componentAdapter);
        if (this.picoContainer == null) {
            throw new JMXRegistrationException("Cannot start JMXVisitor traversal with a ComponentAdapter");
        }
        if (!this.visited.contains(componentAdapter.getComponentKey())) {
            this.visited.add(componentAdapter.getComponentKey());
            for (int i = 0; i < this.mBeanProviders.length; ++i) {
                DynamicMBeanProvider dynamicMBeanProvider = this.mBeanProviders[i];
                JMXRegistrationInfo jMXRegistrationInfo = dynamicMBeanProvider.provide(this.picoContainer, componentAdapter);
                if (jMXRegistrationInfo == null) continue;
                this.registeredInfo.add(this.register(jMXRegistrationInfo.getMBean(), jMXRegistrationInfo.getObjectName()));
                break;
            }
        }
    }

    protected ObjectInstance register(DynamicMBean dynamicMBean, ObjectName objectName) throws JMXRegistrationException {
        try {
            return this.mBeanServer.registerMBean(dynamicMBean, objectName);
        }
        catch (JMException jMException) {
            throw new JMXRegistrationException("Unable to register MBean to MBean Server", jMException);
        }
    }
}

