/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.defaults;

import org.picocontainer.ComponentAdapter;
import org.picocontainer.LifecycleManager;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoInitializationException;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.defaults.AssignabilityRegistrationException;
import org.picocontainer.defaults.DecoratingComponentAdapter;
import org.picocontainer.defaults.LifecycleStrategy;
import org.picocontainer.defaults.NotConcreteRegistrationException;
import org.picocontainer.defaults.ObjectReference;
import org.picocontainer.defaults.SimpleReference;

public class CachingComponentAdapter
extends DecoratingComponentAdapter
implements LifecycleManager {
    private ObjectReference instanceReference;
    private boolean disposed;
    private boolean started;
    private boolean delegateHasLifecylce;

    public CachingComponentAdapter(ComponentAdapter componentAdapter) {
        this(componentAdapter, new SimpleReference());
    }

    public CachingComponentAdapter(ComponentAdapter componentAdapter, ObjectReference objectReference) {
        super(componentAdapter);
        this.instanceReference = objectReference;
        this.disposed = false;
        this.started = false;
        this.delegateHasLifecylce = componentAdapter instanceof LifecycleStrategy && ((LifecycleStrategy)((Object)componentAdapter)).hasLifecycle(componentAdapter.getComponentImplementation());
    }

    public Object getComponentInstance(PicoContainer picoContainer) throws PicoInitializationException, PicoIntrospectionException, AssignabilityRegistrationException, NotConcreteRegistrationException {
        Object object = this.instanceReference.get();
        if (object == null) {
            object = super.getComponentInstance(picoContainer);
            this.instanceReference.set(object);
        }
        return object;
    }

    public void flush() {
        Object object = this.instanceReference.get();
        if (object != null && this.delegateHasLifecylce && this.started) {
            this.stop(object);
            this.dispose(object);
        }
        this.instanceReference.set(null);
    }

    public void start(PicoContainer picoContainer) {
        if (this.delegateHasLifecylce) {
            if (this.disposed) {
                throw new IllegalStateException("Already disposed");
            }
            if (this.started) {
                throw new IllegalStateException("Already started");
            }
            this.start(this.getComponentInstance(picoContainer));
            this.started = true;
        }
    }

    public void stop(PicoContainer picoContainer) {
        if (this.delegateHasLifecylce) {
            if (this.disposed) {
                throw new IllegalStateException("Already disposed");
            }
            if (!this.started) {
                throw new IllegalStateException("Not started");
            }
            this.stop(this.getComponentInstance(picoContainer));
            this.started = false;
        }
    }

    public void dispose(PicoContainer picoContainer) {
        if (this.delegateHasLifecylce) {
            if (this.disposed) {
                throw new IllegalStateException("Already disposed");
            }
            this.dispose(this.getComponentInstance(picoContainer));
            this.disposed = true;
        }
    }

    public boolean hasLifecycle() {
        return this.delegateHasLifecylce;
    }
}

