/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.defaults;

import java.io.Serializable;
import java.lang.reflect.Field;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.Parameter;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoException;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.PicoVisitor;

public class ConstantParameter
implements Parameter,
Serializable {
    private final Object value;

    public ConstantParameter(Object object) {
        this.value = object;
    }

    public Object resolveInstance(PicoContainer picoContainer, ComponentAdapter componentAdapter, Class clazz) {
        return this.value;
    }

    public boolean isResolvable(PicoContainer picoContainer, ComponentAdapter componentAdapter, Class clazz) {
        try {
            this.verify(picoContainer, componentAdapter, clazz);
            return true;
        }
        catch (PicoIntrospectionException picoIntrospectionException) {
            return false;
        }
    }

    public void verify(PicoContainer picoContainer, ComponentAdapter componentAdapter, Class clazz) throws PicoException {
        if (!this.checkPrimitive(clazz) && !clazz.isInstance(this.value)) {
            throw new PicoIntrospectionException(clazz.getClass().getName() + " is not assignable from " + this.value.getClass().getName());
        }
    }

    public void accept(PicoVisitor picoVisitor) {
        picoVisitor.visitParameter(this);
    }

    private boolean checkPrimitive(Class clazz) {
        try {
            if (clazz.isPrimitive()) {
                Field field = this.value.getClass().getField("TYPE");
                Class clazz2 = (Class)field.get(this.value);
                return clazz.isAssignableFrom(clazz2);
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return false;
    }
}

