/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.defaults;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.ComponentMonitor;
import org.picocontainer.LifecycleManager;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.Parameter;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoException;
import org.picocontainer.PicoInitializationException;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.PicoVerificationException;
import org.picocontainer.PicoVisitor;
import org.picocontainer.defaults.AmbiguousComponentResolutionException;
import org.picocontainer.defaults.ComponentAdapterFactory;
import org.picocontainer.defaults.ComponentMonitorStrategy;
import org.picocontainer.defaults.DefaultComponentAdapterFactory;
import org.picocontainer.defaults.DefaultLifecycleStrategy;
import org.picocontainer.defaults.DuplicateComponentKeyRegistrationException;
import org.picocontainer.defaults.ImmutablePicoContainerProxyFactory;
import org.picocontainer.defaults.InstanceComponentAdapter;
import org.picocontainer.defaults.LifecycleStrategy;
import org.picocontainer.defaults.VerifyingVisitor;
import org.picocontainer.monitors.DefaultComponentMonitor;

public class DefaultPicoContainer
implements MutablePicoContainer,
ComponentMonitorStrategy,
Serializable {
    private Map componentKeyToAdapterCache = new HashMap();
    private ComponentAdapterFactory componentAdapterFactory;
    private PicoContainer parent;
    private Set children = new HashSet();
    private List componentAdapters = new ArrayList();
    private List orderedComponentAdapters = new ArrayList();
    private boolean started = false;
    private boolean disposed = false;
    private Set childrenStarted = new HashSet();
    private LifecycleManager lifecycleManager = new OrderedComponentAdapterLifecycleManager();
    private LifecycleStrategy lifecycleStrategyForInstanceRegistrations;
    static /* synthetic */ Class class$java$lang$Object;

    public DefaultPicoContainer(ComponentAdapterFactory componentAdapterFactory, PicoContainer picoContainer) {
        this(componentAdapterFactory, (LifecycleStrategy)new DefaultLifecycleStrategy(new DefaultComponentMonitor()), picoContainer);
    }

    public DefaultPicoContainer(ComponentAdapterFactory componentAdapterFactory, LifecycleStrategy lifecycleStrategy, PicoContainer picoContainer) {
        if (componentAdapterFactory == null) {
            throw new NullPointerException("componentAdapterFactory");
        }
        if (lifecycleStrategy == null) {
            throw new NullPointerException("lifecycleStrategyForInstanceRegistrations");
        }
        this.componentAdapterFactory = componentAdapterFactory;
        this.lifecycleStrategyForInstanceRegistrations = lifecycleStrategy;
        this.parent = picoContainer == null ? null : ImmutablePicoContainerProxyFactory.newProxyInstance(picoContainer);
    }

    public DefaultPicoContainer(ComponentMonitor componentMonitor, PicoContainer picoContainer) {
        this(new DefaultComponentAdapterFactory(componentMonitor), picoContainer);
        this.lifecycleStrategyForInstanceRegistrations = new DefaultLifecycleStrategy(componentMonitor);
    }

    public DefaultPicoContainer(ComponentMonitor componentMonitor, LifecycleStrategy lifecycleStrategy, PicoContainer picoContainer) {
        this(new DefaultComponentAdapterFactory(componentMonitor, lifecycleStrategy), lifecycleStrategy, picoContainer);
    }

    public DefaultPicoContainer(LifecycleStrategy lifecycleStrategy, PicoContainer picoContainer) {
        this(new DefaultComponentMonitor(), lifecycleStrategy, picoContainer);
    }

    public DefaultPicoContainer(ComponentAdapterFactory componentAdapterFactory) {
        this(componentAdapterFactory, null);
    }

    public DefaultPicoContainer(ComponentMonitor componentMonitor) {
        this(componentMonitor, (LifecycleStrategy)new DefaultLifecycleStrategy(componentMonitor), null);
    }

    public DefaultPicoContainer(PicoContainer picoContainer) {
        this(new DefaultComponentAdapterFactory(), picoContainer);
    }

    public DefaultPicoContainer() {
        this(new DefaultComponentAdapterFactory(), null);
    }

    public Collection getComponentAdapters() {
        return Collections.unmodifiableList(this.componentAdapters);
    }

    public final ComponentAdapter getComponentAdapter(Object object) {
        ComponentAdapter componentAdapter = (ComponentAdapter)this.componentKeyToAdapterCache.get(object);
        if (componentAdapter == null && this.parent != null) {
            componentAdapter = this.parent.getComponentAdapter(object);
        }
        return componentAdapter;
    }

    public ComponentAdapter getComponentAdapterOfType(Class clazz) {
        ComponentAdapter componentAdapter = this.getComponentAdapter(clazz);
        if (componentAdapter != null) {
            return componentAdapter;
        }
        List list = this.getComponentAdaptersOfType(clazz);
        if (list.size() == 1) {
            return (ComponentAdapter)list.get(0);
        }
        if (list.size() == 0) {
            if (this.parent != null) {
                return this.parent.getComponentAdapterOfType(clazz);
            }
            return null;
        }
        Object[] objectArray = new Class[list.size()];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = ((ComponentAdapter)list.get(i)).getComponentImplementation();
        }
        throw new AmbiguousComponentResolutionException(clazz, objectArray);
    }

    public List getComponentAdaptersOfType(Class clazz) {
        if (clazz == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<ComponentAdapter> arrayList = new ArrayList<ComponentAdapter>();
        Iterator iterator = this.getComponentAdapters().iterator();
        while (iterator.hasNext()) {
            ComponentAdapter componentAdapter = (ComponentAdapter)iterator.next();
            if (!clazz.isAssignableFrom(componentAdapter.getComponentImplementation())) continue;
            arrayList.add(componentAdapter);
        }
        return arrayList;
    }

    public ComponentAdapter registerComponent(ComponentAdapter componentAdapter) {
        Object object = componentAdapter.getComponentKey();
        if (this.componentKeyToAdapterCache.containsKey(object)) {
            throw new DuplicateComponentKeyRegistrationException(object);
        }
        this.componentAdapters.add(componentAdapter);
        this.componentKeyToAdapterCache.put(object, componentAdapter);
        return componentAdapter;
    }

    public ComponentAdapter unregisterComponent(Object object) {
        ComponentAdapter componentAdapter = (ComponentAdapter)this.componentKeyToAdapterCache.remove(object);
        this.componentAdapters.remove(componentAdapter);
        this.orderedComponentAdapters.remove(componentAdapter);
        return componentAdapter;
    }

    public ComponentAdapter registerComponentInstance(Object object) {
        return this.registerComponentInstance(object.getClass(), object);
    }

    public ComponentAdapter registerComponentInstance(Object object, Object object2) {
        InstanceComponentAdapter instanceComponentAdapter = new InstanceComponentAdapter(object, object2, this.lifecycleStrategyForInstanceRegistrations);
        return this.registerComponent(instanceComponentAdapter);
    }

    public ComponentAdapter registerComponentImplementation(Class clazz) {
        return this.registerComponentImplementation(clazz, clazz);
    }

    public ComponentAdapter registerComponentImplementation(Object object, Class clazz) {
        return this.registerComponentImplementation(object, clazz, (Parameter[])null);
    }

    public ComponentAdapter registerComponentImplementation(Object object, Class clazz, Parameter[] parameterArray) {
        ComponentAdapter componentAdapter = this.componentAdapterFactory.createComponentAdapter(object, clazz, parameterArray);
        return this.registerComponent(componentAdapter);
    }

    public ComponentAdapter registerComponentImplementation(Object object, Class clazz, List list) {
        Parameter[] parameterArray = list.toArray(new Parameter[list.size()]);
        return this.registerComponentImplementation(object, clazz, parameterArray);
    }

    private void addOrderedComponentAdapter(ComponentAdapter componentAdapter) {
        if (!this.orderedComponentAdapters.contains(componentAdapter)) {
            this.orderedComponentAdapters.add(componentAdapter);
        }
    }

    public List getComponentInstances() throws PicoException {
        return this.getComponentInstancesOfType(class$java$lang$Object == null ? (class$java$lang$Object = DefaultPicoContainer.class$("java.lang.Object")) : class$java$lang$Object);
    }

    public List getComponentInstancesOfType(Class clazz) {
        Object object;
        Object object2;
        if (clazz == null) {
            return Collections.EMPTY_LIST;
        }
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        Object object3 = this.componentAdapters.iterator();
        while (object3.hasNext()) {
            object2 = (ComponentAdapter)object3.next();
            if (!clazz.isAssignableFrom(object2.getComponentImplementation())) continue;
            object = this.getInstance((ComponentAdapter)object2);
            hashMap.put(object2, object);
            this.addOrderedComponentAdapter((ComponentAdapter)object2);
        }
        object3 = new ArrayList();
        object2 = this.orderedComponentAdapters.iterator();
        while (object2.hasNext()) {
            object = object2.next();
            Object v = hashMap.get(object);
            if (v == null) continue;
            object3.add(v);
        }
        return object3;
    }

    public Object getComponentInstance(Object object) {
        ComponentAdapter componentAdapter = this.getComponentAdapter(object);
        if (componentAdapter != null) {
            return this.getInstance(componentAdapter);
        }
        return null;
    }

    public Object getComponentInstanceOfType(Class clazz) {
        ComponentAdapter componentAdapter = this.getComponentAdapterOfType(clazz);
        return componentAdapter == null ? null : this.getInstance(componentAdapter);
    }

    private Object getInstance(ComponentAdapter componentAdapter) {
        boolean bl = this.componentAdapters.contains(componentAdapter);
        if (bl) {
            PicoException picoException = null;
            Object object = null;
            try {
                object = componentAdapter.getComponentInstance(this);
            }
            catch (PicoInitializationException picoInitializationException) {
                picoException = picoInitializationException;
            }
            catch (PicoIntrospectionException picoIntrospectionException) {
                picoException = picoIntrospectionException;
            }
            if (picoException != null) {
                if (this.parent != null && (object = this.parent.getComponentInstance(componentAdapter.getComponentKey())) != null) {
                    return object;
                }
                throw picoException;
            }
            this.addOrderedComponentAdapter(componentAdapter);
            return object;
        }
        if (this.parent != null) {
            return this.parent.getComponentInstance(componentAdapter.getComponentKey());
        }
        return null;
    }

    public PicoContainer getParent() {
        return this.parent;
    }

    public ComponentAdapter unregisterComponentByInstance(Object object) {
        Collection collection = this.getComponentAdapters();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ComponentAdapter componentAdapter = (ComponentAdapter)iterator.next();
            if (!this.getInstance(componentAdapter).equals(object)) continue;
            return this.unregisterComponent(componentAdapter.getComponentKey());
        }
        return null;
    }

    public void verify() throws PicoVerificationException {
        new VerifyingVisitor().traverse(this);
    }

    public void start() {
        if (this.disposed) {
            throw new IllegalStateException("Already disposed");
        }
        if (this.started) {
            throw new IllegalStateException("Already started");
        }
        this.started = true;
        this.lifecycleManager.start(this);
        this.childrenStarted.clear();
        Iterator iterator = this.children.iterator();
        while (iterator.hasNext()) {
            PicoContainer picoContainer = (PicoContainer)iterator.next();
            this.childrenStarted.add(new Integer(picoContainer.hashCode()));
            picoContainer.start();
        }
    }

    public void stop() {
        if (this.disposed) {
            throw new IllegalStateException("Already disposed");
        }
        if (!this.started) {
            throw new IllegalStateException("Not started");
        }
        Iterator iterator = this.children.iterator();
        while (iterator.hasNext()) {
            PicoContainer picoContainer = (PicoContainer)iterator.next();
            if (!this.childStarted(picoContainer)) continue;
            picoContainer.stop();
        }
        this.lifecycleManager.stop(this);
        this.started = false;
    }

    private boolean childStarted(PicoContainer picoContainer) {
        return this.childrenStarted.contains(new Integer(picoContainer.hashCode()));
    }

    public void dispose() {
        if (this.disposed) {
            throw new IllegalStateException("Already disposed");
        }
        Iterator iterator = this.children.iterator();
        while (iterator.hasNext()) {
            PicoContainer picoContainer = (PicoContainer)iterator.next();
            picoContainer.dispose();
        }
        this.lifecycleManager.dispose(this);
        this.disposed = true;
    }

    public MutablePicoContainer makeChildContainer() {
        DefaultPicoContainer defaultPicoContainer = new DefaultPicoContainer(this.componentAdapterFactory, this.lifecycleStrategyForInstanceRegistrations, (PicoContainer)this);
        this.addChildContainer(defaultPicoContainer);
        return defaultPicoContainer;
    }

    public boolean addChildContainer(PicoContainer picoContainer) {
        if (this.children.add(picoContainer)) {
            if (this.started) {
                this.childrenStarted.add(new Integer(picoContainer.hashCode()));
            }
            return true;
        }
        return false;
    }

    public boolean removeChildContainer(PicoContainer picoContainer) {
        boolean bl = this.children.remove(picoContainer);
        return bl;
    }

    public void accept(PicoVisitor picoVisitor) {
        Object object;
        picoVisitor.visitContainer(this);
        ArrayList arrayList = new ArrayList(this.getComponentAdapters());
        Object object2 = arrayList.iterator();
        while (object2.hasNext()) {
            object = (ComponentAdapter)object2.next();
            object.accept(picoVisitor);
        }
        object2 = new ArrayList(this.children);
        object = object2.iterator();
        while (object.hasNext()) {
            PicoContainer picoContainer = (PicoContainer)object.next();
            picoContainer.accept(picoVisitor);
        }
    }

    public void changeMonitor(ComponentMonitor componentMonitor) {
        Object e;
        if (this.componentAdapterFactory instanceof ComponentMonitorStrategy) {
            ((ComponentMonitorStrategy)((Object)this.componentAdapterFactory)).changeMonitor(componentMonitor);
        }
        Iterator iterator = this.componentAdapters.iterator();
        while (iterator.hasNext()) {
            e = iterator.next();
            if (!(e instanceof ComponentMonitorStrategy)) continue;
            ((ComponentMonitorStrategy)e).changeMonitor(componentMonitor);
        }
        iterator = this.children.iterator();
        while (iterator.hasNext()) {
            e = iterator.next();
            if (!(e instanceof ComponentMonitorStrategy)) continue;
            ((ComponentMonitorStrategy)e).changeMonitor(componentMonitor);
        }
    }

    public ComponentMonitor currentMonitor() {
        Object e;
        if (this.componentAdapterFactory instanceof ComponentMonitorStrategy) {
            return ((ComponentMonitorStrategy)((Object)this.componentAdapterFactory)).currentMonitor();
        }
        Iterator iterator = this.componentAdapters.iterator();
        while (iterator.hasNext()) {
            e = iterator.next();
            if (!(e instanceof ComponentMonitorStrategy)) continue;
            return ((ComponentMonitorStrategy)e).currentMonitor();
        }
        iterator = this.children.iterator();
        while (iterator.hasNext()) {
            e = iterator.next();
            if (!(e instanceof ComponentMonitorStrategy)) continue;
            return ((ComponentMonitorStrategy)e).currentMonitor();
        }
        throw new PicoIntrospectionException("No component monitor found in container or its children");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class OrderedComponentAdapterLifecycleManager
    implements LifecycleManager,
    Serializable {
        private List startedComponentAdapters = new ArrayList();

        private OrderedComponentAdapterLifecycleManager() {
        }

        public void start(PicoContainer picoContainer) {
            LifecycleManager lifecycleManager;
            ComponentAdapter componentAdapter;
            Collection collection = DefaultPicoContainer.this.getComponentAdapters();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                componentAdapter = (ComponentAdapter)iterator.next();
                if (!(componentAdapter instanceof LifecycleManager) || !(lifecycleManager = (LifecycleManager)((Object)componentAdapter)).hasLifecycle()) continue;
                componentAdapter.getComponentInstance(picoContainer);
                DefaultPicoContainer.this.addOrderedComponentAdapter(componentAdapter);
            }
            collection = DefaultPicoContainer.this.orderedComponentAdapters;
            this.startedComponentAdapters.clear();
            iterator = collection.iterator();
            while (iterator.hasNext()) {
                componentAdapter = iterator.next();
                if (!(componentAdapter instanceof LifecycleManager)) continue;
                lifecycleManager = (LifecycleManager)((Object)componentAdapter);
                lifecycleManager.start(picoContainer);
                this.startedComponentAdapters.add(componentAdapter);
            }
        }

        public void stop(PicoContainer picoContainer) {
            List list = this.startedComponentAdapters;
            for (int i = list.size() - 1; 0 <= i; --i) {
                Object e = list.get(i);
                if (!(e instanceof LifecycleManager)) continue;
                LifecycleManager lifecycleManager = (LifecycleManager)e;
                lifecycleManager.stop(picoContainer);
            }
        }

        public void dispose(PicoContainer picoContainer) {
            List list = DefaultPicoContainer.this.orderedComponentAdapters;
            for (int i = list.size() - 1; 0 <= i; --i) {
                Object e = list.get(i);
                if (!(e instanceof LifecycleManager)) continue;
                LifecycleManager lifecycleManager = (LifecycleManager)e;
                lifecycleManager.dispose(picoContainer);
            }
        }

        public boolean hasLifecycle() {
            throw new UnsupportedOperationException("Should not have been called");
        }
    }
}

