/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.notify.examples.simple;

import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CosEventChannelAdmin.AlreadyConnected;
import org.omg.CosEventChannelAdmin.TypeError;
import org.omg.CosNotification.Property;
import org.omg.CosNotification.UnsupportedAdmin;
import org.omg.CosNotification.UnsupportedQoS;
import org.omg.CosNotifyChannelAdmin.AdminLimitExceeded;
import org.omg.CosNotifyChannelAdmin.ClientType;
import org.omg.CosNotifyChannelAdmin.EventChannel;
import org.omg.CosNotifyChannelAdmin.EventChannelFactory;
import org.omg.CosNotifyChannelAdmin.EventChannelFactoryHelper;
import org.omg.CosNotifyChannelAdmin.EventChannelHelper;
import org.omg.CosNotifyChannelAdmin.ProxyConsumer;
import org.omg.CosNotifyChannelAdmin.ProxyPullConsumer;
import org.omg.CosNotifyChannelAdmin.ProxyPullConsumerHelper;
import org.omg.CosNotifyChannelAdmin.SupplierAdmin;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.openorb.notify.examples.simple.AnyPullSupplierImpl;
import org.openorb.notify.examples.simple.ORBObjectRef;

public class AnyPullSupplier {
    public static final int NUM_PUSH = 10;
    public static final String HDR = "[AnyPullSupplier] ";

    public static void main(String[] args) {
        try {
            System.out.println("[AnyPullSupplier] Start example");
            System.out.println("[AnyPullSupplier] Initialize the ORB");
            ORB orb = ORB.init((String[])args, null);
            System.out.println("[AnyPullSupplier] Get the event channel");
            EventChannel eventChannel = AnyPullSupplier.getEventChannel(orb);
            if (eventChannel == null) {
                System.err.println("[AnyPullSupplier] No event channel available");
                return;
            }
            System.out.println("[AnyPullSupplier] Obtain the channel's default Supplier Admin");
            SupplierAdmin supplierAdmin = eventChannel.default_supplier_admin();
            System.out.println("[AnyPullSupplier] Obtain a consumer proxy");
            IntHolder proxyId = new IntHolder();
            ProxyConsumer proxyConsumer = null;
            try {
                proxyConsumer = supplierAdmin.obtain_notification_pull_consumer(ClientType.ANY_EVENT, proxyId);
            }
            catch (AdminLimitExceeded ex) {
                ((Throwable)((java.lang.Object)ex)).printStackTrace(System.err);
                return;
            }
            System.out.println("[AnyPullSupplier] Narrow to a proxy pull consumer");
            ProxyPullConsumer proxyPullConsumer = null;
            try {
                proxyPullConsumer = ProxyPullConsumerHelper.narrow(proxyConsumer);
            }
            catch (BAD_PARAM ex) {
                ex.printStackTrace(System.err);
                return;
            }
            System.out.println("[AnyPullSupplier] Initialize RootPOA");
            Object objPOA = null;
            POA rootPOA = null;
            try {
                objPOA = orb.resolve_initial_references("RootPOA");
            }
            catch (InvalidName ex) {
                ex.printStackTrace(System.err);
                return;
            }
            System.out.println("[AnyPullSupplier] Narrow the CORBA Object reference to a POA");
            try {
                rootPOA = POAHelper.narrow((Object)objPOA);
            }
            catch (BAD_PARAM ex) {
                ex.printStackTrace(System.err);
                return;
            }
            System.out.println("[AnyPullSupplier] Create the pull supplier and activate on root POA");
            AnyPullSupplierImpl pullSupplier = new AnyPullSupplierImpl(orb, rootPOA);
            System.out.println("[AnyPullSupplier] Connect to the consumer proxy: pull supplier");
            try {
                proxyPullConsumer.connect_any_pull_supplier(pullSupplier.pullSupplier());
            }
            catch (AlreadyConnected ex) {
                ((Throwable)((java.lang.Object)ex)).printStackTrace(System.err);
                return;
            }
            catch (TypeError ex) {
                ((Throwable)((java.lang.Object)ex)).printStackTrace(System.err);
                return;
            }
            System.out.println("[AnyPullSupplier] The server is ready...");
            orb.run();
        }
        catch (SystemException ex) {
            ex.printStackTrace();
            return;
        }
    }

    private static EventChannel getEventChannel(ORB orb) {
        System.out.println("[AnyPullSupplier] Resolve initial reference to the Notification Service EventChannelFactory");
        Object obj = null;
        try {
            obj = orb.resolve_initial_references("NotificationService");
        }
        catch (InvalidName ex) {
            ex.printStackTrace(System.err);
            return null;
        }
        System.out.println("[AnyPullSupplier] Narrow the CORBA Object reference to an EventChannelFactory");
        EventChannelFactory eventChannelFactory = null;
        try {
            eventChannelFactory = EventChannelFactoryHelper.narrow(obj);
        }
        catch (BAD_PARAM ex) {
            ex.printStackTrace(System.err);
            return null;
        }
        System.out.println("[AnyPullSupplier] Get a reference to an EventChannel from the file");
        ORBObjectRef objRef = new ORBObjectRef(orb, "channel.ref");
        EventChannel eventChannel = null;
        try {
            Object o = objRef.get();
            eventChannel = EventChannelHelper.narrow(o);
        }
        catch (BAD_PARAM ex) {
            ex.printStackTrace(System.err);
            return null;
        }
        if (eventChannel == null) {
            System.out.println("[AnyPullSupplier] Event channel does not exist, creating a new one");
            Property[] initialQoS = new Property[]{};
            Property[] initialAdmin = new Property[]{};
            IntHolder channelId = new IntHolder();
            try {
                eventChannel = eventChannelFactory.create_channel(initialQoS, initialAdmin, channelId);
            }
            catch (UnsupportedQoS ex) {
                ((Throwable)((java.lang.Object)ex)).printStackTrace(System.err);
                return null;
            }
            catch (UnsupportedAdmin ex) {
                ((Throwable)((java.lang.Object)ex)).printStackTrace(System.err);
                return null;
            }
            System.out.println("[AnyPullSupplier] Storing the new channel reference");
            objRef.set(eventChannel);
        }
        return eventChannel;
    }
}

