/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.notify.examples.simple;

import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CosEventChannelAdmin.AlreadyConnected;
import org.omg.CosEventChannelAdmin.TypeError;
import org.omg.CosNotification.Property;
import org.omg.CosNotification.UnsupportedAdmin;
import org.omg.CosNotification.UnsupportedQoS;
import org.omg.CosNotifyChannelAdmin.AdminLimitExceeded;
import org.omg.CosNotifyChannelAdmin.ClientType;
import org.omg.CosNotifyChannelAdmin.ConsumerAdmin;
import org.omg.CosNotifyChannelAdmin.EventChannel;
import org.omg.CosNotifyChannelAdmin.EventChannelFactory;
import org.omg.CosNotifyChannelAdmin.EventChannelFactoryHelper;
import org.omg.CosNotifyChannelAdmin.EventChannelHelper;
import org.omg.CosNotifyChannelAdmin.ProxyPushSupplier;
import org.omg.CosNotifyChannelAdmin.ProxyPushSupplierHelper;
import org.omg.CosNotifyChannelAdmin.ProxySupplier;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.openorb.notify.examples.simple.AnyPushConsumerImpl;
import org.openorb.notify.examples.simple.ORBObjectRef;

public class AnyPushConsumer {
    public static final String HDR = "[AnyPushConsumer] ";

    public static void main(String[] args) {
        try {
            System.out.println("[AnyPushConsumer] Start example");
            System.out.println("[AnyPushConsumer] Initialize the ORB");
            ORB orb = ORB.init((String[])args, null);
            System.out.println("[AnyPushConsumer] Get the event channel");
            EventChannel eventChannel = AnyPushConsumer.getEventChannel(orb);
            if (eventChannel == null) {
                System.err.println("[AnyPushConsumer] No event channel available");
                return;
            }
            System.out.println("[AnyPushConsumer] Obtain the channel's default Consumer Admin");
            ConsumerAdmin consumerAdmin = eventChannel.default_consumer_admin();
            System.out.println("[AnyPushConsumer] Obtain a supplier proxy");
            IntHolder proxyId = new IntHolder();
            ProxySupplier proxySupplier = null;
            try {
                proxySupplier = consumerAdmin.obtain_notification_push_supplier(ClientType.ANY_EVENT, proxyId);
            }
            catch (AdminLimitExceeded ex) {
                ((Throwable)((java.lang.Object)ex)).printStackTrace(System.err);
                return;
            }
            System.out.println("[AnyPushConsumer] Narrow to a proxy push supplier");
            ProxyPushSupplier proxyPushSupplier = null;
            try {
                proxyPushSupplier = ProxyPushSupplierHelper.narrow(proxySupplier);
            }
            catch (BAD_PARAM ex) {
                ex.printStackTrace(System.err);
                return;
            }
            System.out.println("[AnyPushConsumer] Initialize RootPOA");
            Object objPOA = null;
            POA rootPOA = null;
            try {
                objPOA = orb.resolve_initial_references("RootPOA");
            }
            catch (InvalidName ex) {
                ex.printStackTrace(System.err);
                return;
            }
            System.out.println("[AnyPushConsumer] Narrow the CORBA Object reference to a POA");
            try {
                rootPOA = POAHelper.narrow((Object)objPOA);
            }
            catch (BAD_PARAM ex) {
                ex.printStackTrace(System.err);
                return;
            }
            System.out.println("[AnyPushConsumer] Create the push consumer and activate on root POA");
            AnyPushConsumerImpl pushConsumer = new AnyPushConsumerImpl(orb, rootPOA);
            System.out.println("[AnyPushConsumer] Connect to the consumer proxy: push consumer");
            try {
                proxyPushSupplier.connect_any_push_consumer(pushConsumer.pushConsumer());
            }
            catch (AlreadyConnected ex) {
                ((Throwable)((java.lang.Object)ex)).printStackTrace(System.err);
                return;
            }
            catch (TypeError ex) {
                ((Throwable)((java.lang.Object)ex)).printStackTrace(System.err);
                return;
            }
            System.out.println("[AnyPushConsumer] The server is ready...");
            orb.run();
        }
        catch (SystemException ex) {
            ex.printStackTrace();
            return;
        }
    }

    private static EventChannel getEventChannel(ORB orb) {
        System.out.println("[AnyPushConsumer] Resolve initial reference to the Notification Service EventChannelFactory");
        Object obj = null;
        try {
            obj = orb.resolve_initial_references("NotificationService");
        }
        catch (InvalidName ex) {
            ex.printStackTrace(System.err);
            return null;
        }
        System.out.println("[AnyPushConsumer] Narrow the CORBA Object reference to an EventChannelFactory");
        EventChannelFactory eventChannelFactory = null;
        try {
            eventChannelFactory = EventChannelFactoryHelper.narrow(obj);
        }
        catch (BAD_PARAM ex) {
            ex.printStackTrace(System.err);
            return null;
        }
        System.out.println("[AnyPushConsumer] Get a reference to an EventChannel from the file");
        ORBObjectRef objRef = new ORBObjectRef(orb, "channel.ref");
        EventChannel eventChannel = null;
        try {
            Object o = objRef.get();
            eventChannel = EventChannelHelper.narrow(o);
        }
        catch (BAD_PARAM ex) {
            ex.printStackTrace(System.err);
            return null;
        }
        if (eventChannel == null) {
            System.out.println("[AnyPushConsumer] Event channel does not exist, creating a new one");
            Property[] initialQoS = new Property[]{};
            Property[] initialAdmin = new Property[]{};
            IntHolder channelId = new IntHolder();
            try {
                eventChannel = eventChannelFactory.create_channel(initialQoS, initialAdmin, channelId);
            }
            catch (UnsupportedQoS ex) {
                ((Throwable)((java.lang.Object)ex)).printStackTrace(System.err);
                return null;
            }
            catch (UnsupportedAdmin ex) {
                ((Throwable)((java.lang.Object)ex)).printStackTrace(System.err);
                return null;
            }
            System.out.println("[AnyPushConsumer] Storing the new channel reference");
            objRef.set(eventChannel);
        }
        return eventChannel;
    }
}

