/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.notify.examples.simple;

import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSIENT;
import org.omg.CosEventChannelAdmin.AlreadyConnected;
import org.omg.CosEventComm.Disconnected;
import org.omg.CosNotification.Property;
import org.omg.CosNotification.StructuredEvent;
import org.omg.CosNotification.UnsupportedAdmin;
import org.omg.CosNotification.UnsupportedQoS;
import org.omg.CosNotifyChannelAdmin.AdminLimitExceeded;
import org.omg.CosNotifyChannelAdmin.ClientType;
import org.omg.CosNotifyChannelAdmin.ConsumerAdmin;
import org.omg.CosNotifyChannelAdmin.EventChannel;
import org.omg.CosNotifyChannelAdmin.EventChannelFactory;
import org.omg.CosNotifyChannelAdmin.EventChannelFactoryHelper;
import org.omg.CosNotifyChannelAdmin.EventChannelHelper;
import org.omg.CosNotifyChannelAdmin.ProxySupplier;
import org.omg.CosNotifyChannelAdmin.SequenceProxyPullSupplier;
import org.omg.CosNotifyChannelAdmin.SequenceProxyPullSupplierHelper;
import org.openorb.notify.examples.simple.ORBObjectRef;

public class SequencePullConsumer {
    public static final String HDR = "[SequencePullConsumer] ";
    private static int s_batch_size = 10;

    public static void main(String[] args) {
        if (args.length != 0) {
            try {
                s_batch_size = Integer.parseInt(args[args.length - 1]);
            }
            catch (NumberFormatException ex) {
                System.out.println("Unable to parse argument #" + args[args.length - 1]);
            }
        }
        try {
            System.out.println("[SequencePullConsumer] Start example: using pull batch size=" + s_batch_size);
            System.out.println("[SequencePullConsumer] Initialize the ORB");
            ORB orb = ORB.init((String[])args, null);
            System.out.println("[SequencePullConsumer] Get the event channel");
            EventChannel eventChannel = SequencePullConsumer.getEventChannel(orb);
            if (eventChannel == null) {
                System.err.println("[SequencePullConsumer] No event channel available");
                return;
            }
            System.out.println("[SequencePullConsumer] Obtain the channel's default Consumer Admin");
            ConsumerAdmin consumerAdmin = eventChannel.default_consumer_admin();
            System.out.println("[SequencePullConsumer] Obtain a supplier proxy");
            IntHolder proxyId = new IntHolder();
            ProxySupplier proxySupplier = null;
            try {
                proxySupplier = consumerAdmin.obtain_notification_pull_supplier(ClientType.SEQUENCE_EVENT, proxyId);
            }
            catch (AdminLimitExceeded ex) {
                ((Throwable)((java.lang.Object)ex)).printStackTrace(System.err);
                return;
            }
            System.out.println("[SequencePullConsumer] Narrow to a proxy pull supplier");
            SequenceProxyPullSupplier sequenceProxyPullSupplier = null;
            try {
                sequenceProxyPullSupplier = SequenceProxyPullSupplierHelper.narrow(proxySupplier);
            }
            catch (BAD_PARAM ex) {
                ex.printStackTrace(System.err);
                return;
            }
            System.out.println("[SequencePullConsumer] Connect to the supplier proxy: null pull consumer");
            try {
                sequenceProxyPullSupplier.connect_sequence_pull_consumer(null);
            }
            catch (AlreadyConnected ex) {
                ((Throwable)((java.lang.Object)ex)).printStackTrace(System.err);
                return;
            }
            System.out.println("[SequencePullConsumer] Pulling events...");
            boolean done = false;
            while (!done) {
                try {
                    System.out.println("[SequencePullConsumer] Pulling synchronously...");
                    StructuredEvent[] events = sequenceProxyPullSupplier.pull_structured_events(s_batch_size);
                    System.out.println("[SequencePullConsumer] pulled " + events.length + " events");
                    int ii = 0;
                    while (ii < events.length) {
                        done = SequencePullConsumer.showEvent(events[ii]);
                        ++ii;
                    }
                }
                catch (Disconnected ex) {
                    ((Throwable)((java.lang.Object)ex)).printStackTrace(System.err);
                    return;
                }
            }
            System.out.println("[SequencePullConsumer] Disconnecting (removing) the supplier proxy");
            try {
                sequenceProxyPullSupplier.disconnect_sequence_pull_supplier();
            }
            catch (TRANSIENT ex) {
                ex.printStackTrace(System.err);
                return;
            }
            catch (COMM_FAILURE ex) {
                ex.printStackTrace(System.err);
                return;
            }
            System.out.println("[SequencePullConsumer] ORB Shutdown: pending=" + orb.work_pending());
            orb.shutdown(false);
        }
        catch (SystemException ex) {
            ex.printStackTrace(System.err);
            return;
        }
        System.out.println("[SequencePullConsumer] Terminate application");
    }

    private static EventChannel getEventChannel(ORB orb) {
        System.out.println("[SequencePullConsumer] Resolve initial reference to the Notification Service EventChannelFactory");
        Object obj = null;
        try {
            obj = orb.resolve_initial_references("NotificationService");
        }
        catch (InvalidName ex) {
            ex.printStackTrace(System.err);
            return null;
        }
        System.out.println("[SequencePullConsumer] Narrow the CORBA Object reference to an EventChannelFactory");
        EventChannelFactory eventChannelFactory = null;
        try {
            eventChannelFactory = EventChannelFactoryHelper.narrow(obj);
        }
        catch (BAD_PARAM ex) {
            ex.printStackTrace(System.err);
            return null;
        }
        System.out.println("[SequencePullConsumer] Get a reference to an EventChannel from the file");
        ORBObjectRef objRef = new ORBObjectRef(orb, "channel.ref");
        EventChannel eventChannel = null;
        try {
            Object o = objRef.get();
            eventChannel = EventChannelHelper.narrow(o);
        }
        catch (BAD_PARAM ex) {
            ex.printStackTrace(System.err);
            return null;
        }
        if (eventChannel == null) {
            System.out.println("[SequencePullConsumer] Event channel does not exist, creating a new one");
            Property[] initialQoS = new Property[]{};
            Property[] initialAdmin = new Property[]{};
            IntHolder channelId = new IntHolder();
            try {
                eventChannel = eventChannelFactory.create_channel(initialQoS, initialAdmin, channelId);
            }
            catch (UnsupportedQoS ex) {
                ((Throwable)((java.lang.Object)ex)).printStackTrace(System.err);
                return null;
            }
            catch (UnsupportedAdmin ex) {
                ((Throwable)((java.lang.Object)ex)).printStackTrace(System.err);
                return null;
            }
            System.out.println("[SequencePullConsumer] Storing the new channel reference");
            objRef.set(eventChannel);
        }
        return eventChannel;
    }

    public static boolean showEvent(StructuredEvent event) {
        boolean done = false;
        System.out.println("[SequencePullConsumer] \tFixed header: " + event.header.fixed_header.event_type.domain_name + "." + event.header.fixed_header.event_type.type_name + "." + event.header.fixed_header.event_name);
        System.out.println("[SequencePullConsumer] \tFilterable data:");
        int i = 0;
        while (i < event.filterable_data.length) {
            try {
                String name = event.filterable_data[i].name;
                String val = event.filterable_data[i].value.extract_string();
                System.out.println("[SequencePullConsumer] \t\t" + name + " : " + val);
            }
            catch (BAD_OPERATION ex) {
                ex.printStackTrace(System.err);
                return true;
            }
            ++i;
        }
        System.out.println("[SequencePullConsumer] \tVariable header:");
        int i2 = 0;
        while (i2 < event.header.variable_header.length) {
            try {
                String name = event.header.variable_header[i2].name;
                String val = event.header.variable_header[i2].value.extract_string();
                System.out.println("[SequencePullConsumer] \t\t" + name + " : " + val);
            }
            catch (BAD_OPERATION ex) {
                ex.printStackTrace(System.err);
                return true;
            }
            ++i2;
        }
        System.out.print("[SequencePullConsumer] \tRemainder: ");
        String msg = event.remainder_of_body.extract_string();
        System.out.println(msg);
        if (msg.toLowerCase().equals("done")) {
            done = true;
        }
        return done;
    }
}

