/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.notify.examples.simple;

import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.ORB;
import org.omg.CosEventComm.Disconnected;
import org.omg.CosNotification.EventType;
import org.omg.CosNotification.StructuredEvent;
import org.omg.CosNotifyComm.StructuredPushConsumer;
import org.omg.CosNotifyComm.StructuredPushConsumerPOA;
import org.omg.PortableServer.POA;

class StructuredPushConsumerImpl
extends StructuredPushConsumerPOA {
    public static final String HDR = "[StructuredPushConsumerImpl] ";
    private ORB m_orb = null;
    private POA m_poa = null;
    private int m_event_count = 0;
    private StructuredPushConsumer m_pc = null;

    StructuredPushConsumerImpl(ORB orb, POA poa) {
        this.m_orb = orb;
        this.m_poa = poa;
        System.out.println("[StructuredPushConsumerImpl] Implicity conecting POA");
        this.m_pc = this._this(this.m_orb);
        System.out.println("[StructuredPushConsumerImpl] Activating on POA");
        try {
            this.m_poa.the_POAManager().activate();
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            return;
        }
    }

    public void push_structured_event(StructuredEvent event) throws Disconnected {
        System.out.println("[StructuredPushConsumerImpl] Pushed...");
        if (StructuredPushConsumerImpl.showEvent(event)) {
            throw new Disconnected();
        }
    }

    public void disconnect_structured_push_consumer() {
        System.out.println("[StructuredPushConsumerImpl] Disconnected...");
        System.out.println("[StructuredPushConsumerImpl] POA deactivate");
        this.destroy();
        System.out.println("[StructuredPushConsumerImpl] POA destroy");
        this._poa().destroy(true, false);
        System.out.println("[StructuredPushConsumerImpl] ORB Shutdown: pending=" + this.m_orb.work_pending());
        this.m_orb.shutdown(false);
        System.out.println("[StructuredPushConsumerImpl] Terminate application");
        System.exit(0);
    }

    public void offer_change(EventType[] added, EventType[] removed) {
        System.out.println("[StructuredPushConsumerImpl] Subscription change...");
    }

    public StructuredPushConsumer structuredPushConsumer() {
        return this.m_pc;
    }

    public void destroy() {
        try {
            this._poa().deactivate_object(this._object_id());
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
    }

    public static boolean showEvent(StructuredEvent event) {
        boolean done = false;
        System.out.println("[StructuredPushConsumerImpl] \tFixed header: " + event.header.fixed_header.event_type.domain_name + "." + event.header.fixed_header.event_type.type_name + "." + event.header.fixed_header.event_name);
        System.out.println("[StructuredPushConsumerImpl] \tFilterable data:");
        int i = 0;
        while (i < event.filterable_data.length) {
            try {
                String name = event.filterable_data[i].name;
                String val = event.filterable_data[i].value.extract_string();
                System.out.println("[StructuredPushConsumerImpl] \t\t" + name + " : " + val);
            }
            catch (BAD_OPERATION ex) {
                ex.printStackTrace(System.err);
                return true;
            }
            ++i;
        }
        System.out.println("[StructuredPushConsumerImpl] \tVariable header:");
        int i2 = 0;
        while (i2 < event.header.variable_header.length) {
            try {
                String name = event.header.variable_header[i2].name;
                String val = event.header.variable_header[i2].value.extract_string();
                System.out.println("[StructuredPushConsumerImpl] \t\t" + name + " : " + val);
            }
            catch (BAD_OPERATION ex) {
                ex.printStackTrace(System.err);
                return true;
            }
            ++i2;
        }
        System.out.print("[StructuredPushConsumerImpl] \tRemainder: ");
        String msg = event.remainder_of_body.extract_string();
        System.out.println(msg);
        if (msg.toLowerCase().equals("done")) {
            done = true;
        }
        return done;
    }
}

