/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.notify.examples.simple;

import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSIENT;
import org.omg.CosEventChannelAdmin.AlreadyConnected;
import org.omg.CosEventComm.Disconnected;
import org.omg.CosNotification.EventHeader;
import org.omg.CosNotification.EventType;
import org.omg.CosNotification.FixedEventHeader;
import org.omg.CosNotification.Property;
import org.omg.CosNotification.StructuredEvent;
import org.omg.CosNotification.UnsupportedAdmin;
import org.omg.CosNotification.UnsupportedQoS;
import org.omg.CosNotifyChannelAdmin.AdminLimitExceeded;
import org.omg.CosNotifyChannelAdmin.ClientType;
import org.omg.CosNotifyChannelAdmin.EventChannel;
import org.omg.CosNotifyChannelAdmin.EventChannelFactory;
import org.omg.CosNotifyChannelAdmin.EventChannelFactoryHelper;
import org.omg.CosNotifyChannelAdmin.EventChannelHelper;
import org.omg.CosNotifyChannelAdmin.ProxyConsumer;
import org.omg.CosNotifyChannelAdmin.StructuredProxyPushConsumer;
import org.omg.CosNotifyChannelAdmin.StructuredProxyPushConsumerHelper;
import org.omg.CosNotifyChannelAdmin.SupplierAdmin;
import org.openorb.notify.examples.simple.ORBObjectRef;

public class StructuredPushSupplier {
    private static int s_num_push = 10;
    public static final String HDR = "[StructuredPushSupplier] ";

    public static void main(String[] args) {
        if (args.length != 0) {
            try {
                s_num_push = Integer.parseInt(args[args.length - 1]);
            }
            catch (NumberFormatException ex) {
                System.out.println("Couldn't parse argument #" + args[args.length - 1]);
            }
        }
        try {
            System.out.println("[StructuredPushSupplier] Start example: pushing " + s_num_push + " events");
            System.out.println("[StructuredPushSupplier] Initialize the ORB");
            ORB orb = ORB.init((String[])args, null);
            System.out.println("[StructuredPushSupplier] Get the event channel");
            EventChannel eventChannel = StructuredPushSupplier.getEventChannel(orb);
            if (eventChannel == null) {
                System.err.println("[StructuredPushSupplier] No event channel available");
                return;
            }
            System.out.println("[StructuredPushSupplier] Obtain the channel's default Supplier Admin");
            SupplierAdmin supplierAdmin = eventChannel.default_supplier_admin();
            System.out.println("[StructuredPushSupplier] Obtain a consumer proxy");
            IntHolder proxyId = new IntHolder();
            ProxyConsumer proxyConsumer = null;
            try {
                proxyConsumer = supplierAdmin.obtain_notification_push_consumer(ClientType.STRUCTURED_EVENT, proxyId);
            }
            catch (AdminLimitExceeded ex) {
                ((Throwable)((java.lang.Object)ex)).printStackTrace(System.err);
                return;
            }
            System.out.println("[StructuredPushSupplier] Narrow to a proxy push consumer");
            StructuredProxyPushConsumer structuredProxyPushConsumer = null;
            try {
                structuredProxyPushConsumer = StructuredProxyPushConsumerHelper.narrow(proxyConsumer);
            }
            catch (BAD_PARAM ex) {
                ex.printStackTrace(System.err);
                return;
            }
            System.out.println("[StructuredPushSupplier] Connect to the consumer proxy: null push supplier");
            try {
                structuredProxyPushConsumer.connect_structured_push_supplier(null);
            }
            catch (AlreadyConnected ex) {
                ((Throwable)((java.lang.Object)ex)).printStackTrace(System.err);
                return;
            }
            System.out.println("[StructuredPushSupplier] Pushing events...");
            int i = 0;
            while (i < s_num_push) {
                try {
                    System.out.println("[StructuredPushSupplier] Create event");
                    StructuredEvent event = StructuredPushSupplier.createEvent(orb, i);
                    StructuredPushSupplier.showEvent(event);
                    System.out.println("[StructuredPushSupplier] Pushing " + i + "...");
                    structuredProxyPushConsumer.push_structured_event(event);
                }
                catch (Disconnected ex) {
                    ((Throwable)((java.lang.Object)ex)).printStackTrace(System.err);
                    break;
                }
                System.out.println("[StructuredPushSupplier] Done sending events");
                ++i;
            }
            System.out.println("[StructuredPushSupplier] Disconnecting (removing) the consumer proxy");
            try {
                structuredProxyPushConsumer.disconnect_structured_push_consumer();
            }
            catch (TRANSIENT ex) {
                ex.printStackTrace(System.err);
                return;
            }
            catch (COMM_FAILURE ex) {
                ex.printStackTrace(System.err);
                return;
            }
            System.out.println("[StructuredPushSupplier] ORB Shutdown: pending=" + orb.work_pending());
            orb.shutdown(false);
        }
        catch (SystemException ex) {
            ex.printStackTrace();
            return;
        }
        System.out.println("[StructuredPushSupplier] Terminate application");
    }

    private static EventChannel getEventChannel(ORB orb) {
        System.out.println("[StructuredPushSupplier] Resolve initial reference to the Notification Service EventChannelFactory");
        Object obj = null;
        try {
            obj = orb.resolve_initial_references("NotificationService");
        }
        catch (InvalidName ex) {
            ex.printStackTrace(System.err);
            return null;
        }
        System.out.println("[StructuredPushSupplier] Narrow the CORBA Object reference to an EventChannelFactory");
        EventChannelFactory eventChannelFactory = null;
        try {
            eventChannelFactory = EventChannelFactoryHelper.narrow(obj);
        }
        catch (BAD_PARAM ex) {
            ex.printStackTrace(System.err);
            return null;
        }
        System.out.println("[StructuredPushSupplier] Get a reference to an EventChannel from the file");
        ORBObjectRef objRef = new ORBObjectRef(orb, "channel.ref");
        EventChannel eventChannel = null;
        try {
            Object o = objRef.get();
            eventChannel = EventChannelHelper.narrow(o);
        }
        catch (BAD_PARAM ex) {
            ex.printStackTrace(System.err);
            return null;
        }
        if (eventChannel == null) {
            System.out.println("[StructuredPushSupplier] Event channel does not exist, creating a new one");
            Property[] initialQoS = new Property[]{};
            Property[] initialAdmin = new Property[]{};
            IntHolder channelId = new IntHolder();
            try {
                eventChannel = eventChannelFactory.create_channel(initialQoS, initialAdmin, channelId);
            }
            catch (UnsupportedQoS ex) {
                ((Throwable)((java.lang.Object)ex)).printStackTrace(System.err);
                return null;
            }
            catch (UnsupportedAdmin ex) {
                ((Throwable)((java.lang.Object)ex)).printStackTrace(System.err);
                return null;
            }
            System.out.println("[StructuredPushSupplier] Storing the new channel reference");
            objRef.set(eventChannel);
        }
        return eventChannel;
    }

    public static StructuredEvent createEvent(ORB orb, int i) {
        Property property1;
        Property property0;
        String eventName = "StructuredEvent" + i;
        EventType eventType = new EventType("OpenORB", "examples");
        FixedEventHeader fixedEventHeader = new FixedEventHeader(eventType, eventName.toString());
        Property[] variableHeader = new Property[2];
        variableHeader[0] = new Property("variable:counter", orb.create_any());
        variableHeader[0].value.insert_string("" + i);
        variableHeader[1] = new Property("variable:(counter*10)", orb.create_any());
        variableHeader[1].value.insert_string("" + i * 10);
        EventHeader eventHeader = new EventHeader(fixedEventHeader, variableHeader);
        Property[] filterableData = new Property[2];
        filterableData[0] = property0 = new Property("filter:counter", orb.create_any());
        filterableData[0].value.insert_string("" + i);
        filterableData[1] = property1 = new Property("filter:(counter*10)", orb.create_any());
        filterableData[1].value.insert_string("" + i * 10);
        Any msg = orb.create_any();
        if (i == s_num_push - 1) {
            msg.insert_string("done");
        } else {
            msg.insert_string("continue");
        }
        StructuredEvent event = new StructuredEvent(eventHeader, filterableData, msg);
        return event;
    }

    public static void showEvent(StructuredEvent event) {
        System.out.println("[StructuredPushSupplier] \tFixed header: " + event.header.fixed_header.event_type.domain_name + "." + event.header.fixed_header.event_type.type_name + "." + event.header.fixed_header.event_name);
        System.out.println("[StructuredPushSupplier] \tFilterable data:");
        int i = 0;
        while (i < event.filterable_data.length) {
            try {
                String name = event.filterable_data[i].name;
                String val = event.filterable_data[i].value.extract_string();
                System.out.println("[StructuredPushSupplier] \t\t" + name + " : " + val);
            }
            catch (BAD_OPERATION ex) {
                ex.printStackTrace(System.err);
                return;
            }
            ++i;
        }
        System.out.println("[StructuredPushSupplier] \tVariable header:");
        int i2 = 0;
        while (i2 < event.header.variable_header.length) {
            try {
                String name = event.header.variable_header[i2].name;
                String val = event.header.variable_header[i2].value.extract_string();
                System.out.println("[StructuredPushSupplier] \t\t" + name + " : " + val);
            }
            catch (BAD_OPERATION ex) {
                ex.printStackTrace(System.err);
                return;
            }
            ++i2;
        }
        System.out.print("[StructuredPushSupplier] \tRemainder: ");
        String msg = event.remainder_of_body.extract_string();
        System.out.println(msg);
    }
}

