/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.backport.java.util;

import edu.emory.mathcs.backport.java.util.Deque;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ArrayDeque
extends AbstractCollection
implements Deque,
Cloneable,
Serializable {
    private transient Object[] elements;
    private transient int head;
    private transient int tail;
    private static final int MIN_INITIAL_CAPACITY = 8;
    private static final long serialVersionUID = 2340985798034038923L;

    private void allocateElements(int n) {
        int n2 = 8;
        if (n >= n2) {
            n2 = n;
            n2 |= n2 >>> 1;
            n2 |= n2 >>> 2;
            n2 |= n2 >>> 4;
            n2 |= n2 >>> 8;
            n2 |= n2 >>> 16;
            if (++n2 < 0) {
                n2 >>>= 1;
            }
        }
        this.elements = new Object[n2];
    }

    private void doubleCapacity() {
        int n = this.head;
        int n2 = this.elements.length;
        int n3 = n2 - n;
        int n4 = n2 << 1;
        if (n4 < 0) {
            throw new IllegalStateException("Sorry, deque too big");
        }
        Object[] objectArray = new Object[n4];
        System.arraycopy(this.elements, n, objectArray, 0, n3);
        System.arraycopy(this.elements, 0, objectArray, n3, n);
        this.elements = objectArray;
        this.head = 0;
        this.tail = n2;
    }

    private Object[] copyElements(Object[] objectArray) {
        if (this.head < this.tail) {
            System.arraycopy(this.elements, this.head, objectArray, 0, this.size());
        } else if (this.head > this.tail) {
            int n = this.elements.length - this.head;
            System.arraycopy(this.elements, this.head, objectArray, 0, n);
            System.arraycopy(this.elements, 0, objectArray, n, this.tail);
        }
        return objectArray;
    }

    public ArrayDeque() {
        this.elements = new Object[16];
    }

    public ArrayDeque(int n) {
        this.allocateElements(n);
    }

    public ArrayDeque(Collection collection) {
        this.allocateElements(collection.size());
        this.addAll(collection);
    }

    public void addFirst(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        this.head = this.head - 1 & this.elements.length - 1;
        this.elements[this.head] = object;
        if (this.head == this.tail) {
            this.doubleCapacity();
        }
    }

    public void addLast(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        this.elements[this.tail] = object;
        this.tail = this.tail + 1 & this.elements.length - 1;
        if (this.tail == this.head) {
            this.doubleCapacity();
        }
    }

    public boolean offerFirst(Object object) {
        this.addFirst(object);
        return true;
    }

    public boolean offerLast(Object object) {
        this.addLast(object);
        return true;
    }

    public Object removeFirst() {
        Object object = this.pollFirst();
        if (object == null) {
            throw new NoSuchElementException();
        }
        return object;
    }

    public Object removeLast() {
        Object object = this.pollLast();
        if (object == null) {
            throw new NoSuchElementException();
        }
        return object;
    }

    public Object pollFirst() {
        int n = this.head;
        Object object = this.elements[n];
        if (object == null) {
            return null;
        }
        this.elements[n] = null;
        this.head = n + 1 & this.elements.length - 1;
        return object;
    }

    public Object pollLast() {
        int n = this.tail - 1 & this.elements.length - 1;
        Object object = this.elements[n];
        if (object == null) {
            return null;
        }
        this.elements[n] = null;
        this.tail = n;
        return object;
    }

    public Object getFirst() {
        Object object = this.elements[this.head];
        if (object == null) {
            throw new NoSuchElementException();
        }
        return object;
    }

    public Object getLast() {
        Object object = this.elements[this.tail - 1 & this.elements.length - 1];
        if (object == null) {
            throw new NoSuchElementException();
        }
        return object;
    }

    public Object peekFirst() {
        return this.elements[this.head];
    }

    public Object peekLast() {
        return this.elements[this.tail - 1 & this.elements.length - 1];
    }

    public boolean removeFirstOccurrence(Object object) {
        Object object2;
        if (object == null) {
            return false;
        }
        int n = this.elements.length - 1;
        int n2 = this.head;
        while ((object2 = this.elements[n2]) != null) {
            if (object.equals(object2)) {
                this.delete(n2);
                return true;
            }
            n2 = n2 + 1 & n;
        }
        return false;
    }

    public boolean removeLastOccurrence(Object object) {
        Object object2;
        if (object == null) {
            return false;
        }
        int n = this.elements.length - 1;
        int n2 = this.tail - 1 & n;
        while ((object2 = this.elements[n2]) != null) {
            if (object.equals(object2)) {
                this.delete(n2);
                return true;
            }
            n2 = n2 - 1 & n;
        }
        return false;
    }

    public boolean add(Object object) {
        this.addLast(object);
        return true;
    }

    public boolean offer(Object object) {
        return this.offerLast(object);
    }

    public Object remove() {
        return this.removeFirst();
    }

    public Object poll() {
        return this.pollFirst();
    }

    public Object element() {
        return this.getFirst();
    }

    public Object peek() {
        return this.peekFirst();
    }

    public void push(Object object) {
        this.addFirst(object);
    }

    public Object pop() {
        return this.removeFirst();
    }

    private boolean delete(int n) {
        int n2 = this.elements.length - 1;
        if ((n - this.head & n2) >= (this.tail - this.head & n2)) {
            throw new ConcurrentModificationException();
        }
        if (n >= this.head) {
            System.arraycopy(this.elements, this.head, this.elements, this.head + 1, n - this.head);
            this.elements[this.head] = null;
            this.head = this.head + 1 & n2;
            return false;
        }
        --this.tail;
        System.arraycopy(this.elements, n + 1, this.elements, n, this.tail - n);
        this.elements[this.tail] = null;
        return true;
    }

    public int size() {
        return this.tail - this.head & this.elements.length - 1;
    }

    public boolean isEmpty() {
        return this.head == this.tail;
    }

    public Iterator iterator() {
        return new DeqIterator();
    }

    public boolean contains(Object object) {
        Object object2;
        if (object == null) {
            return false;
        }
        int n = this.elements.length - 1;
        int n2 = this.head;
        while ((object2 = this.elements[n2]) != null) {
            if (object.equals(object2)) {
                return true;
            }
            n2 = n2 + 1 & n;
        }
        return false;
    }

    public boolean remove(Object object) {
        return this.removeFirstOccurrence(object);
    }

    public void clear() {
        int n = this.head;
        int n2 = this.tail;
        if (n != n2) {
            this.tail = 0;
            this.head = 0;
            int n3 = n;
            int n4 = this.elements.length - 1;
            do {
                this.elements[n3] = null;
            } while ((n3 = n3 + 1 & n4) != n2);
        }
    }

    public Object[] toArray() {
        return this.copyElements(new Object[this.size()]);
    }

    public Object[] toArray(Object[] objectArray) {
        int n = this.size();
        if (objectArray.length < n) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), n);
        }
        this.copyElements(objectArray);
        if (objectArray.length > n) {
            objectArray[n] = null;
        }
        return objectArray;
    }

    public Object clone() {
        try {
            ArrayDeque arrayDeque = (ArrayDeque)super.clone();
            arrayDeque.elements = new Object[this.elements.length];
            System.arraycopy(this.elements, 0, arrayDeque.elements, 0, this.elements.length);
            return arrayDeque;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError();
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        int n = this.size();
        objectOutputStream.writeInt(n);
        int n2 = this.head;
        int n3 = this.elements.length - 1;
        for (int i = 0; i < n; ++i) {
            objectOutputStream.writeObject(this.elements[n2]);
            n2 = n2 + 1 & n3;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.allocateElements(n);
        this.head = 0;
        this.tail = n;
        for (int i = 0; i < n; ++i) {
            this.elements[i] = objectInputStream.readObject();
        }
    }

    private class DeqIterator
    implements Iterator {
        private int cursor;
        private int fence;
        private int lastRet;

        private DeqIterator() {
            this.cursor = ArrayDeque.this.head;
            this.fence = ArrayDeque.this.tail;
            this.lastRet = -1;
        }

        public boolean hasNext() {
            return this.cursor != this.fence;
        }

        public Object next() {
            Object object;
            if (this.cursor == this.fence) {
                throw new NoSuchElementException();
            }
            if (ArrayDeque.this.tail != this.fence || (object = ArrayDeque.this.elements[this.cursor]) == null) {
                throw new ConcurrentModificationException();
            }
            this.lastRet = this.cursor;
            this.cursor = this.cursor + 1 & ArrayDeque.this.elements.length - 1;
            return object;
        }

        public void remove() {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            if (ArrayDeque.this.delete(this.lastRet)) {
                --this.cursor;
            }
            this.lastRet = -1;
            this.fence = ArrayDeque.this.tail;
        }
    }
}

