/*
 * Decompiled with CFR 0.152.
 */
package com.n2bb.AlertsModule.db;

import com.n2bb.AlertsModule.Action;
import com.n2bb.AlertsModule.ActionType;
import com.n2bb.AlertsModule.AlertData;
import com.n2bb.AlertsModule.AlertHistory;
import com.n2bb.AlertsModule.AlertName;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Vector;
import javax.sql.DataSource;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DriverManagerConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.PoolingDataSource;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.apache.log4j.Logger;

public class AlertHistPersist {
    private static Logger n2bbLog = Logger.getLogger(AlertHistPersist.class);
    private static AlertHistPersist histPersist = null;
    private DataSource dataSource;
    private static final String GET_ALERT_HIST_ID_STMT = "select alerts_hist_id.nextval from DUAL";
    private static final String GET_ALERTS_STMT = "select alerts_hist.hist_key, alerts_hist.time_key, alerts_hist.identifier, alerts_hist.alert_name, alerts_hist.alert_type, alerts_hist.msg, alert_actions_hist.action_type, alert_actions_hist.detail FROM alerts_hist, alert_actions_hist ";
    private static final String GET_ALERT_IDENTIFIERS_STMT = "select distinct identifier from alerts_hist";
    private static final String GET_ALERT_NAMES_STMT = "select distinct alert_name from alerts_hist";
    private static final String WRITE_ALERT_STMT = "insert into alerts_hist values (?, ?, ?, ?, ?, ?)";
    private static final String WRITE_ALERT_ACTIONS_STMT = "insert into alert_actions_hist values (?, ?, ?)";
    private static final String connTest = "select 1 from dual";

    private AlertHistPersist(String dbDriver, String dbURL, String dbUser, String dbPwd, int maxCons) throws Exception {
        n2bbLog.debug((Object)"enter");
        n2bbLog.info((Object)("dbUser... " + dbUser));
        n2bbLog.info((Object)("dbPwd... " + dbPwd));
        n2bbLog.info((Object)("dbURL... " + dbURL));
        n2bbLog.info((Object)("dbDriver... " + dbDriver));
        System.setProperty("jdbc.drivers", dbDriver);
        GenericObjectPool connPool = new GenericObjectPool(null, maxCons);
        DriverManagerConnectionFactory connFactory = new DriverManagerConnectionFactory(dbURL, dbUser, dbPwd);
        PoolableConnectionFactory poolableConnFactory = new PoolableConnectionFactory((ConnectionFactory)connFactory, (ObjectPool)connPool, null, connTest, false, true);
        this.dataSource = new PoolingDataSource((ObjectPool)connPool);
    }

    public static AlertHistPersist getInstance(String dbDriver, String dbURL, String dbUser, String dbPwd, int maxCons) throws Exception {
        if (histPersist == null) {
            histPersist = new AlertHistPersist(dbDriver, dbURL, dbUser, dbPwd, maxCons);
        }
        return histPersist;
    }

    public static AlertHistPersist getInstance() {
        if (histPersist == null) {
            n2bbLog.error((Object)"histPersist is null - call getInstance() with database variables to initialize");
        }
        return histPersist;
    }

    public void logAlert(java.util.Date date, AlertData ad, String msg, boolean actionTaken) throws Exception {
        n2bbLog.debug((Object)"enter");
        Connection conn = null;
        Statement ps = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            n2bbLog.debug((Object)"getting db connection...");
            conn = this.dataSource.getConnection();
            stmt = conn.createStatement();
            rs = stmt.executeQuery(GET_ALERT_HIST_ID_STMT);
            rs.next();
            long index = rs.getLong(1);
            rs.close();
            stmt.close();
            ps = conn.prepareStatement(WRITE_ALERT_STMT);
            ps.setLong(1, index);
            ps.setTimestamp(2, new Timestamp(date.getTime()));
            ps.setString(3, ad.identifier);
            ps.setString(4, ad.name.name);
            ps.setString(5, ad.name.type);
            ps.setString(6, msg);
            ps.executeUpdate();
            ps.close();
            if (actionTaken) {
                ps = conn.prepareStatement(WRITE_ALERT_ACTIONS_STMT);
                for (int i = 0; i < ad.action.length; ++i) {
                    ps.setLong(1, index);
                    if (ActionType.a_email == ad.action[i].type) {
                        ps.setInt(2, 0);
                    } else {
                        ps.setInt(2, 1);
                    }
                    ps.setString(3, ad.action[i].detail);
                    ps.executeUpdate();
                }
            }
            ps.close();
        }
        catch (Exception e) {
            n2bbLog.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception e) {}
            try {
                stmt.close();
            }
            catch (Exception e) {}
            try {
                ps.close();
            }
            catch (Exception e) {}
            try {
                conn.close();
            }
            catch (Exception e) {}
        }
    }

    private String buildQuery(java.util.Date start, java.util.Date end, String identifier, String alertName, String action) throws Exception {
        n2bbLog.debug((Object)"enter");
        StringBuffer query = new StringBuffer(GET_ALERTS_STMT);
        try {
            if (action != null) {
                query.append("WHERE alerts_hist.hist_key = alert_actions_hist.hist_key");
                query.append(" and alert_actions_hist.action_type=?");
            } else {
                query.append("WHERE alerts_hist.hist_key = alert_actions_hist.hist_key(+)");
            }
            if (start != null) {
                query.append(" and alerts_hist.time_key >= ?");
            }
            if (end != null) {
                query.append(" and alerts_hist.time_key <= ?");
            }
            if (identifier != null) {
                query.append(" and alerts_hist.identifier = ?");
            }
            if (alertName != null) {
                query.append(" and alerts_hist.alert_name = ?");
            }
            n2bbLog.debug((Object)("query... " + query.toString()));
            return query.toString();
        }
        catch (Exception e) {
            n2bbLog.error((Object)("error building query - message... " + e.getMessage()), (Throwable)e);
            n2bbLog.error((Object)("query... " + query.toString()));
            return GET_ALERTS_STMT;
        }
    }

    public AlertHistory[] getAlertHistory(java.util.Date start, java.util.Date end, String identifier, String alertName, String action) throws Exception {
        n2bbLog.debug((Object)"enter");
        n2bbLog.debug((Object)("start... " + start));
        n2bbLog.debug((Object)("end... " + end));
        n2bbLog.debug((Object)("identifier... " + identifier));
        n2bbLog.debug((Object)("alertName... " + alertName));
        n2bbLog.debug((Object)("action... " + action));
        Connection conn = null;
        Statement ps = null;
        ResultSet rs = null;
        try {
            n2bbLog.debug((Object)"getting db connection...");
            conn = this.dataSource.getConnection();
            String query = null;
            if (start == null && end == null && identifier == null && alertName == null && action == null) {
                ps = conn.prepareStatement("select alerts_hist.hist_key, alerts_hist.time_key, alerts_hist.identifier, alerts_hist.alert_name, alerts_hist.alert_type, alerts_hist.msg, alert_actions_hist.action_type, alert_actions_hist.detail FROM alerts_hist, alert_actions_hist WHERE alerts_hist.hist_key = alert_actions_hist.hist_key(+)");
            } else {
                query = this.buildQuery(start, end, identifier, alertName, action);
                n2bbLog.debug((Object)"preparing query");
                ps = conn.prepareStatement(query);
                n2bbLog.debug((Object)"prepared query");
                int i = 1;
                if (action != null) {
                    if (action.trim().equalsIgnoreCase("email")) {
                        ps.setInt(i++, 0);
                    } else {
                        ps.setInt(i++, 1);
                    }
                }
                if (start != null) {
                    ps.setDate(i++, new Date(start.getTime()));
                }
                if (end != null) {
                    ps.setDate(i++, new Date(end.getTime() + 86400000L));
                }
                if (identifier != null) {
                    ps.setString(i++, identifier);
                }
                if (alertName != null) {
                    ps.setString(i++, alertName);
                }
            }
            n2bbLog.debug((Object)"executing query");
            rs = ps.executeQuery();
            n2bbLog.debug((Object)"executed query");
            Vector<AlertHistory> hist = new Vector<AlertHistory>();
            long curr_hist_key = -1L;
            AlertHistory ah = null;
            Action act = null;
            Vector<Action> actions = new Vector<Action>();
            n2bbLog.debug((Object)"looping through result set");
            while (rs.next()) {
                try {
                    int actionType;
                    long hist_key = rs.getLong(1);
                    if (curr_hist_key == hist_key) {
                        n2bbLog.debug((Object)"same alert, new action");
                        actionType = rs.getInt(7);
                        if (rs.wasNull()) continue;
                        act = new Action();
                        act.type = ActionType.from_int(actionType);
                        act.detail = rs.getString(8);
                        actions.add(act);
                        continue;
                    }
                    n2bbLog.debug((Object)"new alert");
                    if (ah != null) {
                        Action[] actionArray = new Action[actions.size()];
                        actionArray = actions.toArray(actionArray);
                        ah.action = actionArray;
                        hist.add(ah);
                        actions = new Vector();
                    }
                    curr_hist_key = hist_key;
                    n2bbLog.debug((Object)"creating new AlertHistory object");
                    ah = new AlertHistory();
                    ah.timestamp = rs.getTimestamp(2).getTime();
                    ah.identifier = rs.getString(3);
                    AlertName an = new AlertName();
                    an.name = rs.getString(4);
                    an.type = rs.getString(5);
                    ah.name = an;
                    ah.detail = rs.getString(6);
                    actionType = rs.getInt(7);
                    n2bbLog.debug((Object)"checking to see if alert had actions");
                    if (rs.wasNull()) continue;
                    n2bbLog.debug((Object)"creating new Alert object");
                    act = new Action();
                    act.type = ActionType.from_int(actionType);
                    act.detail = rs.getString(8);
                    actions.add(act);
                }
                catch (Exception e) {
                    n2bbLog.error((Object)("error processing rs.next() - skipping - message... " + e.getMessage()), (Throwable)e);
                }
            }
            n2bbLog.debug((Object)("looped through result set - size... " + hist.size()));
            n2bbLog.debug((Object)"finishing last alert");
            try {
                if (ah != null) {
                    Action[] actionArray = new Action[actions.size()];
                    actionArray = actions.toArray(actionArray);
                    ah.action = actionArray;
                    hist.add(ah);
                }
            }
            catch (Exception e) {
                n2bbLog.error((Object)("error processing last alert - skipping - message... " + e.getMessage()), (Throwable)e);
            }
            rs.close();
            ps.close();
            n2bbLog.debug((Object)("alert history size... " + hist.size()));
            AlertHistory[] alertHistory = new AlertHistory[hist.size()];
            alertHistory = hist.toArray(alertHistory);
            n2bbLog.debug((Object)("alert history array length... " + alertHistory.length));
            AlertHistory[] alertHistoryArray = alertHistory;
            return alertHistoryArray;
        }
        catch (Exception e) {
            n2bbLog.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception e) {}
            try {
                ps.close();
            }
            catch (Exception e) {}
            try {
                conn.close();
            }
            catch (Exception e) {}
        }
    }

    public AlertHistory[] getAlertHistory() throws Exception {
        n2bbLog.debug((Object)"enter");
        return this.getAlertHistory(null, null, null, null, null);
    }

    public String[] getIdentifiers() throws Exception {
        n2bbLog.debug((Object)"enter");
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            n2bbLog.debug((Object)"getting db connection...");
            conn = this.dataSource.getConnection();
            stmt = conn.createStatement();
            rs = stmt.executeQuery(GET_ALERT_IDENTIFIERS_STMT);
            Vector<String> idsV = new Vector<String>();
            while (rs.next()) {
                idsV.add(rs.getString(1));
            }
            rs.close();
            stmt.close();
            String[] ids = new String[idsV.size()];
            ids = idsV.toArray(ids);
            String[] stringArray = ids;
            return stringArray;
        }
        catch (Exception e) {
            n2bbLog.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception e) {}
            try {
                stmt.close();
            }
            catch (Exception e) {}
            try {
                conn.close();
            }
            catch (Exception e) {}
        }
    }

    public String[] getAlertNames() throws Exception {
        n2bbLog.debug((Object)"enter");
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            n2bbLog.debug((Object)"getting db connection...");
            conn = this.dataSource.getConnection();
            stmt = conn.createStatement();
            rs = stmt.executeQuery(GET_ALERT_NAMES_STMT);
            Vector<String> namesV = new Vector<String>();
            while (rs.next()) {
                namesV.add(rs.getString(1));
            }
            rs.close();
            stmt.close();
            String[] names = new String[namesV.size()];
            names = namesV.toArray(names);
            String[] stringArray = names;
            return stringArray;
        }
        catch (Exception e) {
            n2bbLog.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            try {
                rs.close();
            }
            catch (Exception e) {}
            try {
                stmt.close();
            }
            catch (Exception e) {}
            try {
                conn.close();
            }
            catch (Exception e) {}
        }
    }
}

