/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.ots.Admin;

import java.util.List;
import java.util.Vector;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.UserException;
import org.omg.CosTransactions.Control;
import org.omg.CosTransactions.ControlHelper;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;
import org.openorb.ots.ManagerCallback;
import org.openorb.ots.ManagerCallbackPackage.HeuristicKind;
import org.openorb.ots.ManagerPOA;
import org.openorb.ots.XID;

public class Manager
extends ManagerPOA {
    private List m_controls = new Vector();
    private POA m_poa;
    private static Vector s_callbacks = new Vector();

    public List getControls() {
        return this.m_controls;
    }

    public Manager(POA poa) {
        this.m_poa = poa;
    }

    public Control[] currentTransactions(ManagerCallback callback) {
        Control[] controls = new Control[this.m_controls.size()];
        int i = 0;
        while (i < this.m_controls.size()) {
            org.openorb.ots.Impl.Control servant = (org.openorb.ots.Impl.Control)this.m_controls.get(i);
            try {
                controls[i] = ControlHelper.narrow(this.m_poa.servant_to_reference((Servant)servant));
            }
            catch (UserException ex) {
                throw new INTERNAL(ex.toString());
            }
            ++i;
        }
        return controls;
    }

    public void notifyNewTransaction(org.openorb.ots.Impl.Control ctrl, org.openorb.ots.Impl.XID xid) {
        Control ctrl_ref;
        XID myXid = new XID();
        myXid.format_id = xid.get_format_id();
        myXid.bqual = xid.get_bqual();
        myXid.gtrid = xid.get_gtrid();
        try {
            ctrl_ref = ControlHelper.narrow(this.m_poa.servant_to_reference((Servant)ctrl));
        }
        catch (UserException ex) {
            throw new INTERNAL(ex.toString());
        }
        this.m_controls.add(ctrl);
        ManagerCallback callback = null;
        int i = 0;
        while (i < s_callbacks.size()) {
            callback = (ManagerCallback)s_callbacks.elementAt(i);
            try {
                callback.transaction_created(ctrl_ref, myXid);
            }
            catch (Exception ex) {
                s_callbacks.removeElementAt(i);
                --i;
            }
            ++i;
        }
    }

    public static void notifyCommit(org.openorb.ots.Impl.XID xid) {
        XID myXid = new XID();
        myXid.format_id = xid.get_format_id();
        myXid.bqual = xid.get_bqual();
        myXid.gtrid = xid.get_gtrid();
        ManagerCallback callback = null;
        int i = 0;
        while (i < s_callbacks.size()) {
            callback = (ManagerCallback)s_callbacks.elementAt(i);
            try {
                callback.transaction_committed(myXid);
            }
            catch (Exception ex) {
                s_callbacks.removeElementAt(i);
                --i;
            }
            ++i;
        }
    }

    public static void notifyRollback(org.openorb.ots.Impl.XID xid) {
        XID myXid = new XID();
        myXid.format_id = xid.get_format_id();
        myXid.bqual = xid.get_bqual();
        myXid.gtrid = xid.get_gtrid();
        ManagerCallback callback = null;
        int i = 0;
        while (i < s_callbacks.size()) {
            callback = (ManagerCallback)s_callbacks.elementAt(i);
            try {
                callback.transaction_rolledback(myXid);
            }
            catch (Exception ex) {
                s_callbacks.removeElementAt(i);
                --i;
            }
            ++i;
        }
    }

    public static void notifyHeuristic(org.openorb.ots.Impl.XID xid, HeuristicKind heuristic) {
        XID myXid = new XID();
        myXid.format_id = xid.get_format_id();
        myXid.bqual = xid.get_bqual();
        myXid.gtrid = xid.get_gtrid();
        ManagerCallback callback = null;
        int i = 0;
        while (i < s_callbacks.size()) {
            callback = (ManagerCallback)s_callbacks.elementAt(i);
            try {
                callback.transaction_heuristic(myXid, heuristic);
            }
            catch (Exception ex) {
                s_callbacks.removeElementAt(i);
                --i;
            }
            ++i;
        }
    }
}

