/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.ots.Impl;

import org.omg.CORBA.INVALID_TRANSACTION;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.CosTransactions.HeuristicHazard;
import org.omg.CosTransactions.HeuristicMixed;
import org.omg.CosTransactions.Status;
import org.omg.CosTransactions.SubtransactionAwareResource;
import org.omg.CosTransactions.TerminatorPOA;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAPackage.ObjectNotActive;
import org.omg.PortableServer.POAPackage.ServantNotActive;
import org.omg.PortableServer.POAPackage.WrongPolicy;
import org.omg.PortableServer.Servant;
import org.openorb.ots.Impl.Coordinator;
import org.openorb.ots.Impl.SubTransCoordinator;
import org.openorb.ots.log.Writer;

public class SubTransTerminator
extends TerminatorPOA {
    private SubTransCoordinator m_coordinator;
    private POA m_poa;

    public SubTransTerminator(POA poa, Coordinator coordinator) {
        this.m_coordinator = (SubTransCoordinator)coordinator;
        this.m_poa = poa;
    }

    public synchronized void commit(boolean report_heuristics) throws HeuristicMixed, HeuristicHazard {
        switch (this.m_coordinator.get_status().value()) {
            case 0: {
                break;
            }
            case 4: {
                throw new TRANSACTION_ROLLEDBACK();
            }
            case 1: {
                this.rollback();
                throw new TRANSACTION_ROLLEDBACK();
            }
            default: {
                throw new INVALID_TRANSACTION();
            }
        }
        this.proceed_commit();
    }

    public synchronized void rollback() {
        switch (this.m_coordinator.get_status().value()) {
            case 0: 
            case 1: {
                break;
            }
            case 4: {
                return;
            }
            default: {
                throw new INVALID_TRANSACTION();
            }
        }
        this.m_coordinator.synchronize();
        this.proceed_rollback();
    }

    public synchronized void proceed_commit() {
        this.m_coordinator.setStatus(Status.StatusCommitting);
        this.m_coordinator.commit_sub_transactions();
        this.m_coordinator.setStatus(Status.StatusCommitted);
        this.m_coordinator.desynchronize();
        SubtransactionAwareResource[] resources = this.m_coordinator.subtran_resources();
        int i = 0;
        while (i < resources.length) {
            resources[i].commit_subtransaction(this.m_coordinator.getParents()[this.m_coordinator.getParents().length - 1].coord);
            ++i;
        }
    }

    public synchronized void proceed_rollback() {
        this.m_coordinator.setStatus(Status.StatusRollingBack);
        this.m_coordinator.rollback_sub_transactions();
        this.m_coordinator.setStatus(Status.StatusRolledBack);
        this.m_coordinator.desynchronize();
        SubtransactionAwareResource[] resources = this.m_coordinator.subtran_resources();
        int i = 0;
        while (i < resources.length) {
            resources[i].rollback_subtransaction();
            ++i;
        }
    }

    public void removeItself() {
        Writer.getOut().completed(this.m_coordinator.getXID());
        try {
            this.m_poa.deactivate_object(this.m_poa.servant_to_id((Servant)this));
            this.m_coordinator.removeItself();
        }
        catch (ObjectNotActive ex) {
        }
        catch (WrongPolicy ex) {
        }
        catch (ServantNotActive servantNotActive) {
            // empty catch block
        }
    }
}

