/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.ots.ORB;

import org.apache.avalon.framework.logger.ConsoleLogger;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.LocalObject;
import org.omg.CosTransactions.CurrentHelper;
import org.omg.CosTransactions.PropagationContext;
import org.omg.CosTransactions.PropagationContextHelper;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecFactory;
import org.omg.IOP.CodecFactoryPackage.UnknownEncoding;
import org.omg.IOP.CodecPackage.FormatMismatch;
import org.omg.IOP.CodecPackage.TypeMismatch;
import org.omg.IOP.Encoding;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableInterceptor.InvalidSlot;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.omg.PortableInterceptor.ORBInitInfoPackage.InvalidName;
import org.omg.PortableInterceptor.ServerRequestInfo;
import org.omg.PortableInterceptor.ServerRequestInterceptor;
import org.openorb.ots.Impl.Current;

public class TransactionalServerInterceptor
extends LocalObject
implements ServerRequestInterceptor,
LogEnabled {
    private ORBInitInfo m_info;
    private int m_slot;
    private Logger m_logger;

    public TransactionalServerInterceptor(ORBInitInfo info, int slot) {
        this.m_info = info;
        this.m_slot = slot;
    }

    public void receive_request_service_contexts(ServerRequestInfo ri) throws ForwardRequest {
        this.getLogger().debug("receive_request_service_contexts");
        ServiceContext serviceCtx = null;
        try {
            serviceCtx = ri.get_request_service_context(0);
        }
        catch (BAD_PARAM bp) {
            return;
        }
        try {
            CodecFactory codecFactory = this.m_info.codec_factory();
            Encoding encoding = new Encoding(0, new Integer(1).byteValue(), new Integer(2).byteValue());
            Codec codec = codecFactory.create_codec(encoding);
            Any any = codec.decode_value(serviceCtx.context_data, PropagationContextHelper.type());
            PropagationContext pctx = PropagationContextHelper.extract(any);
            ri.set_slot(this.m_slot, any);
            org.omg.CosTransactions.Current current = CurrentHelper.narrow(this.m_info.resolve_initial_references("TransactionCurrent"));
            ((Current)current).applyXAConnection(pctx);
        }
        catch (InvalidName ex) {
            this.getLogger().error("Invalid name : TransactionService", (Throwable)ex);
            throw new INTERNAL();
        }
        catch (UnknownEncoding ue) {
            this.getLogger().error("Unknown encoding", (Throwable)ue);
            throw new INTERNAL();
        }
        catch (InvalidSlot is) {
            this.getLogger().error("Invalid Slot : " + this.m_slot, (Throwable)is);
            throw new INTERNAL();
        }
        catch (FormatMismatch fm) {
            this.getLogger().error("Format Mismatch", (Throwable)fm);
            throw new INTERNAL();
        }
        catch (TypeMismatch tm) {
            this.getLogger().error("Type Mismatch", (Throwable)tm);
            throw new INTERNAL();
        }
    }

    public void receive_request(ServerRequestInfo ri) throws ForwardRequest {
    }

    public void send_reply(ServerRequestInfo ri) {
    }

    public void send_exception(ServerRequestInfo ri) throws ForwardRequest {
    }

    public void send_other(ServerRequestInfo ri) throws ForwardRequest {
    }

    public String name() {
        return "TransactionalServerInterceptor";
    }

    public void destroy() {
    }

    public void enableLogging(Logger logger) {
        this.m_logger = logger;
    }

    private Logger getLogger() {
        if (this.m_logger == null) {
            this.m_logger = new ConsoleLogger(1);
        }
        return this.m_logger;
    }
}

