/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.ots.log;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Vector;
import org.apache.avalon.framework.logger.Logger;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.ORB;
import org.omg.CosTransactions.Resource;
import org.omg.CosTransactions.Status;
import org.omg.CosTransactions.Vote;
import org.openorb.orb.config.ORBLoader;
import org.openorb.orb.config.PropertyNotFoundException;
import org.openorb.ots.Impl.XID;
import org.openorb.ots.log.Reader;
import org.openorb.ots.log.ResourceLog;

public class LogMonitor {
    private Reader m_reader;
    private String m_last_log;
    private ORB m_orb;
    private Logger m_logger;

    public LogMonitor(ORB orb, Logger logger) {
        this.m_orb = orb;
        this.m_logger = logger;
    }

    public Status transaction_status(XID xid) {
        Status status = null;
        this.openLast();
        status = this.m_reader.transaction_status(xid);
        if (status.value() == 6) {
            while (this.openPrevious() && (status = this.m_reader.transaction_status(xid)).value() == 6) {
            }
        }
        this.m_reader.close();
        return status;
    }

    public XID[] uncompleted_transactions() {
        this.openLast();
        XID[] xids = this.m_reader.uncompleted_transactions();
        this.m_reader.close();
        return xids;
    }

    public Resource[] registered_resources(XID xid) {
        Resource[] registered = null;
        Vector resources = new Vector();
        this.openLast();
        boolean is_begin_here = this.m_reader.registered_resources(xid, resources);
        if (is_begin_here) {
            while (this.openPrevious() && !(is_begin_here = this.m_reader.registered_resources(xid, resources))) {
            }
        }
        this.m_reader.close();
        registered = new Resource[resources.size()];
        int i = 0;
        while (i < resources.size()) {
            registered[i] = (Resource)resources.elementAt(i);
            ++i;
        }
        return registered;
    }

    public Resource[] prepared_resources(XID xid) {
        Resource[] prepared = null;
        Vector resources = new Vector();
        this.openLast();
        boolean is_begin_here = this.m_reader.prepared_resources(xid, resources);
        if (is_begin_here) {
            while (this.openPrevious() && !(is_begin_here = this.m_reader.prepared_resources(xid, resources))) {
            }
        }
        this.m_reader.close();
        int nb_prepared = 0;
        ResourceLog rl = null;
        int i = 0;
        while (i < resources.size()) {
            rl = (ResourceLog)resources.elementAt(i);
            if (!rl.isReserved()) {
                ++nb_prepared;
            }
            ++i;
        }
        prepared = new Resource[nb_prepared];
        nb_prepared = 0;
        int i2 = 0;
        while (i2 < resources.size()) {
            rl = (ResourceLog)resources.elementAt(i2);
            if (!rl.isReserved()) {
                prepared[nb_prepared++] = rl.getResource();
            }
            ++i2;
        }
        return prepared;
    }

    public Resource[] free_resources(XID xid) {
        Resource[] free = null;
        Vector resources = new Vector();
        this.openLast();
        boolean is_begin_here = this.m_reader.free_resources(xid, resources);
        if (is_begin_here) {
            while (this.openPrevious() && !(is_begin_here = this.m_reader.free_resources(xid, resources))) {
            }
        }
        this.m_reader.close();
        int nb_free = 0;
        ResourceLog rl = null;
        int i = 0;
        while (i < resources.size()) {
            rl = (ResourceLog)resources.elementAt(i);
            if (!rl.isReserved()) {
                ++nb_free;
            }
            ++i;
        }
        free = new Resource[nb_free];
        nb_free = 0;
        int i2 = 0;
        while (i2 < resources.size()) {
            rl = (ResourceLog)resources.elementAt(i2);
            if (!rl.isReserved()) {
                free[nb_free++] = rl.getResource();
            }
            ++i2;
        }
        return free;
    }

    public Vote prepare_vote(XID xid) {
        this.openLast();
        int vote = this.m_reader.prepare_vote(xid);
        if (vote == -1) {
            while (this.openPrevious() && (vote = this.m_reader.prepare_vote(xid)) == -1) {
            }
        }
        this.m_reader.close();
        return Vote.from_int(vote);
    }

    public boolean is_any_rollback(XID xid) {
        boolean rollback = false;
        this.openLast();
        int result = this.m_reader.is_any_rollback(xid);
        if (result == 0) {
            while (this.openPrevious() && (result = this.m_reader.is_any_rollback(xid)) == 0) {
            }
        }
        this.m_reader.close();
        if (result == 1) {
            rollback = true;
        }
        return rollback;
    }

    private void openLast() {
        if (this.m_reader != null) {
            this.m_reader.close();
        }
        if (this.m_last_log == null) {
            ORBLoader cfg = ((org.openorb.orb.core.ORB)this.m_orb).getLoader();
            String directory = null;
            try {
                directory = cfg.getStringProperty("OTS.log.directory");
            }
            catch (PropertyNotFoundException pnf) {
                this.getLogger().fatalError("Unable to get ots log directory");
                throw new INITIALIZE();
            }
            if (!directory.endsWith(File.separator)) {
                directory = directory + File.separator;
            }
            String lock_last = directory + "ots.log";
            try {
                FileInputStream lock = new FileInputStream(lock_last);
                DataInputStream reader = new DataInputStream(lock);
                this.m_last_log = reader.readUTF();
                reader.close();
                lock.close();
            }
            catch (IOException ex) {
                this.getLogger().error("Unable to read lock file for log !", (Throwable)ex);
            }
        }
        this.openReader(this.m_last_log);
    }

    private boolean openPrevious() {
        String previous_name = this.m_reader.previous_log();
        if (previous_name == null) {
            return false;
        }
        this.m_reader.close();
        this.openReader(previous_name);
        return true;
    }

    private void openReader(String log_name) {
        this.m_reader = new Reader(log_name, this.m_orb, this.getLogger());
    }

    private Logger getLogger() {
        return this.m_logger;
    }
}

