/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.ots.xa;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Vector;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import org.apache.avalon.framework.logger.ConsoleLogger;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.INVALID_TRANSACTION;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.Object;
import org.omg.CORBA.TRANSACTION_REQUIRED;
import org.omg.CosTransactions.Coordinator;
import org.omg.CosTransactions.CurrentHelper;
import org.omg.CosTransactions.Unavailable;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.omg.PortableInterceptor.ORBInitInfoPackage.InvalidName;
import org.openorb.orb.config.ORBLoader;
import org.openorb.orb.config.PropertyNotFoundException;
import org.openorb.orb.core.ORB;
import org.openorb.orb.pi.OpenORBInitInfo;
import org.openorb.ots.Impl.Current;
import org.openorb.ots.xa.ConnectionEntry;
import org.openorb.ots.xa.XAVirtualDataSource;

public class SessionManager
extends LocalObject
implements org.openorb.ots.SessionManager,
ConnectionEventListener,
LogEnabled {
    private Vector m_connections = new Vector();
    private Vector m_driver = new Vector();
    private XADataSource m_xa_source;
    private ORBInitInfo m_info;
    private ORBLoader m_cfg;
    private Logger m_logger = null;

    public SessionManager(ORBInitInfo info) {
        this.m_info = info;
        ORB openorb = ((OpenORBInitInfo)info).orb();
        this.m_cfg = openorb.getLoader();
    }

    public synchronized Connection getConnection(String name, String password, String profile) {
        XAConnection connection = null;
        org.omg.CosTransactions.Current current = null;
        Coordinator coordinator = null;
        try {
            Object obj = this.m_info.resolve_initial_references("TransactionCurrent");
            current = CurrentHelper.narrow(obj);
        }
        catch (InvalidName ex) {
            throw new TRANSACTION_REQUIRED();
        }
        if (current == null) {
            throw new TRANSACTION_REQUIRED();
        }
        switch (current.get_status().value()) {
            case 6: {
                coordinator = null;
                break;
            }
            case 0: {
                try {
                    coordinator = current.get_control().get_coordinator();
                }
                catch (Unavailable ex) {}
                break;
            }
            default: {
                throw new INVALID_TRANSACTION();
            }
        }
        connection = this.getConnection(name, profile, coordinator);
        if (connection == null) {
            connection = this.createConnection(name, password, profile, coordinator);
        }
        try {
            switch (current.get_status().value()) {
                case 6: {
                    connection.getConnection().setAutoCommit(true);
                    ((Current)current).registerXAConnection(connection);
                    break;
                }
                case 0: {
                    connection.getConnection().setAutoCommit(false);
                    ((Current)current).registerXAResource(connection.getXAResource(), null);
                }
            }
            return connection.getConnection();
        }
        catch (SQLException ex) {
            this.getLogger().error("Cannot get JDBC connection", (Throwable)ex);
            throw new INTERNAL();
        }
    }

    private synchronized XAConnection getConnection(String name, String profile, Coordinator coordinator) {
        ConnectionEntry entry = null;
        int i = 0;
        while (i < this.m_connections.size()) {
            entry = (ConnectionEntry)this.m_connections.elementAt(i);
            if (entry.getName().equals(name) && entry.isClosed() && entry.getProfile().equals(profile)) {
                if (entry.getCoordinator() == null) {
                    entry.setClosed(false);
                    entry.setCoordinator(coordinator);
                    return entry.getConnection();
                }
                if (entry.getCoordinator().hash_transaction() == coordinator.hash_transaction()) {
                    entry.setClosed(false);
                    return entry.getConnection();
                }
            }
            ++i;
        }
        return null;
    }

    private synchronized XAConnection createConnection(String name, String password, String profile, Coordinator coordinator) {
        ConnectionEntry entry = new ConnectionEntry(coordinator, name, profile);
        if (this.m_xa_source == null) {
            String load_driver = null;
            try {
                load_driver = this.m_cfg.getStringProperty(profile + ".JDBC.driver_loading");
            }
            catch (PropertyNotFoundException pnf) {
                this.getLogger().warn("Unable to find " + profile + ".JDBC.driver_loading property", (Throwable)pnf);
            }
            if (load_driver != null && load_driver.equalsIgnoreCase("true")) {
                try {
                    load_driver = this.m_cfg.getStringProperty(profile + ".JDBC.driver");
                }
                catch (PropertyNotFoundException pnf) {
                    this.getLogger().fatalError("Unable to determine driver name");
                }
                if (load_driver == null) {
                    this.getLogger().fatalError("OTS unable to get driver name");
                    throw new INITIALIZE();
                }
                if (!this.m_driver.contains(load_driver)) {
                    try {
                        Thread.currentThread().getContextClassLoader().loadClass(load_driver).newInstance();
                        this.m_driver.addElement(load_driver);
                    }
                    catch (Exception e) {
                        this.getLogger().fatalError("Unable to load jdbc driver: " + load_driver, (Throwable)e);
                        throw new INITIALIZE();
                    }
                }
            }
            String virtualXA = null;
            try {
                virtualXA = this.m_cfg.getStringProperty(profile + ".XA.VirtualXA");
            }
            catch (PropertyNotFoundException pnf) {
                this.getLogger().fatalError("Unable to find " + profile + ".XA.VirtualXA", (Throwable)pnf);
                throw new INITIALIZE();
            }
            if (virtualXA.equalsIgnoreCase("true")) {
                this.m_xa_source = new XAVirtualDataSource((org.omg.CORBA.ORB)((OpenORBInitInfo)this.m_info).orb(), this.getLogger());
                String jdbc_url = null;
                try {
                    jdbc_url = this.m_cfg.getStringProperty(profile + ".JDBC.url");
                }
                catch (PropertyNotFoundException pnf) {
                    this.getLogger().fatalError("Unable to find " + profile + ".JDBC.url property", (Throwable)pnf);
                    throw new INITIALIZE();
                }
                ((XAVirtualDataSource)this.m_xa_source).set_jdbc_url(jdbc_url);
            } else {
                this.m_xa_source = this.getXADataSourceFromJNDI(name, password);
            }
        }
        try {
            entry.setConnection(this.m_xa_source.getXAConnection(name, password));
        }
        catch (SQLException ex) {
            this.getLogger().fatalError("Unable to create an XA connection: " + ex.toString(), (Throwable)ex);
            throw new INTERNAL();
        }
        this.m_connections.addElement(entry);
        entry.getConnection().addConnectionEventListener(this);
        return entry.getConnection();
    }

    public void freeConnections(Coordinator coordinator) {
        ConnectionEntry entry = null;
        int i = 0;
        while (i < this.m_connections.size()) {
            entry = (ConnectionEntry)this.m_connections.elementAt(i);
            if (entry.getCoordinator() != null && entry.getCoordinator().hash_transaction() == coordinator.hash_transaction()) {
                entry.setCoordinator(null);
                Current.getXA().addElement(entry.getConnection());
                try {
                    entry.getConnection().getConnection().setAutoCommit(true);
                }
                catch (SQLException ex) {
                    // empty catch block
                }
            }
            ++i;
        }
    }

    public void updateConnection(XAConnection xa_connection, Coordinator coordinator) {
        ConnectionEntry entry = null;
        int i = 0;
        while (i < this.m_connections.size()) {
            entry = (ConnectionEntry)this.m_connections.elementAt(i);
            if (entry.getConnection() == xa_connection) {
                entry.setCoordinator(coordinator);
            }
            ++i;
        }
    }

    private XADataSource getXADataSourceFromJNDI(String name, String password) {
        return null;
    }

    public void connectionClosed(ConnectionEvent event) {
        ConnectionEntry entry = null;
        XAConnection connection = (XAConnection)event.getSource();
        int i = 0;
        while (i < this.m_connections.size()) {
            entry = (ConnectionEntry)this.m_connections.elementAt(i);
            if (entry.getConnection() == connection) {
                entry.setClosed(true);
                org.omg.CosTransactions.Current current = null;
                try {
                    Object obj = ((OpenORBInitInfo)this.m_info).orb().resolve_initial_references("TransactionCurrent");
                    current = CurrentHelper.narrow(obj);
                }
                catch (org.omg.CORBA.ORBPackage.InvalidName ex) {
                    throw new TRANSACTION_REQUIRED();
                }
                if (current == null) {
                    throw new TRANSACTION_REQUIRED();
                }
                ((Current)current).closeXAConnection(connection, true);
            }
            ++i;
        }
    }

    public void connectionErrorOccurred(ConnectionEvent event) {
        ConnectionEntry entry = null;
        XAConnection connection = (XAConnection)event.getSource();
        int i = 0;
        while (i < this.m_connections.size()) {
            entry = (ConnectionEntry)this.m_connections.elementAt(i);
            if (entry.getConnection() == connection) {
                entry.setClosed(true);
                org.omg.CosTransactions.Current current = null;
                try {
                    Object obj = ((OpenORBInitInfo)this.m_info).orb().resolve_initial_references("TransactionCurrent");
                    current = CurrentHelper.narrow(obj);
                }
                catch (org.omg.CORBA.ORBPackage.InvalidName ex) {
                    throw new TRANSACTION_REQUIRED();
                }
                if (current == null) {
                    throw new TRANSACTION_REQUIRED();
                }
                ((Current)current).closeXAConnection(connection, false);
            }
            ++i;
        }
    }

    public void enableLogging(Logger logger) {
        this.m_logger = logger;
    }

    public Logger getLogger() {
        if (this.m_logger == null) {
            return new ConsoleLogger();
        }
        return this.m_logger;
    }
}

