/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.ots.xa;

import java.sql.Connection;
import java.sql.SQLException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.omg.CORBA.NO_IMPLEMENT;
import org.openorb.ots.xa.XAVirtualConnection;

public class XAVirtualResource
implements XAResource {
    private Xid m_xid;
    private int m_timeout;
    private Connection m_sql_connection;
    private XAVirtualConnection m_xa_connection;

    public XAVirtualResource(Connection sql_connection, XAVirtualConnection xa_connection) {
        this.m_sql_connection = sql_connection;
        this.m_xa_connection = xa_connection;
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        if (this.m_xid == null) {
            throw new XAException("No transaction.");
        }
        if (!this.sameXID(xid)) {
            throw new XAException("Unable to mix transactions.");
        }
        try {
            this.m_sql_connection.commit();
        }
        catch (SQLException ex) {
            this.m_xa_connection.errorEvent(ex);
            throw new XAException("Unbale to commit the transaction.");
        }
    }

    public void end(Xid xid, int flags) throws XAException {
        if (this.m_xid == null) {
            throw new XAException("No transaction.");
        }
        if (!this.sameXID(xid)) {
            throw new XAException("Unable to mix transactions.");
        }
        this.m_xid = null;
    }

    public void forget(Xid xid) throws XAException {
        if (this.m_xid == null) {
            throw new XAException("No transaction.");
        }
        if (this.sameXID(xid)) {
            throw new XAException("Unable to mix transactions.");
        }
        this.m_xid = null;
    }

    public int getTransactionTimeout() throws XAException {
        return this.m_timeout;
    }

    public boolean isSameRM(XAResource xares) throws XAException {
        XAVirtualResource openorbXaRes;
        return xares instanceof XAVirtualResource && (openorbXaRes = (XAVirtualResource)xares).getResourceID() == this.getResourceID();
    }

    public int prepare(Xid xid) throws XAException {
        if (this.m_xid == null) {
            throw new XAException("No transaction.");
        }
        if (!this.sameXID(xid)) {
            throw new XAException("Unable to mix transactions.");
        }
        return 0;
    }

    public Xid[] recover(int flag) throws XAException {
        throw new NO_IMPLEMENT();
    }

    public void rollback(Xid xid) throws XAException {
        if (this.m_xid == null) {
            throw new XAException("No transaction.");
        }
        if (!this.sameXID(xid)) {
            throw new XAException("Unable to mix transactions.");
        }
        try {
            if (this.m_sql_connection.getAutoCommit()) {
                throw new XAException(7);
            }
        }
        catch (SQLException ex) {
            this.m_xa_connection.errorEvent(ex);
            throw new XAException("Unbale to known the autocommit value.");
        }
        try {
            this.m_sql_connection.rollback();
        }
        catch (SQLException ex) {
            this.m_xa_connection.errorEvent(ex);
            throw new XAException("Unbale to rollback the transaction.");
        }
    }

    public boolean setTransactionTimeout(int seconds) throws XAException {
        this.m_timeout = seconds;
        return true;
    }

    public void start(Xid xid, int flags) throws XAException {
        if (this.m_xid != null) {
            throw new XAException("Unable to mix transaction.");
        }
        this.m_xid = xid;
    }

    public int getResourceID() {
        return this.m_xa_connection.getDataSourceMetaData().hashCode();
    }

    public boolean sameXID(Xid xid) {
        if (this.m_xid == xid) {
            return true;
        }
        if (this.m_xid != null && xid != null) {
            if (this.m_xid.getFormatId() != xid.getFormatId()) {
                return false;
            }
            if (!this.sameArrays(this.m_xid.getGlobalTransactionId(), xid.getGlobalTransactionId())) {
                return false;
            }
            return this.sameArrays(this.m_xid.getBranchQualifier(), xid.getBranchQualifier());
        }
        return false;
    }

    private boolean sameArrays(byte[] array1, byte[] array2) {
        if (array1.length != array2.length) {
            return false;
        }
        return new String(array1).equals(new String(array2));
    }
}

