/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.orb.examples.any;

import org.omg.CORBA.Any;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.openorb.orb.examples.any.UnknownType;
import org.openorb.orb.examples.any._IPolymorphImplBase;
import org.openorb.orb.examples.any.longSeqHelper;
import org.openorb.orb.examples.any.person;
import org.openorb.orb.examples.any.personHelper;

public class Polymorph
extends _IPolymorphImplBase {
    public void pass(Any value) throws UnknownType {
        TypeCode tc = value.type();
        switch (this.getEquivalentKind(tc)) {
            case 3: {
                int l = value.extract_long();
                System.out.println(" A long value : " + l);
                break;
            }
            case 18: {
                String s = value.extract_string();
                System.out.println(" A string value : " + s);
                break;
            }
            case 8: {
                boolean b = value.extract_boolean();
                System.out.println(" A boolean value : " + b);
                break;
            }
            case 15: {
                if (tc.equal(personHelper.type())) {
                    person p = personHelper.extract(value);
                    System.out.println(" A person: ");
                    System.out.println(" Name = " + p.name);
                    System.out.println(" Surname = " + p.surname);
                    break;
                }
                throw new UnknownType();
            }
            case 19: {
                if (tc.equal(longSeqHelper.type())) {
                    int[] seq = longSeqHelper.extract(value);
                    System.out.println(" A long sequence value : ");
                    int i = 0;
                    while (i < seq.length) {
                        System.out.println(" Element " + i + " = " + seq[i]);
                        ++i;
                    }
                    break;
                }
                throw new UnknownType();
            }
            default: {
                throw new UnknownType();
            }
        }
    }

    private int getEquivalentKind(TypeCode tc) {
        switch (tc.kind().value()) {
            case 21: {
                try {
                    return tc.content_type().kind().value();
                }
                catch (BadKind ex) {
                    ex.printStackTrace();
                    return 0;
                }
            }
        }
        return tc.kind().value();
    }
}

