/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.orb.examples.dynany;

import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.DynamicAny.DynAny;
import org.omg.DynamicAny.DynAnyFactory;
import org.omg.DynamicAny.DynAnyFactoryHelper;
import org.omg.DynamicAny.DynAnyFactoryPackage.InconsistentTypeCode;
import org.omg.DynamicAny.DynArray;
import org.omg.DynamicAny.DynArrayHelper;
import org.omg.DynamicAny.DynSequence;
import org.omg.DynamicAny.DynSequenceHelper;
import org.omg.DynamicAny.DynStruct;
import org.omg.DynamicAny.DynStructHelper;
import org.omg.DynamicAny.NameValuePair;
import org.openorb.orb.examples.dynany.IPolymorphPOA;
import org.openorb.orb.examples.dynany.UnknownType;

public class DynPolymorph
extends IPolymorphPOA {
    public void pass(Any value) throws UnknownType {
        System.out.println("Method pass( " + value + " ) called!");
        TypeCode tc = value.type();
        switch (tc.kind().value()) {
            case 3: {
                int l = value.extract_long();
                System.out.println(" A long value : " + l);
                break;
            }
            case 2: {
                short sh = value.extract_short();
                System.out.println(" A short value : " + sh);
                break;
            }
            case 18: {
                String s = value.extract_string();
                System.out.println(" A string value : " + s);
                break;
            }
            case 8: {
                boolean b = value.extract_boolean();
                System.out.println(" A boolean value : " + b);
                break;
            }
            case 10: {
                byte octet = value.extract_octet();
                System.out.println(" An octet value : " + octet);
                break;
            }
            default: {
                this.scan_any(value);
            }
        }
    }

    private void scan_any(Any value) throws UnknownType {
        TypeCode tc = value.type();
        System.out.println("Type of any is " + tc);
        switch (this.getEquivalentKind(tc)) {
            case 15: {
                System.out.println("tk_struct detected");
                this.scan_struct(value);
                break;
            }
            case 19: {
                System.out.println("tk_sequence detected");
                this.scan_sequence(value);
                break;
            }
            case 20: {
                System.out.println("tk_array detected");
                this.scan_array(value);
                break;
            }
            default: {
                throw new UnknownType("Type is unknown!");
            }
        }
    }

    private int getEquivalentKind(TypeCode tc) {
        System.out.println("The eqiuvalent kind is " + tc.kind());
        switch (tc.kind().value()) {
            case 21: {
                try {
                    return tc.content_type().kind().value();
                }
                catch (BadKind ex) {
                    ex.printStackTrace();
                    return 0;
                }
            }
        }
        return tc.kind().value();
    }

    private void scan_struct(Any value) throws UnknownType {
        System.out.println("Getting DynAnyFactory...");
        DynAnyFactory factory = this.getDynAnyFactory();
        System.out.println("DynAnyFactory for struct is " + factory);
        DynAny dany = null;
        try {
            dany = factory.create_dyn_any(value);
        }
        catch (InconsistentTypeCode e) {
            System.out.println("Inconsistent typecode: " + (java.lang.Object)((java.lang.Object)e));
            System.exit(1);
        }
        DynStruct dstruct = DynStructHelper.narrow((Object)dany);
        NameValuePair[] members = dstruct.get_members();
        System.out.println("-------------------------------------------");
        System.out.println("Got a struct, scan each member :");
        int i = 0;
        while (i < members.length) {
            System.out.println("Member name : " + members[i].id);
            this.pass(members[i].value);
            ++i;
        }
        System.out.println("-------------------------------------------");
        System.out.println("");
    }

    private void scan_array(Any value) throws UnknownType {
        System.out.println("Getting DynAnyFactory...");
        DynAnyFactory factory = this.getDynAnyFactory();
        System.out.println("DynAnyFactory for array is " + factory);
        DynAny dany = null;
        try {
            dany = factory.create_dyn_any(value);
        }
        catch (InconsistentTypeCode e) {
            System.out.println("Inconsistent typecode: " + (java.lang.Object)((java.lang.Object)e));
            System.exit(1);
        }
        DynArray darray = DynArrayHelper.narrow((Object)dany);
        Any[] any_array = darray.get_elements();
        System.out.println("-------------------------------------------");
        System.out.println("Got an array, scan each element : ");
        int i = 0;
        while (i < any_array.length) {
            this.pass(any_array[i]);
            ++i;
        }
        System.out.println("-------------------------------------------");
        System.out.println("");
    }

    private void scan_sequence(Any value) throws UnknownType {
        System.out.println("Getting DynAnyFactory...");
        DynAnyFactory factory = this.getDynAnyFactory();
        System.out.println("DynAnyFactory for sequence is " + factory);
        DynAny dany = null;
        try {
            dany = factory.create_dyn_any(value);
        }
        catch (InconsistentTypeCode e) {
            System.out.println("Inconsistent typecode: " + (java.lang.Object)((java.lang.Object)e));
            System.exit(1);
        }
        DynSequence dseq = DynSequenceHelper.narrow((Object)dany);
        Any[] any_seq = dseq.get_elements();
        System.out.println("-------------------------------------------");
        System.out.println("Got a sequence, scan each member : ");
        int i = 0;
        while (i < any_seq.length) {
            this.pass(any_seq[i]);
            ++i;
        }
        System.out.println("-------------------------------------------");
        System.out.println("");
    }

    private DynAnyFactory getDynAnyFactory() {
        DynAnyFactory factory = null;
        try {
            System.out.println("Initializing ORB...");
            ORB orb = this._orb();
            System.out.println("Resolving DynAnyFactory...");
            Object obj = orb.resolve_initial_references("DynAnyFactory");
            System.out.println("Narrowing DynAnyFactory...");
            factory = DynAnyFactoryHelper.narrow((Object)obj);
        }
        catch (InvalidName ex) {
            System.out.println("Couldn't get DynAnyFactory!");
            System.exit(1);
        }
        return factory;
    }
}

