/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.orb.examples.idl.reflection;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import org.openorb.compiler.CompilerProperties;
import org.openorb.compiler.idl.reflect.idlAttribute;
import org.openorb.compiler.idl.reflect.idlObject;
import org.openorb.compiler.idl.reflect.idlOperation;
import org.openorb.compiler.object.IdlObject;
import org.openorb.compiler.parser.CompilationException;
import org.openorb.compiler.parser.IdlParser;

public final class Reflection {
    private Reflection() {
    }

    public static void displayHelp() {
        System.out.println("");
        System.out.println("");
        System.out.println("##################################################");
        System.out.println("#                                                #");
        System.out.println("#          OpenORB IDL Reflection Example        #");
        System.out.println("#                                                #");
        System.out.println("##################################################");
        System.out.println("");
        System.out.println("");
        System.out.println("Usage");
        System.out.println("-----");
        System.out.println("");
        System.out.println("\torg.openorb.orb.examples.orb.idl.reflection.Reflection idl_file_name");
        System.out.println("");
        System.out.println("Example");
        System.out.println("-------");
        System.out.println("\torg.openorb.orb.examples.orb.idl.reflection.Reflection reflection.idl");
        System.exit(0);
    }

    public static void generateHTML(Enumeration contents) {
        try {
            File htmlFile = new File("Reflection.html");
            PrintWriter writer = new PrintWriter(new FileOutputStream(htmlFile));
            writer.println("<html>\n<head>\n<title>OpenORB IDL Reflection - Generated HTML Page</title>\n</head>\n<body>");
            writer.println("<b>The following document was generated from an IDL file using the IDL Reflection.</b><br>");
            Reflection.addContents(contents, writer);
            writer.println("</body>\n</html>");
            writer.close();
        }
        catch (IOException ex) {
            System.out.println("[IDL Reflection Example] File error.");
            System.exit(0);
        }
    }

    public static void addContents(Enumeration contents, PrintWriter writer) {
        block6: while (contents.hasMoreElements()) {
            idlObject obj = (idlObject)contents.nextElement();
            switch (obj.idlType()) {
                case 17: {
                    if (((idlAttribute)obj).isReadOnly()) {
                        writer.println("readonly attribute ");
                    } else {
                        writer.println("attribute ");
                    }
                    writer.println(obj.idlName() + ";<br><br>");
                    break;
                }
                case 1: {
                    if (obj.idlName().equals("CORBA")) continue block6;
                    writer.println("module ");
                    writer.println("<font color=blue>" + obj.idlName() + "</font>{<br><br>");
                    Reflection.addContents(obj.content(), writer);
                    writer.println("<br>};<br><br>");
                    break;
                }
                case 15: {
                    writer.println("interface ");
                    writer.println("<font color=red>" + obj.idlName() + "</font>{<br><br>");
                    Reflection.addContents(obj.content(), writer);
                    writer.println("<br>};<br><br>");
                    break;
                }
                case 16: {
                    if (((idlOperation)obj).isOneway()) {
                        writer.println("oneway ");
                    }
                    writer.println("void <font color=green>" + obj.idlName() + "</font>();<br><br>");
                    break;
                }
            }
        }
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            Reflection.displayHelp();
        }
        System.out.println("[IDL Reflection Example] Generating HTML from IDL...");
        CompilerProperties cp = new CompilerProperties();
        IdlParser parser = new IdlParser(cp);
        IdlObject compilationGraph = null;
        int i = 0;
        while (i < args.length) {
            File file = new File(args[i]);
            try {
                compilationGraph = parser.compile_idl(file.getAbsolutePath());
            }
            catch (FileNotFoundException e) {
                throw new CompilationException("File " + file + " does not exist");
            }
            ++i;
        }
        if (parser.getTotalErrors() != 0 || compilationGraph == null) {
            System.out.println("[IDL Reflection Example] There are errors in the IDL file.");
            System.exit(0);
        }
        Reflection.generateHTML(compilationGraph.content());
        System.out.println("[IDL Reflection Example] HTML generated from IDL in file ReflectionEx.html.");
    }
}

