/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.orb.examples.messaging;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.Properties;
import org.omg.CORBA.Any;
import org.omg.CORBA.InvalidPolicies;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.PolicyError;
import org.omg.CORBA.PolicyManager;
import org.omg.CORBA.SetOverrideType;
import org.omg.CORBA.TIMEOUT;
import org.omg.TimeBase.TimeTHelper;
import org.openorb.orb.examples.messaging.ITimeout;
import org.openorb.orb.examples.messaging.ITimeoutHelper;

public final class Client {
    static /* synthetic */ Class class$org$openorb$orb$core$ORB;
    static /* synthetic */ Class class$org$openorb$orb$core$ORBSingleton;

    private Client() {
    }

    public static void main(String[] args) {
        Properties props = System.getProperties();
        ((Hashtable)props).put("org.openorb.PI.FeatureInitializerClass.org.openorb.orb.messaging.MessagingInitializer", "");
        ((Hashtable)props).put("org.omg.CORBA.ORBClass", (class$org$openorb$orb$core$ORB == null ? (class$org$openorb$orb$core$ORB = Client.class$("org.openorb.orb.core.ORB")) : class$org$openorb$orb$core$ORB).getName());
        ((Hashtable)props).put("org.omg.CORBA.ORBSingletonClass", (class$org$openorb$orb$core$ORBSingleton == null ? (class$org$openorb$orb$core$ORBSingleton = Client.class$("org.openorb.orb.core.ORBSingleton")) : class$org$openorb$orb$core$ORBSingleton).getName());
        ORB orb = ORB.init((String[])args, (Properties)props);
        Object obj = null;
        try {
            FileInputStream file = new FileInputStream("ObjectId");
            BufferedReader myInput = new BufferedReader(new InputStreamReader(file));
            String stringTarget = myInput.readLine();
            obj = orb.string_to_object(stringTarget);
        }
        catch (IOException ex) {
            System.out.println("File error");
            System.exit(1);
        }
        int timeout_msec = 6000;
        int wait_delta_msec = 2000;
        try {
            PolicyManager opm = (PolicyManager)orb.resolve_initial_references("ORBPolicyManager");
            Any time_any = orb.create_any();
            TimeTHelper.insert((Any)time_any, (long)(timeout_msec * 1000 * 10));
            Policy[] policies = new Policy[]{orb.create_policy(32, time_any)};
            opm.set_policy_overrides(policies, SetOverrideType.ADD_OVERRIDE);
        }
        catch (InvalidName invname_ex) {
            System.err.println("ORBPolicyManager wasn't found! (" + (java.lang.Object)((java.lang.Object)invname_ex) + ")");
            System.exit(1);
        }
        catch (PolicyError pol_ex) {
            System.err.println("A policy error occured: " + (java.lang.Object)((java.lang.Object)pol_ex));
            System.exit(1);
        }
        catch (InvalidPolicies invpol_ex) {
            System.err.println("An invalid policy has been specified: " + (java.lang.Object)((java.lang.Object)invpol_ex));
            System.exit(1);
        }
        ITimeout time = ITimeoutHelper.narrow(obj);
        try {
            System.out.println("1) Calling server...");
            time.waitForTimeout(timeout_msec - wait_delta_msec);
            System.out.println("1) Returned from server!");
        }
        catch (TIMEOUT ex) {
            System.out.println("The TIMEOUT exception should not occur here!");
        }
        try {
            System.out.println("2) Calling server...");
            time.waitForTimeout(timeout_msec + wait_delta_msec);
            System.out.println("2) Returned from server!");
        }
        catch (TIMEOUT ex) {
            System.out.println("The TIMEOUT exception occured as expected!");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

