/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.orb.examples.poa.AdapterActivator;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.PortableServer.AdapterActivator;
import org.omg.PortableServer.IdAssignmentPolicyValue;
import org.omg.PortableServer.LifespanPolicyValue;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.Servant;
import org.openorb.orb.examples.poa.AdapterActivator.AdpActivator;
import org.openorb.orb.examples.poa.AdapterActivator.Calculator;

public final class Server {
    private Server() {
    }

    public static void main(String[] args) {
        ORB orb = ORB.init((String[])args, null);
        POA rootPOA = null;
        try {
            Object objPoa = orb.resolve_initial_references("RootPOA");
            rootPOA = POAHelper.narrow((Object)objPoa);
        }
        catch (InvalidName ex) {
            System.out.println("Couldn't find RootPOA!");
            System.exit(1);
        }
        try {
            Policy[] policies = new Policy[]{rootPOA.create_lifespan_policy(LifespanPolicyValue.PERSISTENT), rootPOA.create_id_assignment_policy(IdAssignmentPolicyValue.USER_ID)};
            POA firstPOA = rootPOA.create_POA("firstPOA", rootPOA.the_POAManager(), policies);
            POA secondPOA = firstPOA.create_POA("secondPOA", rootPOA.the_POAManager(), policies);
            AdpActivator activator = new AdpActivator();
            rootPOA.the_activator((AdapterActivator)activator);
            Calculator calc = new Calculator();
            byte[] servantId = "myObject".getBytes();
            secondPOA.activate_object_with_id(servantId, (Servant)calc);
            Object obj = secondPOA.id_to_reference(servantId);
            String reference = orb.object_to_string(obj);
            try {
                FileOutputStream file = new FileOutputStream("ObjectId");
                PrintStream pfile = new PrintStream(file);
                pfile.println(reference);
            }
            catch (IOException ex) {
                System.out.println("Unable to export the server reference");
            }
            firstPOA.destroy(true, true);
            rootPOA.the_POAManager().activate();
            System.out.println("The server is ready...");
            orb.run();
        }
        catch (Exception ex) {
            System.out.println("An exception has been intercepted");
            ex.printStackTrace();
        }
    }
}

