/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.monitoring.common;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;

public class FileUtils {
    public static void sortByFileName(File[] files, boolean asc) {
        Comparator<File> comparator = new Comparator<File>(){

            @Override
            public int compare(File file1, File file2) {
                String filename1 = file1.getName();
                String filename2 = file2.getName();
                return filename1.compareTo(filename2);
            }
        };
        Arrays.sort(files, comparator);
    }

    public static List<String> fileToLines(String filename) {
        File file = new File(filename);
        return FileUtils.fileToLines(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> fileToLines(File file) {
        ArrayList<String> lines = new ArrayList<String>();
        if (file.exists() && file.canRead()) {
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new FileReader(file));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    lines.add(line);
                }
            }
            catch (Exception e) {
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Exception e) {}
                }
            }
        }
        return lines;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void linesToFile(Collection<Object> lines, File file) {
        if (!file.exists() || file.canWrite()) {
            PrintWriter writer = null;
            try {
                writer = new PrintWriter(file);
                for (Object line : lines) {
                    writer.println(line);
                }
            }
            catch (FileNotFoundException e) {
            }
            finally {
                if (writer != null) {
                    try {
                        writer.flush();
                    }
                    catch (Exception e) {}
                    try {
                        writer.close();
                    }
                    catch (Exception e) {}
                }
            }
        }
    }
}

