/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.monitoring.config;

import com.ericsson.cms.sites.monitoring.config.ConfigurationException;
import com.ericsson.cms.sites.monitoring.config.IPluginConfigurationParser;
import com.ericsson.cms.sites.monitoring.config.PluginConfiguration;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class ConfigurationManager<T extends PluginConfiguration> {
    private static final Logger logger = Logger.getLogger(ConfigurationManager.class.getName());
    private List<String> filesRead = new ArrayList<String>();

    public synchronized Map<String, T> configure(File configDirectory, IPluginConfigurationParser<T> configParser) throws ConfigurationException {
        HashMap<String, T> configurations = new HashMap<String, T>();
        if (configDirectory != null && configDirectory.exists()) {
            File[] files;
            for (File file : files = configDirectory.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.matches(".*.properties");
                }
            })) {
                String filePath = file.getAbsolutePath();
                if (this.filesRead.contains(filePath)) continue;
                this.filesRead.add(filePath);
                logger.info(String.format("Reading config file: %s", file.getPath()));
                FileReader reader = null;
                try {
                    reader = new FileReader(file);
                    T config = configParser.parseConfig(reader);
                    String key = config.getConfigurationId();
                    configurations.put(key, config);
                }
                catch (FileNotFoundException e) {
                    throw new ConfigurationException(e);
                }
                finally {
                    if (reader != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
        } else {
            String msg = String.format("Config Directory: '%s' Could not be found", configDirectory.getPath());
            throw new ConfigurationException(msg);
        }
        return configurations;
    }
}

