/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.monitoring.distribution;

import com.ericsson.cms.sites.core.entities.DistributionStatus;
import com.ericsson.cms.sites.monitoring.TitleAssetStatus;
import com.ericsson.cms.sites.monitoring.common.IAssetStatusBean;
import com.ericsson.cms.sites.monitoring.common.IStatusListener;
import com.ericsson.cms.sites.monitoring.common.IStatusQueryThread;
import com.ericsson.cms.sites.monitoring.common.SingleTaskTimer;
import com.ericsson.cms.sites.monitoring.config.ConfigurationException;
import com.ericsson.cms.sites.monitoring.config.ConfigurationManager;
import com.ericsson.cms.sites.monitoring.config.IPluginConfigurationParser;
import com.ericsson.cms.sites.monitoring.config.IStatusPluginConfiguration;
import com.ericsson.cms.sites.monitoring.plugins.StatusPluginBase;
import com.ericsson.cms.sites.monitoring.plugins.StatusPluginType;
import com.ericsson.cms.sites.monitoring.plugins.diststatusplugin.IDistributionStatusPlugin;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.PrintWriter;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.naming.InitialContext;
import org.apache.log4j.Logger;
import org.java.plugin.registry.PluginDescriptor;

public abstract class DistributionStatusPluginBase
extends StatusPluginBase
implements IStatusListener,
IDistributionStatusPlugin {
    protected static final Logger logger = Logger.getLogger((String)DistributionStatusPluginBase.class.getName());
    protected static final String TITLE_STATUS_QUEUE = "queue/TitleStatusQueue";
    protected static final int MAX_ITEMS_PER_MESSAGE = 10;
    public ConfigurationManager<IStatusPluginConfiguration> configurationManager = null;
    protected IPluginConfigurationParser<IStatusPluginConfiguration> configParser = null;
    protected Map<String, Map<String, String>> multiConfiguration = new HashMap<String, Map<String, String>>();
    protected Map<String, IStatusPluginConfiguration> configMap;
    protected Map<String, SingleTaskTimer<IStatusQueryThread>> timerMap = new HashMap<String, SingleTaskTimer<IStatusQueryThread>>();
    protected File configDirectory = null;
    protected StatusPluginType pluginType = StatusPluginType.DISTRIBUTION_STATUS;
    protected String name;
    protected File tempDirectory;
    protected Date lastAppStartTime;
    protected boolean started = false;
    protected boolean loaded;

    public DistributionStatus mapStatus(String mediaRoomStatus) {
        String status = mediaRoomStatus.toUpperCase();
        if ("FAILED".equals(status)) {
            return DistributionStatus.FAILED;
        }
        if ("SUCCEEDED".equals(status)) {
            return DistributionStatus.DISTRIBUTED;
        }
        return DistributionStatus.IN_PROGRESS;
    }

    public Map<String, Map<String, String>> getMultiConfiguration() {
        try {
            Map<String, IStatusPluginConfiguration> newConfigurationsMap = this.configurationManager.configure(this.configDirectory, this.configParser);
            if (newConfigurationsMap.size() > 0) {
                logger.info((Object)"New Configurations Added");
            }
            this.multiConfiguration.putAll(this.translateConfig(newConfigurationsMap));
            this.startTimers(newConfigurationsMap);
        }
        catch (ConfigurationException e) {
            logger.error((Object)"Exception while reading the configuration file", (Throwable)e);
        }
        return this.multiConfiguration;
    }

    public void setMultiConfiguration(Map<String, Map<String, String>> multiConfiguration) {
        this.multiConfiguration = multiConfiguration;
    }

    public StatusPluginType getPluginType() {
        return this.pluginType;
    }

    public void start() {
        this._start();
    }

    public void stop() {
        this._stop();
    }

    protected void locateHomeDirectories(ClassLoader loader, PluginDescriptor desc) throws URISyntaxException {
        if (desc != null && desc.getLocation() != null) {
            URL pluginRootDirUrl = desc.getLocation();
            File pluginXml = new File(pluginRootDirUrl.toURI());
            File pluginRootDir = pluginXml.getParentFile();
            logger.info((Object)String.format("Plugin Root directory set to: %s", pluginRootDir.getPath()));
            this.configDirectory = new File(pluginRootDir, "config");
            logger.info((Object)String.format("Plugin Config directory set to: %s", this.configDirectory.getPath()));
            this.tempDirectory = new File(pluginRootDir, "temp");
            this.setId(desc.getId());
            this.name = desc.getAttribute("name").getValue();
        } else {
            URL pluginRootDirUrl = loader.getResource("");
            URL configDirUrl = loader.getResource("config");
            File pluginRootDir = new File(pluginRootDirUrl.toURI());
            logger.info((Object)String.format("Plugin Root directory set to: %s", pluginRootDir.getPath()));
            this.configDirectory = new File(configDirUrl.toURI());
            logger.info((Object)String.format("Plugin Config directory set to: %s", this.configDirectory.getPath()));
            this.tempDirectory = new File(pluginRootDir, "temp");
        }
    }

    protected synchronized void stopAllTimers() {
        for (Map.Entry<String, SingleTaskTimer<IStatusQueryThread>> e : this.timerMap.entrySet()) {
            SingleTaskTimer<IStatusQueryThread> timer = e.getValue();
            timer.cancel();
            try {
                timer.join();
            }
            catch (InterruptedException ie) {
                logger.error((Object)"in _stop()", (Throwable)ie);
            }
        }
        logger.info((Object)"All timer threads stopped");
    }

    protected synchronized void _stop() {
        if (!this.started) {
            logger.warn((Object)"In MediaRoomStatusPlugin Already stopped");
            return;
        }
        this.stopAllTimers();
        this.started = false;
    }

    public void startMonitoring(String configId, Collection<String> externalIds) {
        SingleTaskTimer<IStatusQueryThread> timer = this.timerMap.get(configId);
        if (timer != null) {
            timer.getTask().getExternalIds().addAll(externalIds);
        } else {
            logger.warn((Object)("Could not start monitoring configId: " + configId));
        }
    }

    public void stopMonitoring(String configId, Collection<String> externalIds, boolean dissociatedFlag) {
        SingleTaskTimer<IStatusQueryThread> timer = this.timerMap.get(configId);
        timer.getTask().getExternalIds().removeAll(externalIds);
    }

    protected List<IAssetStatusBean> getReportedStatuses(List<? extends IAssetStatusBean> statusChangesList) {
        ArrayList<IAssetStatusBean> reportedStatuses = new ArrayList<IAssetStatusBean>();
        for (int i = 0; i < statusChangesList.size(); ++i) {
            IAssetStatusBean statusBean = statusChangesList.get(i);
            DistributionStatus distStatus = this.mapStatus(statusBean.getStatus());
            if (distStatus != DistributionStatus.FAILED && distStatus != DistributionStatus.DISTRIBUTED) continue;
            reportedStatuses.add(statusBean);
        }
        return reportedStatuses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void statusChanged(IStatusQueryThread thread, List<? extends IAssetStatusBean> originalStatusChangesList) {
        Set<String> extIds = thread.getExternalIds();
        String firstExtId = extIds != null && extIds.size() > 0 ? (String)extIds.toArray()[0] : "";
        List<IAssetStatusBean> statusChangesList = this.getReportedStatuses(originalStatusChangesList);
        if (statusChangesList.size() == 0) {
            logger.debug((Object)"No title status Messages to send to JMS queue");
            return;
        }
        QueueConnection connection = null;
        QueueSession session = null;
        QueueSender sender = null;
        try {
            logger.debug((Object)"sending title status to JMS queue");
            InitialContext context = new InitialContext();
            QueueConnectionFactory queueFactory = (QueueConnectionFactory)context.lookup("ConnectionFactory");
            connection = queueFactory.createQueueConnection();
            session = connection.createQueueSession(false, 1);
            Queue queue = (Queue)context.lookup(TITLE_STATUS_QUEUE);
            sender = session.createSender(queue);
            for (int fromIndex = 0; fromIndex < statusChangesList.size(); fromIndex += 10) {
                int toIndex = fromIndex + 10 > statusChangesList.size() ? statusChangesList.size() : fromIndex + 10;
                ObjectMessage message = session.createObjectMessage();
                this.perpareJmsMessage(statusChangesList.subList(fromIndex, toIndex), firstExtId, (Message)message);
                sender.send(queue, (Message)message);
            }
        }
        catch (Exception e) {
            logger.warn((Object)"In sendToQueue()", (Throwable)e);
        }
        finally {
            try {
                connection.close();
            }
            catch (Exception e1) {
                logger.warn((Object)"Problems cleaning up after sending message", (Throwable)e1);
            }
        }
    }

    protected void display(Set<String> extIds, List<? extends IAssetStatusBean> statusChangesList) {
        for (String string : extIds) {
            System.out.printf("ExtId: %s%n", string);
        }
        for (IAssetStatusBean iAssetStatusBean : statusChangesList) {
            System.out.printf("statuBean: %s%n", iAssetStatusBean);
        }
    }

    protected void perpareJmsMessage(List<? extends IAssetStatusBean> statusChangesList, String firstExtId, Message message) throws Exception {
        message.setStringProperty("status_plugin_type", StatusPluginType.DISTRIBUTION_STATUS.name());
        message.setIntProperty("results_count", statusChangesList.size());
        for (int i = 0; i < statusChangesList.size(); ++i) {
            IAssetStatusBean info = statusChangesList.get(i);
            message.setStringProperty("ext_id_" + Integer.toString(i), firstExtId);
            message.setStringProperty("asset_id_" + Integer.toString(i), info.getAssetID());
            message.setStringProperty("provider_id_" + Integer.toString(i), info.getProviderID());
            message.setStringProperty("status_" + Integer.toString(i), this.mapStatus(info.getStatus()).toString());
        }
    }

    @Override
    public void callCompleted(IStatusQueryThread thread) {
        String threadId = thread.getId();
        Date lastUpdateTime = thread.getLastUpdate();
        if (lastUpdateTime != null) {
            this.persistLastUpdateTime(threadId, lastUpdateTime);
        }
    }

    @Override
    public void callStarted(IStatusQueryThread thread) {
        logger.debug((Object)("Thread: " + thread.getId() + " was called by the timer."));
    }

    protected void doStart() throws Exception {
        this._start();
    }

    protected void doStop() throws Exception {
        this._stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void persistLastUpdateTime(String threadId, Date lastUpdateTime) {
        String filename;
        File threadLastUpdateFile;
        if (this.tempDirectory != null && (!(threadLastUpdateFile = new File(this.tempDirectory, filename = this.getThreadTimeFilename(threadId))).exists() || threadLastUpdateFile.canWrite())) {
            PrintWriter writer = null;
            try {
                writer = new PrintWriter(threadLastUpdateFile);
                writer.println(Long.toString(lastUpdateTime.getTime()));
            }
            catch (FileNotFoundException e) {
                logger.warn((Object)"Cannot presist Plugin Thread Time", (Throwable)e);
            }
            finally {
                if (writer != null) {
                    try {
                        writer.flush();
                    }
                    catch (Exception e) {
                        logger.warn((Object)"Cannot Flush Stream", (Throwable)e);
                    }
                    try {
                        writer.close();
                    }
                    catch (Exception e) {
                        logger.warn((Object)"Cannot Close File", (Throwable)e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Date getLastUpdateDate(String threadId) {
        Date lastUpdate = null;
        String filename = this.getThreadTimeFilename(threadId);
        File threadLastUpdateFile = new File(this.tempDirectory, filename);
        if (this.tempDirectory != null && threadLastUpdateFile.exists() && threadLastUpdateFile.canWrite()) {
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new FileReader(threadLastUpdateFile));
                String strTime = reader.readLine();
                long time = Long.parseLong(strTime);
                lastUpdate = new Date(time);
            }
            catch (Exception e) {
                logger.error((Object)"Error Reading Plugin Thread Time", (Throwable)e);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Exception e) {
                        logger.warn((Object)"Cannot Close File", (Throwable)e);
                    }
                }
            }
        }
        return lastUpdate;
    }

    protected String getThreadTimeFilename(String threadId) {
        return threadId + ".time";
    }

    protected void showStatus(List<TitleAssetStatus> statusList) {
        for (TitleAssetStatus status : statusList) {
            Map entries = status.getKeys();
            for (String key : entries.keySet()) {
                String value = (String)entries.get(key);
                logger.info((Object)String.format("%s=%s%n", key, value));
            }
        }
    }

    public void setAppStartTime(Date value) {
        this.lastAppStartTime = value;
        for (String key : this.timerMap.keySet()) {
            SingleTaskTimer<IStatusQueryThread> timer = this.timerMap.get(key);
            IStatusQueryThread thread = timer.getTask();
            Date lastUpdateTime = thread.getLastUpdate();
            if (lastUpdateTime != null) continue;
            thread.setLastUpdate(this.lastAppStartTime);
        }
    }

    public Date getAppStartTime() {
        return this.lastAppStartTime;
    }

    public String getName() {
        return this.name;
    }

    public void setPluginType(StatusPluginType statusPluginType) {
        this.pluginType = statusPluginType;
    }

    protected abstract void _start();

    protected abstract void startTimers(Map<String, IStatusPluginConfiguration> var1);

    protected abstract Map<String, Map<String, String>> translateConfig(Map<String, IStatusPluginConfiguration> var1);
}

