/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.cms.sites.monitoring.distribution.mediaroom;

import com.ericsson.cms.sites.monitoring.common.AssetStatusBean;
import com.ericsson.cms.sites.monitoring.common.IAssetStatusBean;
import com.ericsson.cms.sites.monitoring.common.IStatusQueryResult;
import com.ericsson.cms.sites.monitoring.common.IStatusQueryServiceFacade;
import com.ericsson.cms.sites.monitoring.common.StatusQueryResult;
import com.ericsson.cms.sites.monitoring.distribution.mediaroom.ws.Vod.Oss.TV2.Microsoft.OssVodBackendWSSoapStub;
import com.ericsson.cms.sites.monitoring.distribution.mediaroom.ws.Vod.Oss.TV2.Microsoft.holders.ArrayOfStatusInformationHolder;
import com.ericsson.cms.sites.monitoring.distribution.mediaroom.ws.microsoft.www.tv2.server.vod.AssetStatus;
import com.ericsson.cms.sites.monitoring.distribution.mediaroom.ws.microsoft.www.tv2.server.vod.StatusInformation;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.TimeZone;
import javax.xml.rpc.ServiceException;
import javax.xml.rpc.holders.LongHolder;
import org.apache.log4j.Logger;

public class AxisStatusQueryServiceFacade
implements IStatusQueryServiceFacade {
    private static final Logger logger = Logger.getLogger((String)AxisStatusQueryServiceFacade.class.getName());
    boolean includeExpiredAssets = false;
    boolean filterByStatus = false;
    String filterStatus = "";
    String targetEndpoint = "";

    public AxisStatusQueryServiceFacade(boolean includeExpiredAssets, boolean filterByStatus, String filterStatus, String targetEndpoint) {
        this.includeExpiredAssets = includeExpiredAssets;
        this.filterByStatus = filterByStatus;
        this.filterStatus = filterStatus;
        this.targetEndpoint = targetEndpoint;
    }

    public boolean isIncludeExpiredAssets() {
        return this.includeExpiredAssets;
    }

    public void setIncludeExpiredAssets(boolean includeExpiredAssets) {
        this.includeExpiredAssets = includeExpiredAssets;
    }

    public boolean isFilterByStatus() {
        return this.filterByStatus;
    }

    public void setFilterByStatus(boolean filterByStatus) {
        this.filterByStatus = filterByStatus;
    }

    public String getFilterStatus() {
        return this.filterStatus;
    }

    public void setFilterStatus(String filterStatus) {
        this.filterStatus = filterStatus;
    }

    public String getTargetEndpoint() {
        return this.targetEndpoint;
    }

    public void setTargetEndpoint(String targetEndpoint) {
        this.targetEndpoint = targetEndpoint;
    }

    @Override
    public IStatusQueryResult getAssetStatus(long startIndex) throws SecurityException, IOException, ServiceException {
        ArrayList<IAssetStatusBean> assetStatusList = null;
        OssVodBackendWSSoapStub service = new OssVodBackendWSSoapStub(new URL(this.targetEndpoint), null);
        LongHolder nextIndex = new LongHolder(startIndex);
        ArrayOfStatusInformationHolder result = new ArrayOfStatusInformationHolder();
        try {
            service.getBackendAssetStatus(this.includeExpiredAssets, this.filterByStatus, AssetStatus.fromString(this.filterStatus), startIndex, result, nextIndex);
        }
        catch (Exception ex) {
            logger.error((Object)"Error trying to make an Axis webservice call", (Throwable)ex);
        }
        StatusInformation[] infoArray = result.value;
        assetStatusList = new ArrayList<IAssetStatusBean>(infoArray.length);
        for (StatusInformation si : infoArray) {
            String assetId = si.getAssetID();
            String providerId = si.getProviderID();
            String status = si.getStatus().toString();
            Calendar gmtCalendar = si.getModifiedDateTime();
            gmtCalendar.setTimeZone(TimeZone.getTimeZone("GMT"));
            AssetStatusBean statusBean = new AssetStatusBean(assetId, providerId, status, gmtCalendar.getTimeInMillis());
            assetStatusList.add(statusBean);
        }
        return new StatusQueryResult(assetStatusList, nextIndex.value);
    }
}

